/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.interval.ProteinInteractionLocus;
import org.snpeff.snpEffect.testCases.unity.TestCasesBaseApply;
import org.snpeff.util.Gpr;

public class TestCasesProteinInteraction
extends TestCasesBaseApply {
    @Test
    public void test_01_split_codon_base() {
        Gpr.debug("Test");
        this.initSnpEffPredictor();
        if (this.verbose) {
            Gpr.debug(this.transcript);
        }
        String protein = this.transcript.protein();
        int codonNum = 33;
        int[] codonsPos = this.transcript.codonNumber2Pos(codonNum);
        if (this.verbose) {
            Gpr.debug("AA[" + codonNum + "]: " + protein.charAt(codonNum) + "\t" + codonsPos[0] + "\t" + codonsPos[1] + "\t" + codonsPos[2]);
        }
        List<ProteinInteractionLocus> list2 = ProteinInteractionLocus.factory(this.transcript, codonNum, this.transcript, "POS_" + codonNum);
        if (this.verbose) {
            for (ProteinInteractionLocus pil : list2) {
                Gpr.debug("Interaction locus: " + pil);
            }
        }
        Assert.assertEquals("Number of loci do not match", 2, list2.size());
        ProteinInteractionLocus pil = list2.get(0);
        Assert.assertTrue("Interactions coordinates do not match: " + pil, pil.getStart() == 199 && pil.getEnd() == 199);
        pil = list2.get(1);
        Assert.assertTrue("Interactions coordinates do not match: " + pil, pil.getStart() == 300 && pil.getEnd() == 301);
    }

    @Test
    public void test_02_split_codon_base() {
        Gpr.debug("Test");
        this.initSnpEffPredictor();
        if (this.verbose) {
            Gpr.debug(this.transcript);
        }
        String protein = this.transcript.protein();
        int codonNum = 66;
        int[] codonsPos = this.transcript.codonNumber2Pos(codonNum);
        if (this.verbose) {
            Gpr.debug("AA[" + codonNum + "]: " + protein.charAt(codonNum) + "\t" + codonsPos[0] + "\t" + codonsPos[1] + "\t" + codonsPos[2]);
        }
        List<ProteinInteractionLocus> list2 = ProteinInteractionLocus.factory(this.transcript, codonNum, this.transcript, "POS_" + codonNum);
        if (this.verbose) {
            for (ProteinInteractionLocus pil : list2) {
                Gpr.debug("Interaction locus: " + pil);
            }
        }
        Assert.assertEquals("Number of loci do not match", 2, list2.size());
        ProteinInteractionLocus pil = list2.get(0);
        Assert.assertTrue("Interactions coordinates do not match: " + pil, pil.getStart() == 398 && pil.getEnd() == 399);
        pil = list2.get(1);
        Assert.assertTrue("Interactions coordinates do not match: " + pil, pil.getStart() == 900 && pil.getEnd() == 900);
    }
}

