/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.util.HashMap;
import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.SnpEff;
import org.snpeff.align.SmithWaterman;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.snpEffect.commandLine.SnpEffCmdBuild;
import org.snpeff.snpEffect.testCases.integration.TestCasesIntegrationBase;
import org.snpeff.util.Gpr;

public class TestCasesIntegrationRefSeq
extends TestCasesIntegrationBase {
    @Test
    public void test_01() {
        Gpr.debug("Test");
        String genome = "hg19";
        String refSeqFile = "tests/hg19_refSeq_OR4F16.txt";
        String fastaFile = null;
        String resultFile = "tests/hg19_refSeq_OR4F16.dump.txt";
        SnpEffectPredictor sep = this.buildAndCompare(genome, refSeqFile, fastaFile, resultFile, true);
        sep.buildForest();
        Variant seqChange = new Variant((Marker)sep.getGenome().getChromosome("1"), 521603, "A", "G");
        VariantEffects effs = sep.variantEffect(seqChange);
        for (VariantEffect eff : effs) {
            if (this.verbose) {
                System.out.println("\t" + eff);
            }
            Assert.assertEquals((Object)eff.getEffectType(), (Object)EffectType.INTERGENIC);
        }
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        String genome = "testNM_015296";
        String[] args = new String[]{"build", genome};
        SnpEff snpeff = new SnpEff(args);
        snpeff.setDebug(this.debug);
        snpeff.setVerbose(this.verbose);
        SnpEffCmdBuild snpeffBuild = (SnpEffCmdBuild)snpeff.cmd();
        snpeffBuild.setStoreAlignments(true);
        snpeffBuild.setCheckNumOk(false);
        snpeffBuild.run();
        HashMap<String, SmithWaterman> alignmentByTrId = snpeffBuild.getSnpEffCmdProtein().getAlignmentByTrId();
        SmithWaterman sw = alignmentByTrId.get("NM_015296.2");
        if (this.debug) {
            Gpr.debug(sw.getAlignmentScore() + "\n" + sw);
        }
        Assert.assertTrue(sw.getAlignmentScore() >= 2061);
    }
}

