/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.SnpEff;
import org.snpeff.snpEffect.commandLine.SnpEffCmdEff;
import org.snpeff.snpEffect.testCases.integration.TestCasesIntegrationBase;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class TestCasesIntegrationCancer
extends TestCasesIntegrationBase {
    @Test
    public void test_01() {
        Gpr.debug("Test");
        String file = "tests/integration/cancer/test.cancer.snp.01.vcf";
        this.snpEffectCancer(file, null, "testHg3766Chr1", true, "p.Leu1?", "c.1C>G", "G-C", null);
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        String fileVcf = "tests/integration/cancer/test.cancer_no_ped.vcf";
        String fileTxt = "tests/integration/cancer/test.cancer_no_ped.txt";
        this.snpEffectCancer(fileVcf, fileTxt, "testHg3766Chr1", true, "p.Leu1?", "c.1C>G", "G-C", null);
    }

    @Test
    public void test_03_cancer_concurrent_modification() {
        Gpr.debug("Test");
        String[] args = new String[]{"-cancer", "-cancerSamples", "tests/integration/cancer/test_cancer_concurrent_modification.txt", "-ud", "0", "-strict", "testHg3775Chr1", "tests/integration/cancer/test_cancer_concurrent_modification.vcf"};
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff snpeff = (SnpEffCmdEff)cmd.cmd();
        snpeff.setSupressOutput(!this.verbose);
        snpeff.setVerbose(this.verbose);
        List<VcfEntry> vcfEnties = snpeff.run(true);
        Assert.assertFalse("Annotation finished with errors", snpeff.getTotalErrs() > 0);
        int countCancer = 0;
        int countCancerWarnings = 0;
        for (VcfEntry ve : vcfEnties) {
            if (this.verbose) {
                System.out.println(ve);
            }
            List<VcfEffect> veffs = ve.getVcfEffects();
            for (VcfEffect veff : veffs) {
                if (this.verbose) {
                    System.out.println("\t" + veff.getAllele() + "\t" + veff);
                }
                if (veff.getAllele().indexOf(45) <= 0) continue;
                ++countCancer;
                if (this.verbose) {
                    System.out.println("\t\t" + veff.getErrorsWarning());
                }
                if (veff.getErrorsWarning() == null || veff.getErrorsWarning().isEmpty()) continue;
                ++countCancerWarnings;
            }
        }
        Assert.assertTrue("Cancer effects not found", countCancer > 0);
        Assert.assertTrue("There should be no warnings: countCancerWarnings = " + countCancerWarnings, countCancerWarnings == 0);
    }

    @Test
    public void test_04() {
        Gpr.debug("Test");
        String file = "tests/integration/cancer/test_04.vcf";
        this.snpEffectCancer(file, null, "testHg19Chr22", false, "p.Gln133Leu", "c.398A>T", "A-T", null);
    }

    @Test
    public void test_05() {
        Gpr.debug("Test");
        String file = "tests/integration/cancer/test.cancer_05.vcf";
        this.snpEffectCancer(file, null, "testHg19Chr17", false, "p.Arg72Pro", "c.215G>C", "G-C", "NM_000546.5");
    }
}

