/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.factory;

import java.io.BufferedReader;
import java.util.List;
import org.snpeff.collections.MultivalueHashMap;
import org.snpeff.interval.BioType;
import org.snpeff.interval.Cds;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Exon;
import org.snpeff.interval.FrameType;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactory;
import org.snpeff.util.Gpr;

public class SnpEffPredictorFactoryKnownGene
extends SnpEffPredictorFactory {
    public static final String CDS_STAT_COMPLETE = "cmpl";
    int ignoredTr = 0;
    MultivalueHashMap<String, Gene> genesByName = new MultivalueHashMap();

    public SnpEffPredictorFactoryKnownGene(Config config) {
        super(config, 0);
        this.frameType = FrameType.UCSC;
        this.frameCorrection = true;
    }

    @Override
    public SnpEffectPredictor create() {
        try {
            if (this.fileName == null) {
                this.fileName = this.config.getBaseFileNameGenes() + ".kg";
            }
            System.out.println("Reading gene intervals file : '" + this.fileName + "'");
            this.readRefSeqFile();
            this.beforeExonSequences();
            if (this.readSequences) {
                this.readExonSequences();
            } else if (this.createRandSequences) {
                this.createRandSequences();
            }
            this.finishUp();
            if (this.verbose) {
                System.out.println(this.config.getGenome());
                System.out.println("# Ignored transcripts        : " + this.ignoredTr);
            }
        }
        catch (Exception e) {
            if (this.verbose) {
                e.printStackTrace();
            }
            throw new RuntimeException("Error reading file '" + this.fileName + "'\n" + e);
        }
        return this.snpEffectPredictor;
    }

    Gene findOrCreateGene(String geneName, String trId, Chromosome chromo, int start, int end, boolean strandMinus, boolean isCoding) {
        Gene gene2;
        Marker tr = new Marker(chromo, start, end, strandMinus, trId);
        List genes = (List)this.genesByName.get(geneName);
        int geneIndex = 0;
        if (genes != null) {
            for (Gene gene2 : genes) {
                if (!gene2.intersects(tr)) continue;
                if (start < gene2.getStart()) {
                    gene2.setStart(start);
                }
                if (gene2.getEnd() < end) {
                    gene2.setEnd(end);
                }
                return gene2;
            }
            geneIndex = genes.size() + 1;
        }
        String geneId = geneName + (geneIndex > 0 ? "." + geneIndex : "");
        gene2 = new Gene(chromo, start, end, strandMinus, geneId, geneName, BioType.coding(isCoding));
        this.genesByName.add(geneName, gene2);
        this.add(gene2);
        return gene2;
    }

    protected void readRefSeqFile() {
        try {
            int count2 = 0;
            BufferedReader reader = Gpr.reader(this.fileName);
            if (reader == null) {
                return;
            }
            this.lineNum = 1;
            while (reader.ready()) {
                String[] fields;
                this.line = reader.readLine();
                if (!this.line.startsWith("#") && (fields = this.line.split("\t")).length >= 9) {
                    int fieldNum = 0;
                    String id = fields[fieldNum++];
                    String chromoName = fields[fieldNum++];
                    boolean strandMinus = fields[fieldNum++].equals("-");
                    int txstart = this.parsePosition(fields[fieldNum++]);
                    int txend = this.parsePosition(fields[fieldNum++]) - 1;
                    int cdsStart = this.parsePosition(fields[fieldNum++]);
                    int cdsEnd = this.parsePosition(fields[fieldNum++]) - 1;
                    int exonCount = Gpr.parseIntSafe(fields[fieldNum++]);
                    String exonStarts = fields[fieldNum++];
                    String exonEnds = fields[fieldNum++];
                    String proteinId = fields[fieldNum++];
                    Chromosome chromo = this.getOrCreateChromosome(chromoName);
                    boolean isCoding = !proteinId.isEmpty();
                    String trId = this.uniqueTrId(id);
                    Gene gene = this.findOrCreateGene(proteinId, trId, chromo, txstart, txend, strandMinus, isCoding);
                    Transcript tr = new Transcript(gene, txstart, txend, strandMinus, trId);
                    tr.setProteinCoding(isCoding);
                    this.add(tr);
                    String[] exStartStr = exonStarts.split(",");
                    String[] exEndStr = exonEnds.split(",");
                    for (int i = 0; i < exonCount; ++i) {
                        int exStart = this.parsePosition(exStartStr[i]);
                        int exEnd = this.parsePosition(exEndStr[i]) - 1;
                        String exId = trId + ".ex." + (i + 1);
                        Exon ex = new Exon(tr, exStart, exEnd, strandMinus, exId, i);
                        this.add(ex);
                        if (exStart > cdsEnd || exEnd < cdsStart) continue;
                        Cds cds = new Cds(tr, Math.max(cdsStart, exStart), Math.min(cdsEnd, exEnd), strandMinus, exId);
                        this.add(cds);
                    }
                    if (++count2 % 100 == 0) {
                        System.out.print('.');
                    }
                    if (count2 % 10000 == 0) {
                        System.out.print("\n\t");
                    }
                }
                ++this.lineNum;
            }
            reader.close();
        }
        catch (Exception e) {
            Gpr.debug("Offending line (lineNum: " + this.lineNum + "): '" + this.line + "'");
            throw new RuntimeException(e);
        }
    }

    String uniqueTrId(String id) {
        if (!this.transcriptsById.containsKey(id)) {
            return id;
        }
        int i = 2;
        String trId;
        while (this.transcriptsById.containsKey(trId = id + "." + i)) {
            ++i;
        }
        return trId;
    }
}

