/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.util.Arrays;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.NotFiniteNumberException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;

public final class MathUtils {
    public static final double TWO_PI = Math.PI * 2;

    private MathUtils() {
    }

    public static int hash(double value2) {
        return new Double(value2).hashCode();
    }

    public static int hash(double[] value2) {
        return Arrays.hashCode(value2);
    }

    public static double normalizeAngle(double a, double center) {
        return a - Math.PI * 2 * FastMath.floor((a + Math.PI - center) / (Math.PI * 2));
    }

    public static double reduce(double a, double period, double offset) {
        double p = FastMath.abs(period);
        return a - p * FastMath.floor((a - offset) / p) - offset;
    }

    public static byte copySign(byte magnitude, byte sign2) throws MathArithmeticException {
        if (magnitude >= 0 && sign2 >= 0 || magnitude < 0 && sign2 < 0) {
            return magnitude;
        }
        if (sign2 >= 0 && magnitude == -128) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        return -magnitude;
    }

    public static short copySign(short magnitude, short sign2) throws MathArithmeticException {
        if (magnitude >= 0 && sign2 >= 0 || magnitude < 0 && sign2 < 0) {
            return magnitude;
        }
        if (sign2 >= 0 && magnitude == Short.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        return -magnitude;
    }

    public static int copySign(int magnitude, int sign2) throws MathArithmeticException {
        if (magnitude >= 0 && sign2 >= 0 || magnitude < 0 && sign2 < 0) {
            return magnitude;
        }
        if (sign2 >= 0 && magnitude == Integer.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        return -magnitude;
    }

    public static long copySign(long magnitude, long sign2) throws MathArithmeticException {
        if (magnitude >= 0L && sign2 >= 0L || magnitude < 0L && sign2 < 0L) {
            return magnitude;
        }
        if (sign2 >= 0L && magnitude == Long.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        return -magnitude;
    }

    public static void checkFinite(double x2) throws NotFiniteNumberException {
        if (Double.isInfinite(x2) || Double.isNaN(x2)) {
            throw new NotFiniteNumberException(x2, new Object[0]);
        }
    }

    public static void checkFinite(double[] val) throws NotFiniteNumberException {
        for (int i = 0; i < val.length; ++i) {
            double x2 = val[i];
            if (!Double.isInfinite(x2) && !Double.isNaN(x2)) continue;
            throw new NotFiniteNumberException((Localizable)LocalizedFormats.ARRAY_ELEMENT, x2, i);
        }
    }

    public static void checkNotNull(Object o, Localizable pattern, Object ... args) throws NullArgumentException {
        if (o == null) {
            throw new NullArgumentException(pattern, args);
        }
    }

    public static void checkNotNull(Object o) throws NullArgumentException {
        if (o == null) {
            throw new NullArgumentException();
        }
    }
}

