/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.tabix;

import java.io.IOException;
import java.io.InputStream;
import net.sf.samtools.tabix.TabixReader;
import org.snpeff.util.Gpr;

public class TPair64
implements Comparable<TPair64> {
    long u;
    long v;

    public static boolean less64(long u, long v) {
        return u < v ^ u < 0L ^ v < 0L;
    }

    public TPair64() {
    }

    public TPair64(long _u, long _v) {
        this.u = _u;
        this.v = _v;
    }

    public TPair64(TPair64 p) {
        this.u = p.u;
        this.v = p.v;
    }

    @Override
    public int compareTo(TPair64 p) {
        return this.u == p.u ? 0 : (this.u < p.u ^ this.u < 0L ^ p.u < 0L ? -1 : 1);
    }

    public void readIndex(InputStream is) throws IOException {
        this.u = TabixReader.readLong(is);
        this.v = TabixReader.readLong(is);
    }

    public String toString() {
        long u16 = this.u >> 16;
        long v16 = this.v >> 16;
        return "<" + this.u + "," + this.v + "> = < " + u16 + " , " + v16 + " >, size: " + Gpr.toByteSize(Math.abs(v16 - u16));
    }

    public String toStringRor16() {
        return (this.u >> 16) + "\t" + (this.v >> 16);
    }
}

