/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.samtools.Chunk;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMFileSpan;
import net.sf.samtools.util.StringUtil;

class BAMFileSpan
implements SAMFileSpan,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Chunk> chunks;

    protected BAMFileSpan() {
        this.chunks = new ArrayList<Chunk>();
    }

    protected BAMFileSpan(Chunk chunk) {
        this.chunks = new ArrayList<Chunk>();
        this.chunks.add(chunk);
    }

    protected BAMFileSpan(List<Chunk> chunks) {
        this.chunks = new ArrayList<Chunk>(chunks);
    }

    @Override
    public boolean isEmpty() {
        return this.chunks.isEmpty();
    }

    public BAMFileSpan clone() {
        BAMFileSpan clone2 = new BAMFileSpan();
        for (Chunk chunk : this.chunks) {
            clone2.chunks.add(chunk.clone());
        }
        return clone2;
    }

    @Override
    public SAMFileSpan removeContentsBefore(SAMFileSpan fileSpan) {
        if (fileSpan == null) {
            return this.clone();
        }
        if (!(fileSpan instanceof BAMFileSpan)) {
            throw new SAMException("Unable to compare ");
        }
        BAMFileSpan bamFileSpan = (BAMFileSpan)fileSpan;
        if (bamFileSpan.isEmpty()) {
            return this.clone();
        }
        this.validateSorted();
        BAMFileSpan trimmedChunkList = new BAMFileSpan();
        for (Chunk chunkToTrim : this.chunks) {
            if (chunkToTrim.getChunkEnd() <= chunkToTrim.getChunkStart()) continue;
            if (chunkToTrim.getChunkStart() >= bamFileSpan.chunks.get(0).getChunkStart()) {
                trimmedChunkList.add(chunkToTrim.clone());
                continue;
            }
            trimmedChunkList.add(new Chunk(bamFileSpan.chunks.get(0).getChunkStart(), chunkToTrim.getChunkEnd()));
        }
        return trimmedChunkList;
    }

    @Override
    public SAMFileSpan getContentsFollowing() {
        if (this.chunks.isEmpty()) {
            throw new SAMException("Unable to get the file pointer following this one: no data present.");
        }
        this.validateSorted();
        return new BAMFileSpan(new Chunk(this.chunks.get(this.chunks.size() - 1).getChunkEnd(), Long.MAX_VALUE));
    }

    public void add(BAMFileSpan span2) {
        for (Chunk c : span2.chunks) {
            this.chunks.add(c);
        }
    }

    protected void add(Chunk chunk) {
        this.chunks.add(chunk);
    }

    protected long[] toCoordinateArray() {
        int count2 = this.chunks.size() * 2;
        if (count2 == 0) {
            return null;
        }
        int index2 = 0;
        long[] result2 = new long[count2];
        for (Chunk chunk : this.chunks) {
            result2[index2++] = chunk.getChunkStart();
            result2[index2++] = chunk.getChunkEnd();
        }
        return result2;
    }

    protected long getFirstOffset() {
        long result2 = 0L;
        if (this.chunks == null) {
            return 0L;
        }
        Iterator<Chunk> i$ = this.chunks.iterator();
        if (i$.hasNext()) {
            Chunk chunk = i$.next();
            return chunk.getChunkStart();
        }
        return 0L;
    }

    protected List<Chunk> getChunks() {
        return Collections.unmodifiableList(this.chunks);
    }

    protected Chunk getSingleChunk() {
        if (this.chunks.size() != 1) {
            throw new SAMException("Expecting a single chunk for span. Found " + this.chunks.size());
        }
        return this.chunks.get(0);
    }

    protected static SAMFileSpan toChunkList(long[] coordinateArray) {
        if (coordinateArray.length % 2 != 0) {
            throw new SAMException("Data supplied does not appear to be in coordinate array format.");
        }
        BAMFileSpan chunkList = new BAMFileSpan();
        for (int i = 0; i < coordinateArray.length; i += 2) {
            chunkList.add(new Chunk(coordinateArray[i], coordinateArray[i + 1]));
        }
        chunkList.validateSorted();
        return chunkList;
    }

    private void validateSorted() {
        for (int i = 1; i < this.chunks.size(); ++i) {
            if (this.chunks.get(i).getChunkStart() >= this.chunks.get(i - 1).getChunkEnd()) continue;
            throw new SAMException(String.format("Chunk list is unsorted; chunk %s is before chunk %s", this.chunks.get(i - 1), this.chunks.get(i)));
        }
    }

    public String toString() {
        return StringUtil.join(";", this.chunks);
    }

    public static BAMFileSpan merge(BAMFileSpan[] spans) {
        int numInputChunks = 0;
        for (BAMFileSpan span2 : spans) {
            numInputChunks += span2.chunks.size();
        }
        ArrayList<Chunk> inputChunks = new ArrayList<Chunk>(numInputChunks);
        for (BAMFileSpan span3 : spans) {
            inputChunks.addAll(span3.chunks);
        }
        return new BAMFileSpan(Chunk.optimizeChunkList(inputChunks, 0L));
    }
}

