/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.list.linked;

import gnu.trove.TCharCollection;
import gnu.trove.function.TCharFunction;
import gnu.trove.impl.HashFunctions;
import gnu.trove.iterator.TCharIterator;
import gnu.trove.list.TCharList;
import gnu.trove.procedure.TCharProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCharLinkedList
implements TCharList,
Externalizable {
    char no_entry_value;
    int size;
    TCharLink head;
    TCharLink tail;

    public TCharLinkedList() {
        this.tail = this.head = null;
    }

    public TCharLinkedList(char no_entry_value) {
        this.tail = this.head = null;
        this.no_entry_value = no_entry_value;
    }

    public TCharLinkedList(TCharList list2) {
        this.tail = this.head = null;
        this.no_entry_value = list2.getNoEntryValue();
        TCharIterator iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            char next2 = iterator2.next();
            this.add(next2);
        }
    }

    @Override
    public char getNoEntryValue() {
        return this.no_entry_value;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean add(char val) {
        TCharLink l = new TCharLink(val);
        if (TCharLinkedList.no(this.head)) {
            this.head = l;
            this.tail = l;
        } else {
            l.setPrevious(this.tail);
            this.tail.setNext(l);
            this.tail = l;
        }
        ++this.size;
        return true;
    }

    @Override
    public void add(char[] vals) {
        for (char val : vals) {
            this.add(val);
        }
    }

    @Override
    public void add(char[] vals, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            char val = vals[offset + i];
            this.add(val);
        }
    }

    @Override
    public void insert(int offset, char value2) {
        TCharLinkedList tmp = new TCharLinkedList();
        tmp.add(value2);
        this.insert(offset, tmp);
    }

    @Override
    public void insert(int offset, char[] values2) {
        this.insert(offset, TCharLinkedList.link(values2, 0, values2.length));
    }

    @Override
    public void insert(int offset, char[] values2, int valOffset, int len) {
        this.insert(offset, TCharLinkedList.link(values2, valOffset, len));
    }

    void insert(int offset, TCharLinkedList tmp) {
        TCharLink l = this.getLinkAt(offset);
        this.size += tmp.size;
        if (l == this.head) {
            tmp.tail.setNext(this.head);
            this.head.setPrevious(tmp.tail);
            this.head = tmp.head;
            return;
        }
        if (TCharLinkedList.no(l)) {
            if (this.size == 0) {
                this.head = tmp.head;
                this.tail = tmp.tail;
            } else {
                this.tail.setNext(tmp.head);
                tmp.head.setPrevious(this.tail);
                this.tail = tmp.tail;
            }
        } else {
            TCharLink prev = l.getPrevious();
            l.getPrevious().setNext(tmp.head);
            tmp.tail.setNext(l);
            l.setPrevious(tmp.tail);
            tmp.head.setPrevious(prev);
        }
    }

    static TCharLinkedList link(char[] values2, int valOffset, int len) {
        TCharLinkedList ret = new TCharLinkedList();
        for (int i = 0; i < len; ++i) {
            ret.add(values2[valOffset + i]);
        }
        return ret;
    }

    @Override
    public char get(int offset) {
        if (offset > this.size) {
            throw new IndexOutOfBoundsException("index " + offset + " exceeds size " + this.size);
        }
        TCharLink l = this.getLinkAt(offset);
        if (TCharLinkedList.no(l)) {
            return this.no_entry_value;
        }
        return l.getValue();
    }

    public TCharLink getLinkAt(int offset) {
        if (offset >= this.size()) {
            return null;
        }
        if (offset <= this.size() >>> 1) {
            return TCharLinkedList.getLink(this.head, 0, offset, true);
        }
        return TCharLinkedList.getLink(this.tail, this.size() - 1, offset, false);
    }

    private static TCharLink getLink(TCharLink l, int idx, int offset) {
        return TCharLinkedList.getLink(l, idx, offset, true);
    }

    private static TCharLink getLink(TCharLink l, int idx, int offset, boolean next2) {
        int i = idx;
        while (TCharLinkedList.got(l)) {
            if (i == offset) {
                return l;
            }
            i += next2 ? 1 : -1;
            l = next2 ? l.getNext() : l.getPrevious();
        }
        return null;
    }

    @Override
    public char set(int offset, char val) {
        if (offset > this.size) {
            throw new IndexOutOfBoundsException("index " + offset + " exceeds size " + this.size);
        }
        TCharLink l = this.getLinkAt(offset);
        if (TCharLinkedList.no(l)) {
            throw new IndexOutOfBoundsException("at offset " + offset);
        }
        char prev = l.getValue();
        l.setValue(val);
        return prev;
    }

    @Override
    public void set(int offset, char[] values2) {
        this.set(offset, values2, 0, values2.length);
    }

    @Override
    public void set(int offset, char[] values2, int valOffset, int length) {
        for (int i = 0; i < length; ++i) {
            char value2 = values2[valOffset + i];
            this.set(offset + i, value2);
        }
    }

    @Override
    public char replace(int offset, char val) {
        return this.set(offset, val);
    }

    @Override
    public void clear() {
        this.size = 0;
        this.head = null;
        this.tail = null;
    }

    @Override
    public boolean remove(char value2) {
        boolean changed = false;
        TCharLink l = this.head;
        while (TCharLinkedList.got(l)) {
            if (l.getValue() == value2) {
                changed = true;
                this.removeLink(l);
            }
            l = l.getNext();
        }
        return changed;
    }

    private void removeLink(TCharLink l) {
        if (TCharLinkedList.no(l)) {
            return;
        }
        --this.size;
        TCharLink prev = l.getPrevious();
        TCharLink next2 = l.getNext();
        if (TCharLinkedList.got(prev)) {
            prev.setNext(next2);
        } else {
            this.head = next2;
        }
        if (TCharLinkedList.got(next2)) {
            next2.setPrevious(prev);
        } else {
            this.tail = prev;
        }
        l.setNext(null);
        l.setPrevious(null);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (this.isEmpty()) {
            return false;
        }
        for (Object o : collection) {
            if (o instanceof Character) {
                Character i = (Character)o;
                if (this.contains(i.charValue())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(TCharCollection collection) {
        if (this.isEmpty()) {
            return false;
        }
        TCharIterator it = collection.iterator();
        while (it.hasNext()) {
            char i = it.next();
            if (this.contains(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(char[] array) {
        if (this.isEmpty()) {
            return false;
        }
        for (char i : array) {
            if (this.contains(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Character> collection) {
        boolean ret = false;
        for (Character c : collection) {
            if (!this.add(c.charValue())) continue;
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean addAll(TCharCollection collection) {
        boolean ret = false;
        TCharIterator it = collection.iterator();
        while (it.hasNext()) {
            char i = it.next();
            if (!this.add(i)) continue;
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean addAll(char[] array) {
        boolean ret = false;
        for (char i : array) {
            if (!this.add(i)) continue;
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean modified = false;
        TCharIterator iter2 = this.iterator();
        while (iter2.hasNext()) {
            if (collection.contains(Character.valueOf(iter2.next()))) continue;
            iter2.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(TCharCollection collection) {
        boolean modified = false;
        TCharIterator iter2 = this.iterator();
        while (iter2.hasNext()) {
            if (collection.contains(iter2.next())) continue;
            iter2.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(char[] array) {
        Arrays.sort(array);
        boolean modified = false;
        TCharIterator iter2 = this.iterator();
        while (iter2.hasNext()) {
            if (Arrays.binarySearch(array, iter2.next()) >= 0) continue;
            iter2.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean modified = false;
        TCharIterator iter2 = this.iterator();
        while (iter2.hasNext()) {
            if (!collection.contains(Character.valueOf(iter2.next()))) continue;
            iter2.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(TCharCollection collection) {
        boolean modified = false;
        TCharIterator iter2 = this.iterator();
        while (iter2.hasNext()) {
            if (!collection.contains(iter2.next())) continue;
            iter2.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(char[] array) {
        Arrays.sort(array);
        boolean modified = false;
        TCharIterator iter2 = this.iterator();
        while (iter2.hasNext()) {
            if (Arrays.binarySearch(array, iter2.next()) < 0) continue;
            iter2.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public char removeAt(int offset) {
        TCharLink l = this.getLinkAt(offset);
        if (TCharLinkedList.no(l)) {
            throw new ArrayIndexOutOfBoundsException("no elemenet at " + offset);
        }
        char prev = l.getValue();
        this.removeLink(l);
        return prev;
    }

    @Override
    public void remove(int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.removeAt(offset);
        }
    }

    @Override
    public void transformValues(TCharFunction function) {
        TCharLink l = this.head;
        while (TCharLinkedList.got(l)) {
            l.setValue(function.execute(l.getValue()));
            l = l.getNext();
        }
    }

    @Override
    public void reverse() {
        TCharLink h = this.head;
        TCharLink t = this.tail;
        TCharLink l = this.head;
        while (TCharLinkedList.got(l)) {
            TCharLink next2 = l.getNext();
            TCharLink prev = l.getPrevious();
            TCharLink tmp = l;
            l = l.getNext();
            tmp.setNext(prev);
            tmp.setPrevious(next2);
        }
        this.head = t;
        this.tail = h;
    }

    @Override
    public void reverse(int from2, int to2) {
        if (from2 > to2) {
            throw new IllegalArgumentException("from > to : " + from2 + ">" + to2);
        }
        TCharLink start = this.getLinkAt(from2);
        TCharLink stop2 = this.getLinkAt(to2);
        TCharLink tmp = null;
        TCharLink tmpHead = start.getPrevious();
        for (TCharLink l = start; l != stop2; l = l.getNext()) {
            TCharLink next2 = l.getNext();
            TCharLink prev = l.getPrevious();
            tmp = l;
            tmp.setNext(prev);
            tmp.setPrevious(next2);
        }
        if (TCharLinkedList.got(tmp)) {
            tmpHead.setNext(tmp);
            stop2.setPrevious(tmpHead);
        }
        start.setNext(stop2);
        stop2.setPrevious(start);
    }

    @Override
    public void shuffle(Random rand) {
        for (int i = 0; i < this.size; ++i) {
            TCharLink l = this.getLinkAt(rand.nextInt(this.size()));
            this.removeLink(l);
            this.add(l.getValue());
        }
    }

    @Override
    public TCharList subList(int begin, int end) {
        if (end < begin) {
            throw new IllegalArgumentException("begin index " + begin + " greater than end index " + end);
        }
        if (this.size < begin) {
            throw new IllegalArgumentException("begin index " + begin + " greater than last index " + this.size);
        }
        if (begin < 0) {
            throw new IndexOutOfBoundsException("begin index can not be < 0");
        }
        if (end > this.size) {
            throw new IndexOutOfBoundsException("end index < " + this.size);
        }
        TCharLinkedList ret = new TCharLinkedList();
        TCharLink tmp = this.getLinkAt(begin);
        for (int i = begin; i < end; ++i) {
            ret.add(tmp.getValue());
            tmp = tmp.getNext();
        }
        return ret;
    }

    @Override
    public char[] toArray() {
        return this.toArray(new char[this.size], 0, this.size);
    }

    @Override
    public char[] toArray(int offset, int len) {
        return this.toArray(new char[len], offset, 0, len);
    }

    @Override
    public char[] toArray(char[] dest) {
        return this.toArray(dest, 0, this.size);
    }

    @Override
    public char[] toArray(char[] dest, int offset, int len) {
        return this.toArray(dest, offset, 0, len);
    }

    @Override
    public char[] toArray(char[] dest, int source_pos, int dest_pos, int len) {
        if (len == 0) {
            return dest;
        }
        if (source_pos < 0 || source_pos >= this.size()) {
            throw new ArrayIndexOutOfBoundsException(source_pos);
        }
        TCharLink tmp = this.getLinkAt(source_pos);
        for (int i = 0; i < len; ++i) {
            dest[dest_pos + i] = tmp.getValue();
            tmp = tmp.getNext();
        }
        return dest;
    }

    @Override
    public boolean forEach(TCharProcedure procedure) {
        TCharLink l = this.head;
        while (TCharLinkedList.got(l)) {
            if (!procedure.execute(l.getValue())) {
                return false;
            }
            l = l.getNext();
        }
        return true;
    }

    @Override
    public boolean forEachDescending(TCharProcedure procedure) {
        TCharLink l = this.tail;
        while (TCharLinkedList.got(l)) {
            if (!procedure.execute(l.getValue())) {
                return false;
            }
            l = l.getPrevious();
        }
        return true;
    }

    @Override
    public void sort() {
        this.sort(0, this.size);
    }

    @Override
    public void sort(int fromIndex, int toIndex) {
        TCharList tmp = this.subList(fromIndex, toIndex);
        char[] vals = tmp.toArray();
        Arrays.sort(vals);
        this.set(fromIndex, vals);
    }

    @Override
    public void fill(char val) {
        this.fill(0, this.size, val);
    }

    @Override
    public void fill(int fromIndex, int toIndex, char val) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("begin index can not be < 0");
        }
        TCharLink l = this.getLinkAt(fromIndex);
        if (toIndex > this.size) {
            int i;
            for (i = fromIndex; i < this.size; ++i) {
                l.setValue(val);
                l = l.getNext();
            }
            for (i = this.size; i < toIndex; ++i) {
                this.add(val);
            }
        } else {
            for (int i = fromIndex; i < toIndex; ++i) {
                l.setValue(val);
                l = l.getNext();
            }
        }
    }

    @Override
    public int binarySearch(char value2) {
        return this.binarySearch(value2, 0, this.size());
    }

    @Override
    public int binarySearch(char value2, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("begin index can not be < 0");
        }
        if (toIndex > this.size) {
            throw new IndexOutOfBoundsException("end index > size: " + toIndex + " > " + this.size);
        }
        if (toIndex < fromIndex) {
            return -(fromIndex + 1);
        }
        int from2 = fromIndex;
        TCharLink fromLink = this.getLinkAt(fromIndex);
        int to2 = toIndex;
        while (from2 < to2) {
            int mid = from2 + to2 >>> 1;
            TCharLink middle = TCharLinkedList.getLink(fromLink, from2, mid);
            if (middle.getValue() == value2) {
                return mid;
            }
            if (middle.getValue() < value2) {
                from2 = mid + 1;
                fromLink = middle.next;
                continue;
            }
            to2 = mid - 1;
        }
        return -(from2 + 1);
    }

    @Override
    public int indexOf(char value2) {
        return this.indexOf(0, value2);
    }

    @Override
    public int indexOf(int offset, char value2) {
        int count2 = offset;
        TCharLink l = this.getLinkAt(offset);
        while (TCharLinkedList.got(l.getNext())) {
            if (l.getValue() == value2) {
                return count2;
            }
            ++count2;
            l = l.getNext();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(char value2) {
        return this.lastIndexOf(0, value2);
    }

    @Override
    public int lastIndexOf(int offset, char value2) {
        if (this.isEmpty()) {
            return -1;
        }
        int last2 = -1;
        int count2 = offset;
        TCharLink l = this.getLinkAt(offset);
        while (TCharLinkedList.got(l.getNext())) {
            if (l.getValue() == value2) {
                last2 = count2;
            }
            ++count2;
            l = l.getNext();
        }
        return last2;
    }

    @Override
    public boolean contains(char value2) {
        if (this.isEmpty()) {
            return false;
        }
        TCharLink l = this.head;
        while (TCharLinkedList.got(l)) {
            if (l.getValue() == value2) {
                return true;
            }
            l = l.getNext();
        }
        return false;
    }

    @Override
    public TCharIterator iterator() {
        return new TCharIterator(){
            TCharLink l;
            TCharLink current;
            {
                this.l = TCharLinkedList.this.head;
            }

            public char next() {
                if (TCharLinkedList.no(this.l)) {
                    throw new NoSuchElementException();
                }
                char ret = this.l.getValue();
                this.current = this.l;
                this.l = this.l.getNext();
                return ret;
            }

            public boolean hasNext() {
                return TCharLinkedList.got(this.l);
            }

            public void remove() {
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                TCharLinkedList.this.removeLink(this.current);
                this.current = null;
            }
        };
    }

    @Override
    public TCharList grep(TCharProcedure condition) {
        TCharLinkedList ret = new TCharLinkedList();
        TCharLink l = this.head;
        while (TCharLinkedList.got(l)) {
            if (condition.execute(l.getValue())) {
                ret.add(l.getValue());
            }
            l = l.getNext();
        }
        return ret;
    }

    @Override
    public TCharList inverseGrep(TCharProcedure condition) {
        TCharLinkedList ret = new TCharLinkedList();
        TCharLink l = this.head;
        while (TCharLinkedList.got(l)) {
            if (!condition.execute(l.getValue())) {
                ret.add(l.getValue());
            }
            l = l.getNext();
        }
        return ret;
    }

    @Override
    public char max() {
        char ret = '\u0000';
        if (this.isEmpty()) {
            throw new IllegalStateException();
        }
        TCharLink l = this.head;
        while (TCharLinkedList.got(l)) {
            if (ret < l.getValue()) {
                ret = l.getValue();
            }
            l = l.getNext();
        }
        return ret;
    }

    @Override
    public char min() {
        char ret = '\uffff';
        if (this.isEmpty()) {
            throw new IllegalStateException();
        }
        TCharLink l = this.head;
        while (TCharLinkedList.got(l)) {
            if (ret > l.getValue()) {
                ret = l.getValue();
            }
            l = l.getNext();
        }
        return ret;
    }

    @Override
    public char sum() {
        char sum2 = '\u0000';
        TCharLink l = this.head;
        while (TCharLinkedList.got(l)) {
            sum2 = (char)(sum2 + l.getValue());
            l = l.getNext();
        }
        return sum2;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeChar(this.no_entry_value);
        out.writeInt(this.size);
        TCharIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            char next2 = iterator2.next();
            out.writeChar(next2);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.no_entry_value = in.readChar();
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            this.add(in.readChar());
        }
    }

    static boolean got(Object ref) {
        return ref != null;
    }

    static boolean no(Object ref) {
        return ref == null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TCharLinkedList that = (TCharLinkedList)o;
        if (this.no_entry_value != that.no_entry_value) {
            return false;
        }
        if (this.size != that.size) {
            return false;
        }
        TCharIterator iterator2 = this.iterator();
        TCharIterator thatIterator = that.iterator();
        while (iterator2.hasNext()) {
            if (!thatIterator.hasNext()) {
                return false;
            }
            if (iterator2.next() == thatIterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result2 = HashFunctions.hash(this.no_entry_value);
        result2 = 31 * result2 + this.size;
        TCharIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            result2 = 31 * result2 + HashFunctions.hash(iterator2.next());
        }
        return result2;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("{");
        TCharIterator it = this.iterator();
        while (it.hasNext()) {
            char next2 = it.next();
            buf.append(next2);
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    class RemoveProcedure
    implements TCharProcedure {
        boolean changed = false;

        RemoveProcedure() {
        }

        public boolean execute(char value2) {
            if (TCharLinkedList.this.remove(value2)) {
                this.changed = true;
            }
            return true;
        }

        public boolean isChanged() {
            return this.changed;
        }
    }

    static class TCharLink {
        char value;
        TCharLink previous;
        TCharLink next;

        TCharLink(char value2) {
            this.value = value2;
        }

        public char getValue() {
            return this.value;
        }

        public void setValue(char value2) {
            this.value = value2;
        }

        public TCharLink getPrevious() {
            return this.previous;
        }

        public void setPrevious(TCharLink previous) {
            this.previous = previous;
        }

        public TCharLink getNext() {
            return this.next;
        }

        public void setNext(TCharLink next2) {
            this.next = next2;
        }
    }
}

