/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.impl;

public final class HashFunctions {
    public static int hash(double value2) {
        assert (!Double.isNaN(value2)) : "Values of NaN are not supported.";
        long bits2 = Double.doubleToLongBits(value2);
        return (int)(bits2 ^ bits2 >>> 32);
    }

    public static int hash(float value2) {
        assert (!Float.isNaN(value2)) : "Values of NaN are not supported.";
        return Float.floatToIntBits(value2 * 6.6360896E8f);
    }

    public static int hash(int value2) {
        return value2;
    }

    public static int hash(long value2) {
        return (int)(value2 ^ value2 >>> 32);
    }

    public static int hash(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    public static int fastCeil(float v) {
        int possible_result = (int)v;
        if (v - (float)possible_result > 0.0f) {
            ++possible_result;
        }
        return possible_result;
    }
}

