/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.caseControl;

import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfGenotype;

public class VariantCounter {
    int[] genotypes;
    StringBuilder effects;

    public VariantCounter(int size2) {
        this.genotypes = new int[size2];
        this.effects = new StringBuilder();
    }

    public void addEffect(String effStr) {
        if (this.effects.length() > 0) {
            this.effects.append("\t");
        }
        this.effects.append(effStr);
    }

    public int countNonZeroGenotypes() {
        int count2 = 0;
        for (int i = 0; i < this.genotypes.length; ++i) {
            if (this.genotypes[i] <= 0) continue;
            ++count2;
        }
        return count2;
    }

    public int getGenotype(int idx) {
        return this.genotypes[idx];
    }

    public void incGenotype(int idx) {
        int n = idx;
        this.genotypes[n] = this.genotypes[n] + 1;
    }

    public void incGenotype(int idx, int value2) {
        int n = idx;
        this.genotypes[n] = this.genotypes[n] + value2;
    }

    public void parseGenotypes(VcfEntry ve) {
        int idx = 0;
        for (VcfGenotype gen : ve.getVcfGenotypes()) {
            if (gen.isVariant()) {
                int n = idx;
                this.genotypes[n] = this.genotypes[n] + 1;
            }
            ++idx;
        }
    }

    public void setGenotype(int idx, int value2) {
        this.genotypes[idx] = value2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.countNonZeroGenotypes());
        for (int i = 0; i < this.genotypes.length; ++i) {
            sb.append("\t" + this.genotypes[i]);
        }
        sb.append("\t");
        sb.append((CharSequence)this.effects);
        return sb.toString();
    }
}

