/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.snpeff.fileIterator.LineFileIterator;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.util.Timer;
import org.snpeff.vcf.LineChrPos;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfHeader;
import org.snpsift.SnpSift;

public class SnpSiftCmdSort
extends SnpSift {
    public static final int SHOW = 1000;
    public static final int SHOW_LINES = 100000;
    ArrayList<String> fileNames;
    VcfHeader vcfHeader;
    List<LineChrPos> vcfLines;

    public SnpSiftCmdSort() {
    }

    public SnpSiftCmdSort(String[] args) {
        super(args);
    }

    List<VcfEntry> createList() {
        LinkedList<VcfEntry> ves = new LinkedList<VcfEntry>();
        VcfFileIterator vcf = new VcfFileIterator();
        vcf.setVcfHeader(this.vcfHeader);
        int lineNum = 0;
        for (LineChrPos lp : this.vcfLines) {
            VcfEntry ve = new VcfEntry(vcf, lp.getLine(), lineNum++, true);
            ves.add(ve);
        }
        return ves;
    }

    public void loadVcfFiles() {
        this.vcfLines = new ArrayList<LineChrPos>();
        this.vcfHeader = null;
        for (String file : this.fileNames) {
            if (this.verbose) {
                Timer.showStdErr("Loading file '" + file + "'");
            }
            this.processHeader(file);
            LineFileIterator lfi = new LineFileIterator(file);
            for (String line : lfi) {
                if (line.startsWith("#") || line.isEmpty()) continue;
                LineChrPos lineChrPos = new LineChrPos(line);
                this.vcfLines.add(lineChrPos);
            }
        }
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length == 0) {
            this.usage(null);
        }
        this.fileNames = new ArrayList();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this.isOpt(arg)) {
                this.usage("Unknown option '" + arg + "'");
                continue;
            }
            this.fileNames.add(arg);
        }
        if (this.fileNames.size() <= 0) {
            this.fileNames.add("-");
        }
    }

    void processHeader(String file) {
        VcfFileIterator vcf = new VcfFileIterator(file);
        vcf.next();
        if (this.vcfHeader == null) {
            this.vcfHeader = vcf.getVcfHeader();
        } else {
            this.vcfHeader.add(vcf.getVcfHeader());
        }
        vcf.close();
    }

    @Override
    public boolean run() {
        this.run(false);
        return true;
    }

    public List<VcfEntry> run(boolean createList) {
        this.loadVcfFiles();
        this.sort();
        return createList ? this.createList() : null;
    }

    void sort() {
        Collections.sort(this.vcfLines);
        if (this.quiet) {
            return;
        }
        System.out.println(this.vcfHeader);
        for (LineChrPos lp : this.vcfLines) {
            System.out.println(lp.getLine());
        }
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar sort file.vcf [file_2.vcf ... file_N.vcf]");
        System.err.println("Note : If more than one file is given, files are merged and then sorted.");
        System.err.println("Note2: Loads the file/s in memory. Not suitable for large VCF files.");
        System.exit(1);
    }
}

