/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.vcf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.snpeff.interval.Chromosome;
import org.snpeff.util.Gpr;

public class FileIndexChrPos {
    public static final int POS_OFFSET = 1;
    private static final int BUFF_SIZE = 17;
    boolean verbose = false;
    boolean debug = false;
    String fileName;
    long size = 0L;
    RandomAccessFile file;
    HashMap<String, FileRegion> fileRegions = new HashMap();

    public FileIndexChrPos(String fileName) {
        this.fileName = fileName;
    }

    String chromo(String line) {
        if (line.startsWith("#")) {
            return null;
        }
        return line.split("\\t")[0];
    }

    public void close() {
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (IOException e) {
            System.err.println("I/O problem while closing file '" + this.fileName + "'");
            throw new RuntimeException(e);
        }
        this.file = null;
    }

    String dump(long start, long end, boolean toString2) {
        if (this.verbose) {
            System.err.println("\tDumping file '" + this.fileName + "' interval [ " + start + " , " + end + " ]");
        }
        StringBuilder sb = new StringBuilder();
        try {
            long len;
            int read2;
            byte[] buff = new byte[17];
            this.file.seek(start);
            for (long curr = start; curr <= end && (read2 = this.file.read(buff, 0, (int)(len = Math.min(17L, end - curr + 1L)))) > 0; curr += (long)read2) {
                String out = new String(buff, 0, read2);
                if (toString2) {
                    sb.append(out);
                    continue;
                }
                System.out.print(out);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading file '" + this.fileName + "' from position " + start + " to " + end);
        }
        return sb.toString();
    }

    public String dump(String chr, int posStart, int posEnd, boolean toString2) {
        long fileStart = this.find(chr, posStart, true);
        long fileEnd = this.find(chr, posEnd, false);
        return this.dump(fileStart, fileEnd - 1L, toString2);
    }

    long find(int chrPos, long start, String lineStart, long end, String lineEnd, boolean lessEq) {
        int posStart = this.pos(lineStart);
        int posEnd = this.pos(lineEnd);
        if (this.debug) {
            Gpr.debug("Find:\t" + chrPos + "\t[" + posStart + ", " + posEnd + "]\tFile: [" + start + " , " + end + "]\tsize: " + (end - start) + "\n\t\t\t\t" + this.s(lineStart) + "\n\t\t\t\t" + this.s(lineEnd) + "\n");
        }
        if (chrPos == posStart) {
            return this.found(start, lineStart, lessEq);
        }
        if (posEnd == chrPos) {
            return this.found(end, lineEnd, lessEq);
        }
        if (chrPos < posStart) {
            return start;
        }
        if (posEnd < chrPos) {
            return end + (long)lineEnd.length() + 1L;
        }
        if (start + 1L >= end) {
            if (chrPos <= posStart) {
                return this.found(start, lineStart, lessEq);
            }
            if (chrPos < posEnd) {
                return this.found(end, lineEnd, true);
            }
            return this.found(end, lineEnd, false);
        }
        if (posStart >= posEnd) {
            throw new RuntimeException("This should never happen! Is the file sorted by position?");
        }
        long mid = (start + end) / 2L;
        LineAndPos lpmid = this.getLine(mid);
        String lineMid = lpmid.line;
        long posMid = this.pos(lineMid);
        if ((long)chrPos <= posMid) {
            return this.find(chrPos, start, lineStart, mid, lineMid, lessEq);
        }
        return this.find(chrPos, mid, lineMid, end, lineEnd, lessEq);
    }

    public long find(String chr, int pos, boolean lessEq) {
        FileRegion fr = this.fileRegions.get(chr = Chromosome.simpleName(chr));
        if (fr == null) {
            throw new RuntimeException("No such chromosome: '" + chr + "'");
        }
        long posFound = this.find(pos, fr.start, fr.lineStart, fr.end, fr.lineEnd, lessEq);
        LineAndPos linePos = this.getLine(posFound);
        if (linePos != null) {
            return linePos.position;
        }
        return -1L;
    }

    long found(long filePos, String fileLine, boolean lessEq) {
        if (!lessEq) {
            long pos = filePos + (long)fileLine.length() + 1L;
            return pos < this.size() ? pos : this.size();
        }
        return filePos;
    }

    public byte get(long bytePosition) {
        try {
            if (this.file.getFilePointer() != bytePosition) {
                this.file.seek(bytePosition);
            }
            return (byte)this.file.read();
        }
        catch (IOException e) {
            throw new RuntimeException("Error readin file '" + this.fileName + "' at position " + bytePosition, e);
        }
    }

    public byte[] get(long bytePosition, int len) {
        try {
            byte[] buff;
            int read2;
            int size2 = Math.abs(len);
            long pos = bytePosition;
            if (len < 0) {
                if (bytePosition <= 0L) {
                    return null;
                }
                if ((pos -= (long)size2) < 0L) {
                    pos = 0L;
                    size2 = (int)bytePosition;
                }
                pos = Math.max(pos, 0L);
            }
            if (this.file.getFilePointer() != pos) {
                this.file.seek(pos);
            }
            if ((read2 = this.file.read(buff = new byte[size2])) <= 0) {
                return null;
            }
            if (read2 < buff.length) {
                byte[] newBuff = new byte[read2];
                System.arraycopy(buff, 0, newBuff, 0, read2);
                buff = newBuff;
            }
            if (len > 0) {
                int newLine = -1;
                for (int i = 0; i < read2; ++i) {
                    if (buff[i] != 10) continue;
                    newLine = i;
                    break;
                }
                if (newLine >= 0) {
                    byte[] newBuff = new byte[newLine + 1];
                    System.arraycopy(buff, 0, newBuff, 0, newLine + 1);
                    buff = newBuff;
                }
            } else if (len < 0) {
                int newLine = -1;
                for (int i = read2 - 1; i >= 0; --i) {
                    if (buff[i] != 10) continue;
                    newLine = i;
                    break;
                }
                if (newLine >= 0) {
                    byte[] newBuff = new byte[read2 - newLine];
                    int i = newLine;
                    int j = 0;
                    while (i < read2) {
                        newBuff[j] = buff[i];
                        ++i;
                        ++j;
                    }
                    buff = newBuff;
                }
            }
            return buff;
        }
        catch (IOException e) {
            throw new RuntimeException("Error readin file '" + this.fileName + "' at position " + bytePosition, e);
        }
    }

    public Set<String> getChromos() {
        return this.fileRegions.keySet();
    }

    public long getEnd(String chr) {
        FileRegion fr = this.fileRegions.get(chr = Chromosome.simpleName(chr));
        if (fr == null) {
            return -1L;
        }
        return fr.end;
    }

    FileRegion getFileRegion(String chr) {
        FileRegion fr = this.fileRegions.get(chr = Chromosome.simpleName(chr));
        if (fr == null) {
            fr = new FileRegion();
            this.fileRegions.put(chr, fr);
        }
        return fr;
    }

    public LineAndPos getLine(long pos) {
        long position;
        byte[] b;
        int BUFF_SIZE = 10240;
        long size2 = this.size();
        if (pos >= size2 || pos < 0L) {
            return null;
        }
        LineAndPos linePos = new LineAndPos();
        StringBuffer sb = new StringBuffer();
        for (position = pos; position < size2 && (b = this.get(position, BUFF_SIZE)) != null; position += (long)b.length) {
            sb.append(new String(b));
            if (b[b.length - 1] == 10) break;
        }
        for (position = pos; position >= 0L && (b = this.get(position, -BUFF_SIZE)) != null; position -= (long)b.length) {
            sb.insert(0, new String(b));
            if (b[0] != 10) continue;
            break;
        }
        int lineStart = 0;
        int lineEnd = sb.length();
        if (sb.charAt(0) == '\n') {
            lineStart = 1;
        }
        if (sb.charAt(sb.length() - 1) == '\n') {
            lineEnd = sb.length() - 1;
        }
        linePos.line = sb.toString().substring(lineStart, lineEnd);
        linePos.position = position + (long)lineStart;
        return linePos;
    }

    public LineAndPos getLineSlow(long pos) {
        byte b;
        long position;
        long size2 = this.size();
        if (pos >= size2 || pos < 0L) {
            return null;
        }
        LineAndPos linePos = new LineAndPos();
        StringBuffer sb = new StringBuffer();
        for (position = pos - 1L; position >= 0L && (b = this.get(position)) != 10; --position) {
            sb.insert(0, (char)b);
        }
        linePos.position = position + 1L;
        for (position = pos; position < size2 && (b = this.get(position)) != 10; ++position) {
            sb.append((char)b);
        }
        linePos.line = sb.toString();
        return linePos;
    }

    public long getStart(String chr) {
        FileRegion fr = this.fileRegions.get(chr = Chromosome.simpleName(chr));
        if (fr == null) {
            return -1L;
        }
        return fr.start;
    }

    public void index() {
        if (this.file == null) {
            throw new RuntimeException("File error (forgot to open the file?).");
        }
        long end = this.size() - 1L;
        if (end < 0L) {
            return;
        }
        String lineEnd = this.getLine((long)end).line;
        String chrEnd = this.chromo(lineEnd);
        FileRegion fr = this.getFileRegion(chrEnd);
        fr.end = end;
        fr.lineEnd = lineEnd;
        if (this.verbose) {
            System.err.println("\tindex:\t" + chrEnd + "\t" + end);
        }
        long start = 0L;
        String lineStart = "";
        for (start = 0L; start < this.size && this.chromo(lineStart = this.getLine((long)start).line) == null; start += (long)(lineStart.length() + 1)) {
        }
        String chrStart = this.chromo(lineStart);
        fr = this.getFileRegion(chrStart);
        fr.start = start;
        fr.lineStart = lineStart;
        if (this.verbose) {
            System.err.println("\tindex:\t" + chrStart + "\t" + start);
        }
        this.indexChromos(start, lineStart, end, lineEnd);
    }

    void indexChromos(long start, String lineStart, long end, String lineEnd) {
        if (this.debug) {
            Gpr.debug("Index:\n\t" + start + "(" + (double)start / (double)this.size() + ") :\t" + this.s(lineStart) + "\n\t" + end + "(" + (double)end / (double)this.size() + ") :\t" + this.s(lineEnd));
        }
        if (start > end) {
            throw new RuntimeException("This should never happen! Start: " + start + "\tEnd: " + end);
        }
        String chrStart = this.chromo(lineStart);
        if (chrStart == null) {
            throw new RuntimeException("Cannot extract chromosome data from line:\n\tPosition : " + start + " (byte position in file) \n\tLine     : " + lineStart);
        }
        String chrEnd = this.chromo(lineEnd);
        if (chrEnd == null) {
            throw new RuntimeException("Cannot extract chromosome data from line:\n\tPosition : " + end + " (byte position in file) \n\tLine     : " + lineEnd);
        }
        if (chrStart.equals(chrEnd)) {
            if (this.debug) {
                Gpr.debug("Chromo:\tlineStart: " + chrStart + "\tlineEnd: " + chrEnd + "\t==> Back!");
            }
            return;
        }
        if (this.debug) {
            Gpr.debug("Chromo:\tlineStart: " + chrStart + "\tlineEnd: " + chrEnd);
        }
        if (start + (long)lineStart.length() + 1L >= end) {
            if (this.verbose) {
                System.err.println("\t\t" + chrStart + " / " + chrEnd + "\t" + start + " / " + end);
            }
            this.getFileRegion((String)chrEnd).start = this.getLine((long)end).position;
            this.getFileRegion((String)chrEnd).lineStart = lineEnd;
            this.getFileRegion((String)chrStart).end = this.getLine((long)start).position;
            this.getFileRegion((String)chrStart).lineEnd = lineStart;
            return;
        }
        long mid = (start + end) / 2L;
        String lineMid = this.getLine((long)mid).line;
        if (this.debug) {
            Gpr.debug("Mid: " + mid + "\t" + this.s(lineMid));
        }
        if (this.debug) {
            Gpr.debug("First half recustion:");
        }
        this.indexChromos(start, lineStart, mid, lineMid);
        if (this.debug) {
            Gpr.debug("Second half recustion:");
        }
        this.indexChromos(mid, lineMid, end, lineEnd);
    }

    void init(FileChannel channel) throws IOException {
    }

    public void open() {
        try {
            File f2 = new File(this.fileName);
            this.size = f2.length();
            this.file = new RandomAccessFile(f2, "r");
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found '" + this.fileName + "'");
            throw new RuntimeException(e);
        }
    }

    public int pos(String line) {
        if (line.startsWith("#")) {
            return -1;
        }
        return Gpr.parseIntSafe(line.split("\\t")[1]) - 1;
    }

    String s(String s) {
        if (s == null) {
            return "null";
        }
        return s.length() <= 50 ? s : s.substring(0, 50) + "...";
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public long size() {
        return this.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.fileRegions.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            sb.append(key + ":\n" + Gpr.prependEachLine("\t\t", this.fileRegions.get(key).toString()) + "\n");
        }
        return sb.toString();
    }

    public class LineAndPos {
        public String line;
        public long position;

        public String toString() {
            String str = "";
            if (this.line != null) {
                str = this.line.length() > 50 ? this.line.substring(0, 49) + "..." : this.line;
            }
            return this.position + "\t" + str;
        }
    }

    public class FileRegion {
        long start;
        long end;
        String lineStart;
        String lineEnd;

        public String toString() {
            return this.start + "\t" + this.lineStart + "\n" + this.end + "\t" + this.lineEnd;
        }
    }
}

