/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.stats;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.snpeff.interval.BioType;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.interval.VariantWithScore;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.stats.CountByType;

public class GeneCountByTypeTable
implements Iterable<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static int GENE_CPG_NUM_BINS = 30;
    public static boolean debug = false;
    HashSet<String> keys = new HashSet();
    HashSet<String> types = new HashSet();
    HashMap<String, CountByType> countersByType = new HashMap();
    HashMap<String, CountByType> counterSizeByType = new HashMap();
    HashMap<String, String> bioType = new HashMap();
    HashMap<String, Integer> sizeByType = new HashMap();

    public String getBioType(String key) {
        String bio = this.bioType.get(key);
        return bio != null ? bio : "";
    }

    public CountByType getCounter(String type) {
        CountByType counter = this.countersByType.get(type);
        if (counter == null) {
            counter = new CountByType();
            this.countersByType.put(type, counter);
        }
        return counter;
    }

    public CountByType getCounterSize(String type) {
        CountByType counter = this.counterSizeByType.get(type);
        if (counter == null) {
            counter = new CountByType();
            this.counterSizeByType.put(type, counter);
        }
        return counter;
    }

    public List<String> getKeyList() {
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.addAll(this.keys);
        Collections.sort(keyList);
        return keyList;
    }

    public int getSizeByType(String key, String type) {
        Integer size2 = this.sizeByType.get(key + "\t" + type);
        return size2 == null ? 0 : size2;
    }

    public List<String> getTypeList() {
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.addAll(this.types);
        Collections.sort(typeList);
        return typeList;
    }

    @Override
    public Iterator<String> iterator() {
        return this.keys.iterator();
    }

    public void sample(Gene gene, Transcript tr, String type, VariantEffect variantEffect) {
        String key = gene.getGeneName() + "\t" + gene.getId() + "\t" + tr.getId();
        CountByType counter = this.getCounter(type);
        counter.inc(key);
        if (tr.getBioType() != null) {
            this.bioType.put(key, tr.getBioType().toString());
        } else {
            this.bioType.put(key, tr.isProteinCoding() ? BioType.protein_coding.toString() : "");
        }
        Marker marker = variantEffect.getMarker();
        Variant variant = variantEffect.getVariant();
        int start = Math.max(variant.getStart(), marker.getStart());
        int end = Math.min(variant.getEnd(), marker.getEnd());
        int size2 = end - start + 1;
        if (size2 > 0) {
            double score;
            this.getCounterSize(type).inc(key, size2);
            this.sizeByType.put(key + "\t" + type, marker.size());
            if (variant instanceof VariantWithScore && !Double.isNaN(score = ((VariantWithScore)variant).getScore())) {
                counter.addScore(key, score);
            }
        }
        this.types.add(type);
        this.keys.add(key);
    }
}

