/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.spliceSites;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.snpeff.collections.AutoHashMap;
import org.snpeff.fileIterator.FastaFileIterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Intron;
import org.snpeff.interval.SpliceSiteBranchU12;
import org.snpeff.interval.Transcript;
import org.snpeff.motif.Pwm;
import org.snpeff.snpEffect.Config;
import org.snpeff.spliceSites.AcgtTree;
import org.snpeff.spliceSites.TranscriptSet;
import org.snpeff.util.Gpr;
import org.snpeff.util.GprSeq;
import org.snpeff.util.Timer;
import org.snpeff.util.Tuple;

public class SpliceTypes {
    public static int MAX_SPLICE_SIZE = 10;
    public static int SIZE_BRANCH = 60;
    public static final double THRESHOLD_ENTROPY = 0.05;
    public static final int THRESHOLD_COUNT = 100;
    public static final double THRESHOLD_P = 0.95;
    boolean verbose = false;
    boolean debug = false;
    String genomeFasta;
    Config config;
    HashMap<String, String> donorsByIntron = new HashMap();
    HashMap<String, String> acceptorsByIntron = new HashMap();
    HashMap<String, String> branchByIntron = new HashMap();
    ArrayList<String> donorAccPairDonor = new ArrayList();
    ArrayList<String> donorAccPairAcc = new ArrayList();
    AutoHashMap<String, List<SpliceSiteBranchU12>> branchU12ByDonorAcc = new AutoHashMap(new ArrayList());
    HashMap<String, Integer> donorAcc = new HashMap();
    AcgtTree acgtTreeDonors = new AcgtTree();
    AcgtTree acgtTreeAcc = new AcgtTree();
    Pwm pwmU12;
    TranscriptSet transcriptSet;
    double thresholdPDonor;
    double thresholdEntropyDonor;
    double thresholdPAcc;
    double thresholdEntropyAcc;
    double thresholdU12Score;

    public SpliceTypes(Config config) {
        this.config = config;
    }

    void acc4donor(String donorSeq) {
        AcgtTree tree = new AcgtTree();
        for (String key : this.donorsByIntron.keySet()) {
            String acc;
            String donor = this.donorsByIntron.get(key);
            if (!donor.startsWith(donorSeq) || (acc = GprSeq.reverse(this.acceptorsByIntron.get(key))).indexOf(78) >= 0) continue;
            tree.add(acc);
        }
        for (String accSeq : tree.findNodeNames(this.thresholdEntropyAcc, this.thresholdPAcc, 100)) {
            if (accSeq.length() <= 1) continue;
            accSeq = GprSeq.reverse(accSeq);
            this.add(donorSeq, accSeq);
        }
    }

    void add(String donor, String acceptor) {
        String key = String.format("%-10s\t%10s", donor, acceptor);
        int count2 = this.countDonorAcc(donor, acceptor);
        if (count2 >= 100) {
            this.donorAcc.put(key, count2);
        }
    }

    public Tuple<Double, Integer> addBestU12Score(Transcript tr, String chrSeq, String donorAcceptor, int intronStart, int intronEnd) {
        int bestU12End;
        String branchStr = this.seqBranch(tr, chrSeq, intronStart, intronEnd);
        Tuple<Double, Integer> bestU12 = this.bestU12Score(branchStr);
        int bestU12Start = (Integer)bestU12.second;
        if (tr.isStrandPlus()) {
            bestU12Start = intronEnd - SIZE_BRANCH + bestU12Start;
            bestU12End = bestU12Start + this.pwmU12.length();
        } else {
            bestU12Start = intronStart + SIZE_BRANCH - bestU12Start - this.pwmU12.length() - 1;
            bestU12End = bestU12Start + this.pwmU12.length();
        }
        Intron intron = tr.findIntron(bestU12Start);
        SpliceSiteBranchU12 ssu12 = new SpliceSiteBranchU12(intron, bestU12Start, bestU12End, tr.isStrandMinus(), "");
        this.addBranchU12(donorAcceptor, ssu12);
        return bestU12;
    }

    void addBranchU12(String donorAcceptor, SpliceSiteBranchU12 ssu12) {
        this.branchU12ByDonorAcc.getOrCreate(donorAcceptor).add(ssu12);
    }

    public boolean analyzeAndCreate() {
        if (this.verbose) {
            Timer.showStdErr("Splice site sequence conservation analysis: Start");
        }
        this.load();
        this.spliceSequences();
        this.spliceDonoAcceptorPairs();
        this.createSpliceSites();
        if (this.verbose) {
            Timer.showStdErr("Splice site sequence conservation analysis: Done.");
        }
        return true;
    }

    int bestMatchIndex(String intronSeqDonor, String intronSeqAcc) {
        if (intronSeqDonor == null || intronSeqAcc == null) {
            return -1;
        }
        int maxLenDa = -1;
        int idx = -1;
        for (int i = 0; i < this.donorAccPairDonor.size(); ++i) {
            int lenda;
            String don = this.donorAccPairDonor.get(i);
            String ac = this.donorAccPairAcc.get(i);
            if (!intronSeqDonor.startsWith(don) || !intronSeqAcc.endsWith(ac) || (lenda = don.length() + ac.length()) <= maxLenDa) continue;
            maxLenDa = lenda;
            idx = i;
        }
        return idx;
    }

    public Tuple<Double, Integer> bestU12Score(String seq2) {
        int max2 = seq2.length() - this.pwmU12.length();
        double bestScore = 0.0;
        int bestPos = -1;
        for (int i = 0; i < max2; ++i) {
            double score;
            String sub = seq2.substring(i, i + this.pwmU12.length());
            if (sub.indexOf(78) >= 0 || !(bestScore < (score = this.pwmU12.score(sub)))) continue;
            bestScore = score;
            bestPos = i;
        }
        return new Tuple<Double, Integer>(bestScore, bestPos);
    }

    public double branchU12Threshold(double thresholdU12Percentile) {
        Timer.showStdErr("Finding U12 PWM score distribution and threshold.");
        ArrayList<Double> scores = new ArrayList<Double>();
        for (String branch : this.branchByIntron.values()) {
            Tuple<Double, Integer> best = this.bestU12Score(branch);
            double bestScore = (Double)best.first;
            scores.add(bestScore);
        }
        Collections.sort(scores);
        int index = (int)(thresholdU12Percentile * (double)scores.size());
        this.thresholdU12Score = (Double)scores.get(index);
        return this.thresholdU12Score;
    }

    int countDonorAcc(String donor, String acceptor) {
        int count2 = 0;
        for (String key : this.donorsByIntron.keySet()) {
            String d = this.donorsByIntron.get(key);
            String a = this.acceptorsByIntron.get(key);
            if (!d.startsWith(donor) || !a.endsWith(acceptor)) continue;
            ++count2;
        }
        return count2;
    }

    public void createSpliceFasta(String outputDir) {
        if (this.verbose) {
            Timer.showStdErr("Creating FASTA files for each dono-acceptor pair.");
        }
        for (int i = 0; i < this.getDonorAccPairSize(); ++i) {
            String d = this.getDonor(i);
            String a = this.getAcceptor(i);
            String fastaFile = outputDir + "/" + this.config.getGenome().getId() + "." + d + "-" + a + ".fa";
            this.createSpliceFasta(fastaFile, d, a);
        }
    }

    void createSpliceFasta(String fastaFile, String donor, String acceptor) {
        StringBuilder fasta = new StringBuilder();
        for (String intronKey : this.getIntronKeySet()) {
            String d = this.getDonorByIntron(intronKey);
            String a = this.getAcceptorsByIntron(intronKey);
            if (!d.startsWith(donor) || !a.endsWith(acceptor)) continue;
            String branch = this.getAcceptorsByIntron(intronKey);
            fasta.append(">" + intronKey + "\n" + d + "-" + a + "\n");
        }
        if (this.verbose) {
            Timer.showStdErr("\tWriting fasta sequences to file: " + fastaFile);
        }
        Gpr.toFile(fastaFile, fasta);
    }

    void createSpliceSites() {
        if (this.verbose) {
            Timer.showStdErr("\tCreating splice sites.");
        }
        int count2 = 0;
        for (Transcript tr : this.transcriptSet) {
            for (Intron intron : tr.introns()) {
                this.createSpliceSites(intron);
            }
        }
        if (this.verbose) {
            Timer.showStdErr("\tCreated : " + count2 + " splice sites.");
        }
    }

    int createSpliceSites(Intron intron) {
        int start = intron.getStart();
        int end = intron.getEnd();
        String key = intron.getChromosomeName() + ":" + start + "-" + end;
        String donor = this.donorsByIntron.get(key);
        String acc = this.acceptorsByIntron.get(key);
        if (donor == null || acc == null) {
            return 0;
        }
        int idx = this.bestMatchIndex(donor, acc);
        int dist = end - start - 1;
        int count2 = 0;
        if (idx > 0) {
            String donorConserved = this.donorAccPairDonor.get(idx);
            String accConserved = this.donorAccPairAcc.get(idx);
            if (this.debug) {
                System.err.println("\tCreating splice sites:\t" + donor + "-" + acc + "\tConserved:\t" + donorConserved + "-" + accConserved);
            }
            if (donorConserved.length() > 2) {
                intron.createSpliceSiteDonor(Math.min(donorConserved.length(), dist));
                ++count2;
            }
            if (accConserved.length() > 2) {
                intron.createSpliceSiteAcceptor(Math.min(accConserved.length(), dist));
                ++count2;
            }
        }
        return count2;
    }

    void donor4acc(String accSeq) {
        AcgtTree tree = new AcgtTree();
        for (String key : this.acceptorsByIntron.keySet()) {
            String donor;
            String acc = GprSeq.reverse(this.acceptorsByIntron.get(key));
            if (!acc.endsWith(accSeq) || (donor = this.donorsByIntron.get(key)).indexOf(78) >= 0) continue;
            tree.add(donor);
        }
        for (String donorSeq : tree.findNodeNames(this.thresholdEntropyDonor, this.thresholdPDonor, 100)) {
            if (donorSeq.length() <= 1) continue;
            this.add(donorSeq, accSeq);
        }
    }

    double findEntropyThreshold(AcgtTree tree) {
        List<Double> values2 = tree.entropyAll(100);
        Collections.sort(values2);
        int index = (int)((double)values2.size() * 0.05);
        return values2.get(index);
    }

    double findPthreshold(AcgtTree tree) {
        List<Double> values2 = tree.pAll(100);
        Collections.sort(values2);
        int index = (int)((double)values2.size() * 0.95);
        return values2.get(index);
    }

    public String getAcceptor(int i) {
        return this.donorAccPairAcc.get(i);
    }

    public String getAcceptorsByIntron(String intronKey) {
        return this.acceptorsByIntron.get(intronKey);
    }

    public String getBranchByIntron(String intronKey) {
        return this.branchByIntron.get(intronKey);
    }

    public List<SpliceSiteBranchU12> getBranchU12(String donorAcceptor) {
        return this.branchU12ByDonorAcc.getOrCreate(donorAcceptor);
    }

    public String getDonor(int i) {
        return this.donorAccPairDonor.get(i);
    }

    public int getDonorAccPairSize() {
        return this.donorAccPairDonor.size();
    }

    public String getDonorByIntron(String intronKey) {
        return this.donorsByIntron.get(intronKey);
    }

    public Set<String> getIntronKeySet() {
        return this.donorsByIntron.keySet();
    }

    void load() {
        String u12file = this.config.getDirData() + "/spliceSites/u12_branch.pwm";
        if (this.verbose) {
            Timer.showStdErr("\tLoading U12 PWM form file '" + u12file + "'");
        }
        this.pwmU12 = new Pwm(u12file);
        if (this.config.getSnpEffectPredictor() == null) {
            if (this.verbose) {
                Timer.showStdErr("\tLoading: " + this.config.getGenome().getGenomeName());
            }
            this.config.loadSnpEffectPredictor();
            if (this.verbose) {
                Timer.showStdErr("\tdone.");
            }
        }
        if (this.transcriptSet == null) {
            this.transcriptSet = new TranscriptSet(this.config.getGenome());
            this.transcriptSet.setVerbose(this.verbose);
            this.transcriptSet.setDebug(this.debug);
            this.transcriptSet.filter();
        }
    }

    String seqAcceptor(Transcript tr, String chrSeq, int intronStart, int intronEnd) {
        if (intronEnd - intronStart < MAX_SPLICE_SIZE) {
            return "";
        }
        if (tr.isStrandPlus()) {
            int splAccStart = intronEnd - MAX_SPLICE_SIZE;
            int splAccEnd = intronEnd + MAX_SPLICE_SIZE;
            return chrSeq.substring(splAccStart, splAccEnd + 1).toUpperCase();
        }
        int splAccStart = intronStart - MAX_SPLICE_SIZE;
        int splAccEnd = intronStart + MAX_SPLICE_SIZE;
        return GprSeq.reverseWc(chrSeq.substring(splAccStart, splAccEnd + 1).toUpperCase());
    }

    String seqBranch(Transcript tr, String chrSeq, int intronStart, int intronEnd) {
        if (intronEnd - intronStart < SIZE_BRANCH) {
            return "";
        }
        if (tr.isStrandPlus()) {
            int splBranchStart = intronEnd - SIZE_BRANCH + 1;
            int splBranchEnd = intronEnd;
            return chrSeq.substring(splBranchStart, splBranchEnd).toUpperCase();
        }
        int splBranchStart = intronStart + 1;
        int splBranchEnd = intronStart + SIZE_BRANCH;
        return GprSeq.reverseWc(chrSeq.substring(splBranchStart, splBranchEnd).toUpperCase());
    }

    String seqDonor(Transcript tr, String chrSeq, int intronStart, int intronEnd) {
        if (intronEnd - intronStart < MAX_SPLICE_SIZE) {
            return "";
        }
        if (tr.isStrandPlus()) {
            int splDonorStart = intronStart - MAX_SPLICE_SIZE;
            int splDonorEnd = intronStart + MAX_SPLICE_SIZE;
            return chrSeq.substring(splDonorStart, splDonorEnd + 1).toUpperCase();
        }
        int splDonorStart = intronEnd - MAX_SPLICE_SIZE;
        int splDonorEnd = intronEnd + MAX_SPLICE_SIZE;
        return GprSeq.reverseWc(chrSeq.substring(splDonorStart, splDonorEnd + 1).toUpperCase());
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setGenomeFasta(String genomeFasta) {
        this.genomeFasta = genomeFasta;
    }

    public void setTranscriptSet(TranscriptSet transcriptSet) {
        this.transcriptSet = transcriptSet;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    void spliceDonoAcceptorPairs() {
        if (this.verbose) {
            Timer.showStdErr("\tFinding donor-acceptor pairs: Creating quaternary trees");
        }
        for (String donor : this.donorsByIntron.values()) {
            if (donor.indexOf(78) >= 0) continue;
            this.acgtTreeDonors.add(donor);
        }
        for (String acc : this.acceptorsByIntron.values()) {
            if (acc.indexOf(78) >= 0) continue;
            this.acgtTreeAcc.add(GprSeq.reverse(acc));
        }
        if (this.verbose) {
            Timer.showStdErr("\tCalculate thresholds");
        }
        this.thresholdPDonor = this.findPthreshold(this.acgtTreeDonors);
        this.thresholdEntropyDonor = this.findEntropyThreshold(this.acgtTreeDonors);
        this.thresholdPAcc = this.findPthreshold(this.acgtTreeAcc);
        this.thresholdEntropyAcc = this.findEntropyThreshold(this.acgtTreeAcc);
        if (this.verbose) {
            Timer.showStdErr("\tDonors Thresholds:\t\tEntropy: " + this.thresholdEntropyDonor + "\t\tProbability: " + this.thresholdPDonor);
        }
        for (String seq2 : this.acgtTreeDonors.findNodeNames(this.thresholdEntropyDonor, this.thresholdPDonor, 100)) {
            if (seq2.length() <= 1) continue;
            this.acc4donor(seq2);
        }
        if (this.verbose) {
            Timer.showStdErr("\tFind acceptors");
        }
        if (this.verbose) {
            Timer.showStdErr("\tAcceptors Thresholds:\t\tEntropy: " + this.thresholdEntropyAcc + "\t\tProbability: " + this.thresholdPAcc);
        }
        for (String seq2 : this.acgtTreeAcc.findNodeNames(this.thresholdEntropyAcc, this.thresholdPAcc, 100)) {
            if (seq2.length() <= 1) continue;
            this.donor4acc(GprSeq.reverse(seq2));
        }
        if (this.verbose) {
            Timer.showStdErr("\tAdd Donor - Acceptors pairs: ");
        }
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.donorAcc.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return SpliceTypes.this.donorAcc.get(arg1) - SpliceTypes.this.donorAcc.get(arg0);
            }
        });
        for (String key : keys) {
            if (this.donorAcc.get(key) <= 100) continue;
            String[] da = key.trim().split("\\s+");
            this.donorAccPairDonor.add(da[0]);
            this.donorAccPairAcc.add(da[1]);
            if (!this.verbose) continue;
            Timer.showStdErr("\t\t\t" + this.donorAcc.get(key) + "\t" + key);
        }
    }

    void spliceSequences() {
        if (this.genomeFasta == null) {
            this.genomeFasta = this.config.getFileNameGenomeFasta();
        }
        if (this.verbose) {
            Timer.showStdErr("\tFinding splice sequences. Reading fasta file: " + this.genomeFasta);
        }
        FastaFileIterator ffi = new FastaFileIterator(this.genomeFasta);
        for (String chrSeq : ffi) {
            String chrName = Chromosome.simpleName(ffi.getName());
            this.spliceSequences(chrName, chrSeq);
        }
    }

    void spliceSequences(String chrName, String chrSeq) {
        int countEx = 0;
        int countTr = 0;
        for (Transcript tr : this.transcriptSet.getByChromo(chrName)) {
            Exon exPrev = null;
            for (Exon ex : tr.sortedStrand()) {
                ++countEx;
                if (exPrev != null) {
                    int end;
                    int start;
                    if (tr.isStrandPlus()) {
                        start = exPrev.getEnd();
                        end = ex.getStart();
                    } else {
                        start = ex.getEnd();
                        end = exPrev.getStart();
                    }
                    this.spliceSequences(tr, chrName, chrSeq, start, end);
                }
                exPrev = ex;
            }
            ++countTr;
        }
        if (this.verbose) {
            Timer.showStdErr("\t\tChromosome: " + chrName + "\tTranscripts: " + countTr + "\tExons: " + countEx + "\tTotal Splice sites: " + this.donorsByIntron.size());
        }
    }

    void spliceSequences(Transcript tr, String chrName, String chrSeq, int intronStart, int intronEnd) {
        String key = chrName + ":" + intronStart + "-" + intronEnd;
        if (this.donorsByIntron.containsKey(key)) {
            return;
        }
        String donorStr = this.seqDonor(tr, chrSeq, intronStart, intronEnd);
        String accStr = this.seqAcceptor(tr, chrSeq, intronStart, intronEnd);
        String branchStr = this.seqBranch(tr, chrSeq, intronStart, intronEnd);
        String intronSeqDonor = donorStr.isEmpty() ? "" : donorStr.substring(MAX_SPLICE_SIZE + 1);
        String intronSeqAcc = accStr.isEmpty() ? "" : accStr.substring(0, MAX_SPLICE_SIZE);
        this.donorsByIntron.put(key, intronSeqDonor);
        this.acceptorsByIntron.put(key, intronSeqAcc);
        this.branchByIntron.put(key, branchStr);
    }
}

