/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.util.HashMap;
import java.util.List;
import org.junit.Test;
import org.snpeff.fileIterator.VariantTxtFileIterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryGtf22;
import org.snpeff.snpEffect.testCases.integration.CompareEffects;
import org.snpeff.util.Gpr;
import org.snpeff.util.GprSeq;

public class TestCasesIntegrationVariant {
    boolean verbose = false;
    long randSeed = 20100629L;
    String genomeName = "testCase";

    @Test
    public void test_08() {
        String[] lines2;
        Gpr.debug("Test");
        CompareEffects comp = new CompareEffects(this.genomeName, this.randSeed, this.verbose);
        comp.initSnpEffPredictor();
        HashMap<String, String> cdsByTrId = new HashMap<String, String>();
        String cdsY = Gpr.readFile("./tests/cds_hg37_chrY.txt");
        for (String line : lines2 = cdsY.split("\n")) {
            String[] recs = line.split("\t");
            cdsByTrId.put(recs[0], recs[1]);
        }
        int totalOk = 0;
        for (Gene gint : comp.config.getGenome().getGenes()) {
            for (Transcript tint : gint) {
                String seqOri = (String)cdsByTrId.get(tint.getId());
                if (seqOri == null) continue;
                String seq2 = tint.cds();
                if (!seqOri.equalsIgnoreCase(seq2)) {
                    throw new RuntimeException("CDS do not match:\nTranscipt:" + tint.getId() + " " + tint.isStrandMinus() + "\n\t" + seq2 + "\n\t" + seqOri + "\n");
                }
                if (this.verbose) {
                    System.out.println("CDS compare:\n\t" + seqOri + "\n\t" + seq2);
                }
                ++totalOk;
            }
        }
        if (totalOk == 0) {
            throw new RuntimeException("No sequences compared!");
        }
    }

    @Test
    public void test_09() {
        String trId = "ENST00000250823";
        Gpr.debug("Test");
        CompareEffects comp = new CompareEffects(this.genomeName, this.randSeed, this.verbose);
        comp.setUseAaNoNum(true);
        comp.snpEffect("tests/" + trId + ".out", trId, true);
    }

    @Test
    public void test_11() {
        String trId = "ENST00000250823";
        Gpr.debug("Test");
        CompareEffects comp = new CompareEffects(this.genomeName, this.randSeed, this.verbose);
        comp.setUseAaNoNum(true);
        comp.snpEffect("tests/" + trId + "_all.out", trId, false);
    }

    @Test
    public void test_12() {
        Gpr.debug("Test");
        CompareEffects comp = new CompareEffects(this.genomeName, this.randSeed, this.verbose);
        comp.snpEffect("tests/splice_site.out", null, true);
    }

    @Test
    public void test_12_2() {
        Gpr.debug("Test");
        CompareEffects comp = new CompareEffects(this.genomeName, this.randSeed, this.verbose);
        comp.snpEffect("tests/splice_site_2.out", null, true);
    }

    @Test
    public void test_19() {
        Gpr.debug("Test");
        CompareEffects comp = new CompareEffects(this.genomeName, this.randSeed, this.verbose);
        String trId = "ENST00000439108";
        comp.snpEffect("tests/" + trId + ".snps", trId, true);
    }

    @Test
    public void test_20() {
        Gpr.debug("Test");
        CompareEffects comp = new CompareEffects(this.genomeName, this.randSeed, this.verbose);
        String trId = "ENST00000382673";
        comp.snpEffect("tests/" + trId + ".snps", trId, true);
    }

    @Test
    public void test_21() {
        Gpr.debug("Test");
        CompareEffects comp = new CompareEffects(this.genomeName, this.randSeed, this.verbose);
        String trId = "ENST00000250823";
        comp.snpEffect("tests/" + trId + "_InDels.out", trId, true);
    }

    @Test
    public void test_21_2() {
        Gpr.debug("Test");
        CompareEffects comp = new CompareEffects(this.genomeName, this.randSeed, this.verbose);
        String trId = "ENST00000250823";
        comp.snpEffect("tests/" + trId + "_InDels_2.out", trId, true);
    }

    @Test
    public void test_21_3() {
        Gpr.debug("Test");
        CompareEffects comp = new CompareEffects(this.genomeName, this.randSeed, this.verbose);
        String trId = "ENST00000250823";
        comp.setUseAaNoNum(true);
        comp.snpEffect("tests/" + trId + "_InDels_3.out", trId, true);
    }

    @Test
    public void test_22() {
        boolean trown;
        block4: {
            Gpr.debug("Test");
            CompareEffects comp = new CompareEffects(this.genomeName, this.randSeed, this.verbose);
            VariantTxtFileIterator snpFileIterator = new VariantTxtFileIterator("tests/chr_not_found.out", comp.getConfig().getGenome());
            snpFileIterator.setIgnoreChromosomeErrors(false);
            snpFileIterator.setCreateChromos(false);
            trown = false;
            try {
                for (Variant variant : snpFileIterator) {
                    Gpr.debug(variant);
                }
            }
            catch (RuntimeException e) {
                trown = true;
                String expectedMessage = "ERROR: Chromosome 'chrZ' not found! File 'tests/chr_not_found.out', line 1";
                if (e.getMessage().equals(expectedMessage)) break block4;
                throw new RuntimeException("This is not the exception I was expecting!\n\tExpected message: '" + expectedMessage + "'\n\tMessage: '" + e.getMessage() + "'", e);
            }
        }
        if (!trown) {
            throw new RuntimeException("This should have thown an exception 'Chromosome not found!' but it didn't");
        }
    }

    @Test
    public void test_23_MNP_on_exon_edge() {
        Gpr.debug("Test");
        CompareEffects comp = new CompareEffects(this.genomeName, this.randSeed, this.verbose);
        String trId = "ENST00000250823";
        comp.setUseAaNoNum(true);
        comp.snpEffect("tests/" + trId + "_mnp_out_of_exon.txt", trId, true);
    }

    @Test
    public void test_24_delete_exon_utr() {
        Gpr.debug("Test");
        CompareEffects comp = new CompareEffects(this.genomeName, this.randSeed, this.verbose);
        comp.snpEffect("tests/delete_exon_utr.txt", null, true);
    }

    @Test
    public void test_25_exon_bases() {
        Gpr.debug("Test");
        Config config = new Config("testCase", "snpEff.config");
        config.loadSnpEffectPredictor();
        String fastaFile = "tests/testCase.fa";
        String seq2 = GprSeq.fastaSimpleRead(fastaFile);
        int countOk = 0;
        int countErr = 0;
        for (Gene gint : config.getGenome().getGenes()) {
            for (Transcript tr : gint) {
                if (this.verbose) {
                    System.out.println("Transcript: " + tr.getId());
                }
                List exons = tr.sortedStrand();
                for (Exon exon : exons) {
                    for (int i = exon.getStart(); i <= exon.getEnd(); ++i) {
                        String exonBase;
                        String base = seq2.substring(i, i + 1);
                        if (base.equalsIgnoreCase(exonBase = exon.basesAt(i - exon.getStart(), 1))) {
                            ++countOk;
                            continue;
                        }
                        ++countErr;
                        String msg = "ERROR:\tPosition: " + i + "\tExpected: " + base + "\tGot: " + exonBase;
                        if (this.verbose) {
                            Gpr.debug(msg);
                        }
                        throw new RuntimeException(msg);
                    }
                }
            }
        }
        if (this.verbose) {
            System.out.println("Count OK: " + countOk + "\tCount Err: " + countErr);
        }
    }

    @Test
    public void test_26_chr15_78909452() {
        Gpr.debug("Test");
        String genomeName = "testHg3761Chr15";
        CompareEffects comp = new CompareEffects(genomeName, this.randSeed, this.verbose);
        comp.snpEffect("tests/chr15_78909452.txt", null, true);
    }

    @Test
    public void test_28_Splice_mm37_ENSMUSG00000005763() {
        Gpr.debug("Test");
        String gtfFile = "tests/ENSMUSG00000005763.gtf";
        String genome = "testMm37.61";
        Config config = new Config(genome, "snpEff.config");
        SnpEffPredictorFactoryGtf22 fgtf22 = new SnpEffPredictorFactoryGtf22(config);
        fgtf22.setFileName(gtfFile);
        fgtf22.setReadSequences(false);
        SnpEffectPredictor snpEffectPredictor = fgtf22.create();
        config.setSnpEffectPredictor(snpEffectPredictor);
        for (Chromosome chr : config.getGenome()) {
            chr.setEnd(1000000000);
        }
        CompareEffects comp = new CompareEffects(snpEffectPredictor, this.randSeed, this.verbose);
        comp.snpEffect("tests/ENSMUSG00000005763.out", null, true);
    }

    @Test
    public void test_29_Intergenic_in_Gene() {
        Gpr.debug("Test");
        String genomeName = "testHg3763Chr20";
        CompareEffects comp = new CompareEffects(genomeName, this.randSeed, this.verbose);
        comp.snpEffect("tests/warren.eff.missing.chr20.txt", null, true);
    }

    @Test
    public void test_30_RareAa() {
        Gpr.debug("Test");
        String genomeName = "testHg3765Chr22";
        CompareEffects comp = new CompareEffects(genomeName, this.randSeed, this.verbose);
        comp.snpEffect("tests/rareAa.txt", null, true);
    }

    @Test
    public void test_31_CodonTable() {
        Gpr.debug("Test");
        String genomeName = "testHg3767ChrMt";
        CompareEffects comp = new CompareEffects(genomeName, this.randSeed, this.verbose);
        comp.snpEffect("tests/mt.txt", null, true);
    }

    @Test
    public void test_32_StartGained() {
        Gpr.debug("Test");
        String genomeName = "testHg3769Chr12";
        CompareEffects comp = new CompareEffects(genomeName, this.randSeed, this.verbose);
        comp.snpEffect("tests/start_gained_test.txt", null, true);
    }

    @Test
    public void test_33_StartGained_NOT() {
        Gpr.debug("Test");
        String genomeName = "testHg3769Chr12";
        CompareEffects comp = new CompareEffects(genomeName, this.randSeed, this.verbose);
        comp.snpEffectNegate("tests/start_gained_NOT_test.txt", null, true);
    }

    @Test
    public void test_34_StartGained() {
        Gpr.debug("Test");
        String genomeName = "testHg3766Chr1";
        CompareEffects comp = new CompareEffects(genomeName, this.randSeed, this.verbose);
        comp.snpEffect("tests/start_gained_test_2.txt", null, true);
    }

    @Test
    public void test_35_StartGained_NOT() {
        Gpr.debug("Test");
        String genomeName = "testHg3766Chr1";
        CompareEffects comp = new CompareEffects(genomeName, this.randSeed, this.verbose);
        comp.snpEffectNegate("tests/start_gained_NOT_test_2.txt", null, true);
    }

    @Test
    public void test_36_EffectImpact() {
        Gpr.debug("Test");
        Chromosome chr = new Chromosome(null, 0, 1, "1");
        Variant var = new Variant((Marker)chr, 1, "A", "C");
        var.setVariantType(Variant.VariantType.SNP);
        if (this.verbose) {
            System.out.println(var);
        }
        for (EffectType eff : EffectType.values()) {
            VariantEffect varEff = new VariantEffect(var);
            varEff.setEffectType(eff);
            if (!this.verbose) continue;
            System.out.println(var.isVariant() + "\t" + (Object)((Object)eff) + "\t" + (Object)((Object)varEff.getEffectImpact()));
        }
    }

    @Test
    public void test_38_NON_SYNONYMOUS_START() {
        Gpr.debug("Test");
        CompareEffects comp = new CompareEffects(this.genomeName, this.randSeed, this.verbose);
        comp.snpEffect("tests/nonSynStart.out", "ENST00000250823", true);
    }
}

