/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import org.junit.Assert;
import org.junit.Test;
import org.snpeff.SnpEff;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.testCases.integration.TestCasesIntegrationBase;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class TestCasesIntegrationNextProt
extends TestCasesIntegrationBase {
    @Test
    public void test_01_build() {
        Gpr.debug("Test");
        String[] args = new String[]{"buildNextProt", "testHg3770Chr22", "tests/nextProt"};
        SnpEff snpEff = new SnpEff(args);
        snpEff.setVerbose(this.verbose);
        snpEff.setSupressOutput(!this.verbose);
        boolean ok = snpEff.run();
        Assert.assertEquals(true, ok);
    }

    @Test
    public void test_02_ann() {
        Gpr.debug("Test");
        this.checkNextProt("testHg3770Chr22", "tests/test_nextProt_02.vcf", "amino_acid_modification:N-acetylglycine", VariantEffect.EffectImpact.LOW, true);
    }

    @Test
    public void test_02_eff() {
        Gpr.debug("Test");
        this.checkNextProt("testHg3770Chr22", "tests/test_nextProt_02.vcf", "amino_acid_modification:N-acetylglycine", VariantEffect.EffectImpact.LOW, false);
    }

    @Test
    public void test_03_ann() {
        Gpr.debug("Test");
        this.checkNextProt("testHg3770Chr22", "tests/test_nextProt_03.vcf", "amino_acid_modification:Phosphoserine", VariantEffect.EffectImpact.MODERATE, true);
    }

    @Test
    public void test_03_eff() {
        Gpr.debug("Test");
        this.checkNextProt("testHg3770Chr22", "tests/test_nextProt_03.vcf", "amino_acid_modification:Phosphoserine", VariantEffect.EffectImpact.MODERATE, false);
    }

    @Test
    public void test_04_parse() {
        Gpr.debug("Test");
        String vcfFile = "tests/test.nextProt_paren.vcf";
        int count2 = 0;
        for (VcfEntry ve : new VcfFileIterator(vcfFile)) {
            for (VcfEffect eff : ve.getVcfEffects()) {
                if (this.verbose) {
                    System.out.println(eff);
                }
                if (!eff.hasEffectType(EffectType.NEXT_PROT)) continue;
                ++count2;
            }
        }
        if (this.verbose) {
            System.out.println("Count: " + count2);
        }
        Assert.assertTrue(count2 > 0);
    }
}

