/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.testCases.integration.TestCasesIntegrationBase;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class TestCasesIntegrationEff
extends TestCasesIntegrationBase {
    @Test
    public void test_01() {
        Gpr.debug("Test");
        List<VcfEntry> vcfEntries = this.snpEffect("testHg3770Chr22", "tests/eff_sort.vcf", null);
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve);
            }
            VariantEffect.EffectImpact impPrev = VariantEffect.EffectImpact.HIGH;
            for (VcfEffect veff : ve.getVcfEffects()) {
                VariantEffect.EffectImpact imp = veff.getImpact();
                if (this.verbose) {
                    System.out.println("\t" + (Object)((Object)imp) + "\t" + (Object)((Object)impPrev) + "\t" + imp.compareTo(impPrev) + "\t" + veff);
                }
                Assert.assertTrue(impPrev.compareTo(imp) <= 0);
                impPrev = imp;
            }
        }
    }

    @Test
    public void test_01_canonical() {
        Gpr.debug("Test");
        List<VcfEntry> vcfEntries = this.snpEffect("testHg3775Chr8", "tests/eff_sort_canon.vcf", null);
        Assert.assertEquals(1, vcfEntries.size());
        VcfEntry ve = vcfEntries.get(0);
        VcfEffect veff = ve.getVcfEffects().get(0);
        Assert.assertEquals("ENST00000456015", veff.getTranscriptId());
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        String[] args = new String[]{"-o", "gatk"};
        List<VcfEntry> vcfEntries = this.snpEffect("testHg3770Chr22", "tests/eff_sort.vcf", args);
        for (VcfEntry ve : vcfEntries) {
            int numEffs = ve.getVcfEffects().size();
            if (this.verbose) {
                System.out.println("Num effects:" + numEffs + "\t" + ve);
            }
            Assert.assertTrue(numEffs <= 1);
        }
    }

    @Test
    public void test_03_EmptyVcf() {
        Gpr.debug("Test");
        String[] args = new String[]{"eff", "-noLog"};
        this.snpEffect("testHg3770Chr22", "tests/empty_only_header.vcf", args);
    }

    @Test
    public void test_04() {
        Gpr.debug("Test");
        String[] args = new String[]{"-csvStats", "test_04_TestCasesEff.csv"};
        this.snpEffect("testHg3770Chr22", "tests/eff_sort.vcf", args);
    }

    @Test
    public void test_05() {
        Gpr.debug("Test");
        String genomeName = "testHg3775Chr1";
        String vcf = "tests/gatk_NO_splice_regions.vcf";
        String[] args = new String[]{"eff", "-noLog", "-o", "gatk"};
        List<VcfEntry> vcfEntries = this.snpEffect(genomeName, vcf, args);
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (this.verbose) {
                    System.out.println("\t'" + veff.getEffectsStr() + "'\t" + veff);
                }
                if (veff.getEffectsStr().indexOf("SPLICE_SITE_REGION") < 0) continue;
                throw new RuntimeException("Splice region effects should not present in GATK compatible mode");
            }
        }
    }

    @Test
    public void test_06() {
        Gpr.debug("Test");
        String[] args = new String[]{};
        List<VcfEntry> list2 = this.snpEffect("testHg3775Chr15", "tests/mnp_insertion_at_transcript_end.vcf", args);
        Assert.assertFalse(list2.get(0).getInfoStr().isEmpty());
    }

    @Test
    public void test_07() {
        Gpr.debug("Test");
        String[] args = new String[]{};
        List<VcfEntry> list2 = this.snpEffect("testHg3775Chr10", "tests/mnp_deletion.vcf", args);
        Assert.assertFalse(list2.get(0).getInfoStr().isEmpty());
    }

    @Test
    public void test_08_gatk_missing_annotations() {
        Gpr.debug("Test");
        String genomeName = "testMycobacterium_tuberculosis_CCDC5079_uid203790";
        String vcf = "tests/test_gatk_no_annotations.vcf";
        String[] args = new String[]{"-noLog", "-o", "gatk"};
        List<VcfEntry> vcfEntries = this.snpEffect(genomeName, vcf, args);
        for (VcfEntry ve : vcfEntries) {
            int count2 = 0;
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (this.verbose) {
                    System.out.println("\t'" + veff.getEffectsStr() + "'\t" + veff);
                }
                ++count2;
            }
            Assert.assertEquals(1, count2);
        }
    }
}

