/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import org.snpeff.SnpEff;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.Hgvs;
import org.snpeff.snpEffect.LossOfFunction;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.snpEffect.commandLine.SnpEffCmdBuild;
import org.snpeff.snpEffect.commandLine.SnpEffCmdEff;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryEmbl;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryGenBank;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryGff3;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryGtf22;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactoryRefSeq;
import org.snpeff.util.Diff;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.EffFormatVersion;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class TestCasesIntegrationBase {
    public static int SHOW_EVERY = 10;
    public boolean debug;
    public boolean verbose;
    protected boolean ignoreErrors;
    protected boolean shiftHgvs;
    public String testsDir;

    public TestCasesIntegrationBase() {
        this.verbose = this.debug = false;
        this.ignoreErrors = false;
        this.init();
        this.testsDir = "tests/integration";
    }

    public Transcript appyTranscript(String genome, String trId, String vcfFileName) {
        SnpEffectPredictor sep = this.loadSnpEffectPredictor(genome, false);
        Transcript tr = sep.getGenome().getGenes().findTranscript(trId);
        if (tr == null) {
            throw new RuntimeException("Could not find transcript ID '" + trId + "'");
        }
        VcfFileIterator vcf = new VcfFileIterator(vcfFileName);
        for (VcfEntry ve : vcf) {
            Iterator<Variant> iterator2 = ve.variants().iterator();
            if (!iterator2.hasNext()) continue;
            Variant var = iterator2.next();
            Transcript trNew = tr.apply(var);
            if (this.debug) {
                Gpr.debug(trNew);
            }
            return trNew;
        }
        throw new RuntimeException("Could not apply any variant!");
    }

    public SnpEffectPredictor build(String genome) {
        String[] args = new String[]{"build", genome};
        SnpEff snpeff = new SnpEff(args);
        snpeff.setVerbose(this.verbose);
        SnpEffCmdBuild snpeffBuild = (SnpEffCmdBuild)snpeff.cmd();
        snpeffBuild.run();
        return snpeffBuild.getConfig().getSnpEffectPredictor();
    }

    public SnpEffectPredictor buildAndCompare(String genome, String refSeqFile, String fastaFile, String resultFile, boolean hideProtein) {
        String expectedResult = Gpr.readFile(resultFile).trim();
        Config config = new Config(genome, "snpEff.config");
        SnpEffPredictorFactoryRefSeq factory = new SnpEffPredictorFactoryRefSeq(config);
        factory.setFileName(refSeqFile);
        factory.setVerbose(this.verbose);
        if (fastaFile != null) {
            factory.setFastaFile(fastaFile);
        } else {
            factory.setReadSequences(false);
        }
        SnpEffectPredictor sep = factory.create();
        String result2 = this.showTranscripts(sep.getGenome(), hideProtein).trim();
        if (this.verbose) {
            System.out.println(result2);
        }
        Assert.assertEquals(Gpr.noSpaces(expectedResult), Gpr.noSpaces(result2));
        return sep;
    }

    public SnpEffectPredictor buildEmbl(String genome, String emblFile) {
        Config config = new Config(genome, "snpEff.config");
        SnpEffPredictorFactoryEmbl sepEmbl = new SnpEffPredictorFactoryEmbl(config, emblFile);
        SnpEffectPredictor sep = sepEmbl.create();
        return sep;
    }

    public SnpEffectPredictor buildGeneBank(String genome, String genBankFile) {
        Config config = new Config(genome, "snpEff.config");
        SnpEffPredictorFactoryGenBank sepfg = new SnpEffPredictorFactoryGenBank(config, genBankFile);
        sepfg.setVerbose(this.verbose);
        SnpEffectPredictor sep = sepfg.create();
        return sep;
    }

    public SnpEffectPredictor buildGff3AndCompare(String genome, String gff3File, String resultFile, boolean readSeqs, boolean createRandSequences) {
        Config config = new Config(genome, "snpEff.config");
        SnpEffPredictorFactoryGff3 fgff3 = new SnpEffPredictorFactoryGff3(config);
        fgff3.setVerbose(this.verbose);
        if (gff3File != null) {
            fgff3.setFileName(gff3File);
        }
        fgff3.setReadSequences(readSeqs);
        fgff3.setCreateRandSequences(createRandSequences);
        fgff3.setRandom(new Random(20140410L));
        SnpEffectPredictor sep = fgff3.create();
        if (resultFile != null) {
            String result2 = this.showTranscripts(sep.getGenome()).trim();
            String expectedResult = Gpr.readFile(resultFile).trim();
            String erNs = Gpr.noSpaces(expectedResult);
            String rNs = Gpr.noSpaces(result2);
            if (this.verbose || !erNs.equals(rNs)) {
                System.out.println("Result:\n----------\n" + result2 + "\n----------\n");
                System.out.println("Expected (" + resultFile + "):\n----------\n" + expectedResult + "\n----------\n");
                System.out.println(new Diff(expectedResult, result2));
            }
            Assert.assertEquals(Gpr.noSpaces(expectedResult), Gpr.noSpaces(result2));
        }
        return sep;
    }

    public void buildGtfAndCompare(String genome, String gtf22, String fastaFile, String resultFile) {
        String expectedResult = Gpr.readFile(resultFile).trim();
        Config config = new Config(genome, "snpEff.config");
        SnpEffPredictorFactoryGtf22 fgtf22 = new SnpEffPredictorFactoryGtf22(config);
        fgtf22.setFileName(gtf22);
        fgtf22.setVerbose(this.verbose);
        if (fastaFile != null) {
            fgtf22.setFastaFile(fastaFile);
        } else {
            fgtf22.setReadSequences(false);
        }
        SnpEffectPredictor sep = fgtf22.create();
        String result2 = this.showTranscripts(sep.getGenome(), true).trim();
        if (this.verbose) {
            System.out.println(result2);
        }
        Assert.assertEquals(Gpr.noSpaces(expectedResult), Gpr.noSpaces(result2));
    }

    Marker cdsMarker(Transcript tr) {
        int start = tr.isStrandPlus() ? tr.getCdsStart() : tr.getCdsEnd();
        int end = tr.isStrandPlus() ? tr.getCdsEnd() : tr.getCdsStart();
        return new Marker(tr.getParent(), start, end, false, "");
    }

    void checkAnnotations(SnpEffectPredictor sep, String chr, int pos, String ref, String alt, String hgvsP, String hgvsC, String eff) {
        Genome genome = sep.getGenome();
        Variant var = new Variant((Marker)genome.getChromosome(chr), pos, ref, alt, "");
        VariantEffects varEffs = sep.variantEffect(var);
        for (VariantEffect varEff : varEffs) {
            VcfEffect vcfEff = new VcfEffect(varEff, EffFormatVersion.FORMAT_ANN_1);
            if (this.verbose) {
                System.out.println("\t" + vcfEff);
            }
            Assert.assertEquals(hgvsP, vcfEff.getHgvsProt());
            Assert.assertEquals(hgvsC, vcfEff.getHgvsDna());
            Assert.assertEquals(eff, vcfEff.getEffectsStrSo());
        }
    }

    public void checkHgvs(String genome, String vcfFile, int minCheck) {
        List<VcfEntry> list2 = this.snpEffect(genome, vcfFile, null);
        int countCheck = 0;
        for (VcfEntry ve : list2) {
            if (this.verbose) {
                System.out.println(ve);
            }
            String transcriptId = ve.getInfo("TR");
            if (this.verbose) {
                System.out.println("\tLooking for transcript '" + transcriptId + "'");
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                String expectedHgvsP;
                String expectedHgvsC;
                if (!veff.getTranscriptId().equals(transcriptId)) continue;
                if (this.verbose) {
                    System.out.println("\t" + veff);
                    System.out.println("\t\tHGVS.p: " + veff.getHgvsP() + "\t\tHGVS.c: " + veff.getHgvsC());
                }
                if ((expectedHgvsC = ve.getInfo("HGVSC")) != null) {
                    String actualHgvsC = veff.getHgvsC();
                    Assert.assertEquals("HGVS.c mismatch", expectedHgvsC, actualHgvsC);
                    ++countCheck;
                }
                if ((expectedHgvsP = ve.getInfo("HGVSP")) == null) continue;
                String actualHgvsP = veff.getHgvsP();
                Assert.assertEquals("HGVS.p mismatch", expectedHgvsP, actualHgvsP);
                ++countCheck;
            }
        }
        if (this.verbose) {
            System.out.println("Total checked: " + countCheck);
        }
        Assert.assertTrue("Too few variants checked: " + countCheck, countCheck >= minCheck);
    }

    void checkMotif(String genomeVer, String vcfFile, String effectDetails, VariantEffect.EffectImpact impact, boolean useAnn) {
        String[] args = new String[]{"-classic", "-motif", "-ud", "0", genomeVer, vcfFile};
        String[] argsAnn = new String[]{"-ud", "0", genomeVer, vcfFile};
        if (useAnn) {
            args = argsAnn;
        }
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.cmd();
        cmdEff.setVerbose(this.verbose);
        cmdEff.setSupressOutput(!this.verbose);
        List<VcfEntry> vcfEntries = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        int numNextProt = 0;
        for (VcfEntry ve : vcfEntries) {
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (this.verbose) {
                    System.out.println("\t" + veff.getVcfFieldString());
                }
                if (veff.getEffectType() != EffectType.MOTIF) continue;
                boolean ok = false;
                if (useAnn) {
                    ok = effectDetails.equals(veff.getFeatureId()) && impact == veff.getImpact();
                } else {
                    boolean bl = ok = effectDetails.equals(veff.getEffectDetails()) && impact == veff.getImpact();
                }
                if (!ok) continue;
                ++numNextProt;
            }
        }
        Assert.assertEquals(1, numNextProt);
    }

    void checkNextProt(String genomeVer, String vcfFile, String effectDetails, VariantEffect.EffectImpact impact, boolean useAnn) {
        String[] args = new String[]{"-classic", "-nextProt", genomeVer, vcfFile};
        String[] argsAnn = new String[]{genomeVer, vcfFile};
        if (useAnn) {
            args = argsAnn;
        }
        SnpEff cmd = new SnpEff(args);
        cmd.setVerbose(this.verbose);
        cmd.setSupressOutput(!this.verbose);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.cmd();
        List<VcfEntry> vcfEntries = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        int numNextProt = 0;
        for (VcfEntry ve : vcfEntries) {
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (veff.hasEffectType(EffectType.NEXT_PROT) && impact == veff.getImpact()) {
                    boolean match = false;
                    if (!useAnn && effectDetails.equals(veff.getEffectDetails())) {
                        match = true;
                    }
                    if (useAnn && effectDetails.equals(veff.getFeatureType())) {
                        match = true;
                    }
                    if (match) {
                        ++numNextProt;
                    }
                }
                if (!this.verbose) continue;
                System.out.println("\t" + veff + "\n\t\tEffect            : " + veff.getVcfFieldString() + "\n\t\tEffect type       : " + (Object)((Object)veff.getEffectType()) + "\n\t\tEffect details    : '" + veff.getEffectDetails() + "'\n\t\tEffect impact     : '" + (Object)((Object)veff.getImpact()) + "'\n\t\tExpected details  : '" + effectDetails + "'\n\t\tExpected impact   : '" + (Object)((Object)impact) + "'\n\t\tCount matches     : " + numNextProt + "\thasEffectType : " + veff.hasEffectType(EffectType.NEXT_PROT) + "\tmatch details : " + effectDetails.equals(veff.getEffectDetails()) + "\tmatch impact: " + (impact == veff.getImpact()));
            }
        }
        Assert.assertEquals(1, numNextProt);
    }

    void checkNmd(Config config, Gene gene, Transcript tr) {
        int pos = 0;
        boolean[] isNmd = new boolean[tr.cds().length()];
        HashSet<Exon> codingExons = new HashSet<Exon>();
        StringBuilder nmdStr = new StringBuilder();
        StringBuilder nmdStrSimple = new StringBuilder();
        for (Exon exon : tr.sortedStrand()) {
            int from2;
            int step2 = exon.isStrandPlus() ? 1 : -1;
            for (int expos = from2 = exon.isStrandPlus() ? exon.getStart() : exon.getEnd(); exon.getStart() <= expos && expos <= exon.getEnd(); expos += step2) {
                if (!tr.isUtr(expos)) {
                    codingExons.add(exon);
                    Variant variant = new Variant((Marker)tr.getChromosome(), expos, "A", "C");
                    VariantEffect variantEffect = new VariantEffect(variant);
                    variantEffect.set(exon, EffectType.STOP_GAINED, EffectType.STOP_GAINED.effectImpact(), "");
                    LinkedList<VariantEffect> changeEffects = new LinkedList<VariantEffect>();
                    changeEffects.add(variantEffect);
                    LossOfFunction lof = new LossOfFunction(config, changeEffects);
                    isNmd[pos] = lof.isNmd();
                    nmdStr.append(isNmd[pos] ? (char)'+' : '.');
                    nmdStrSimple.append(isNmd[pos] ? (char)'+' : '.');
                    ++pos;
                    continue;
                }
                nmdStr.append('U');
            }
            nmdStr.append('\t');
            nmdStrSimple.append('\t');
        }
        if (this.verbose) {
            System.err.println(nmdStr);
        }
        if (this.debug) {
            System.err.println("\tCoding Exons:" + codingExons.size());
        }
        if (codingExons.size() > 1) {
            StringBuilder sb = new StringBuilder();
            String[] ex = nmdStrSimple.toString().split("\t");
            for (int i = 0; i < ex.length - 1; ++i) {
                sb.append(ex[i]);
            }
            String simpleNoLast = sb.toString();
            int lastNmd = Math.max(0, simpleNoLast.length() - 50);
            String points = simpleNoLast.substring(lastNmd) + ex[ex.length - 1];
            String plus2 = simpleNoLast.substring(0, lastNmd);
            if (this.debug) {
                System.err.println("\tPoints: " + points + "\n\tPlus :" + plus2);
            }
            Assert.assertEquals(0, points.replace('.', ' ').trim().length());
            Assert.assertEquals(0, plus2.replace('+', ' ').trim().length());
        }
    }

    public void checkNoChange(String[] args) {
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff snpeff = (SnpEffCmdEff)cmd.cmd();
        snpeff.setVerbose(this.verbose);
        snpeff.setSupressOutput(!this.verbose);
        List<VcfEntry> vcfEntries = snpeff.run(true);
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                VariantEffect.EffectImpact imp = veff.getImpact();
                if (this.verbose) {
                    System.out.println("\t" + (Object)((Object)imp) + "\t" + veff);
                }
                Assert.assertEquals((Object)VariantEffect.EffectImpact.MODIFIER, (Object)imp);
            }
        }
    }

    public void checkTranscriptError(String[] args, VariantEffect.ErrorWarningType warningType) {
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff snpeff = (SnpEffCmdEff)cmd.cmd();
        snpeff.setVerbose(this.verbose);
        snpeff.setSupressOutput(!this.verbose);
        List<VcfEntry> vcfEntries = snpeff.run(true);
        boolean hasWarning = false;
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                VariantEffect.EffectImpact imp = veff.getImpact();
                if (this.verbose) {
                    System.out.println("\t" + (Object)((Object)imp) + "\t" + veff);
                }
                if (veff.getErrorsWarning() == null) continue;
                hasWarning |= veff.getErrorsWarning().indexOf(warningType.toString()) >= 0;
            }
        }
        Assert.assertEquals(true, hasWarning);
    }

    public void compareHgvs(String genome, String vcfFileName) {
        this.compareHgvs(genome, vcfFileName, true);
    }

    public void compareHgvs(String genome, String vcfFileName, boolean compareProt) {
        String[] args = new String[]{genome, vcfFileName};
        SnpEffCmdEff snpeff = new SnpEffCmdEff();
        snpeff.parseArgs(args);
        snpeff.setDebug(this.debug);
        snpeff.setVerbose(this.verbose);
        snpeff.setSupressOutput(!this.verbose);
        snpeff.setUpDownStreamLength(0);
        snpeff.setShiftHgvs(this.shiftHgvs);
        snpeff.setFormatVersion(EffFormatVersion.FORMAT_EFF_4);
        List<VcfEntry> results = snpeff.run(true);
        HashSet<String> trNotFoundSet = new HashSet<String>();
        int countOkC = 0;
        int countErrC = 0;
        int countOkP = 0;
        int countErrP = 0;
        int countTrFound = 0;
        for (VcfEntry ve : results) {
            String hgvsCexp = ve.getInfo("HGVS_C") != null ? ve.getInfo("HGVS_C") : "";
            String trIdC = Hgvs.parseTranscript(hgvsCexp);
            hgvsCexp = Hgvs.removeTranscript(hgvsCexp);
            String hgvsPexp = "";
            String trIdP = "";
            if (compareProt) {
                hgvsPexp = ve.getInfo("HGVS_P") != null ? ve.getInfo("HGVS_P") : "";
                trIdP = Hgvs.parseTranscript(hgvsPexp);
                hgvsPexp = Hgvs.removeTranscript(hgvsPexp);
            }
            if (this.verbose) {
                System.out.println(ve);
                if (trIdC != null) {
                    System.out.println("\tExpected HGVS_C: " + trIdC + ":" + hgvsCexp);
                }
                if (trIdP != null) {
                    System.out.println("\tExpected HGVS_P: " + trIdP + ":" + hgvsPexp + "\n");
                }
            }
            boolean okC = false;
            boolean okP = false;
            boolean trFound = false;
            for (VcfEffect veff : ve.getVcfEffects()) {
                String trId = veff.getTranscriptId();
                String hgvsCactual = veff.getHgvsDna() != null ? veff.getHgvsDna() : "";
                String hgvsPactual = veff.getHgvsProt() != null ? veff.getHgvsProt() : "";
                boolean foundC = false;
                boolean foundP = false;
                if (trId != null && trId.equals(trIdC)) {
                    trFound = true;
                    if (!hgvsCexp.equals(hgvsCactual)) {
                        if (!this.ignoreErrors) {
                            Assert.assertEquals(hgvsCexp, hgvsCactual);
                        }
                        ++countErrC;
                    } else {
                        foundC = true;
                        okC = true;
                        ++countOkC;
                    }
                }
                if (compareProt && trId != null && trId.equals(trIdP)) {
                    if (!hgvsPexp.equals(hgvsPactual)) {
                        if (!this.ignoreErrors) {
                            Assert.assertEquals(hgvsPexp, hgvsPactual);
                        }
                        ++countErrP;
                    } else {
                        foundP = true;
                        okP = true;
                        ++countOkP;
                    }
                }
                if (!this.verbose) continue;
                System.out.println("\t" + veff + "\n\t\tEFF    : " + veff.getEffectsStr() + "\n\t\tHGVS_C : " + trId + ":" + hgvsCactual + "\t\tExpected: " + trIdC + ":" + hgvsCexp + "\t" + (foundC ? "OK" : "NO") + (compareProt ? "\n\t\tHGVS_P : " + trId + ":" + hgvsPactual + "\t\tExpected: " + trIdP + ":" + hgvsPexp + "\t" + (foundP ? "OK" : "NO") : "") + "\n");
            }
            if (!trFound) {
                System.out.println("Transcript '" + trIdC + "' not found.");
                ++countTrFound;
                trNotFoundSet.add(trIdC);
            }
            if (!this.ignoreErrors) {
                Assert.assertTrue("HGVS (DNA) not found: '" + hgvsCexp + "'", okC);
                if (hgvsPexp.isEmpty()) continue;
                Assert.assertTrue("HGVS (Protein) not found: '" + hgvsPexp + "'", okP);
                continue;
            }
            if (!okC) {
                System.err.println("HGVS (DNA) not found : '" + hgvsCexp + "', vcf entry:\t" + ve);
            }
            if (!compareProt || okP) continue;
            System.err.println("HGVS (Prot) not found: '" + hgvsPexp + "', vcf entry:\t" + ve);
        }
        if (this.verbose || this.ignoreErrors) {
            System.out.println("Count OKs   :\tHGVS (DNA): " + countOkC + "\tHGVS (Protein): " + countOkP);
            System.out.println("Count Errors:\tHGVS (DNA): " + countErrC + "\tHGVS (Protein): " + countErrP);
            System.out.println("Transcripts not found:\t" + countTrFound + ", unique: " + trNotFoundSet.size() + "\n" + trNotFoundSet);
        }
    }

    public void compareVep(String genome, String vcf, String trId) {
        String[] args = new String[]{"-classic", genome, vcf};
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.cmd();
        cmdEff.setSupressOutput(!this.verbose);
        List<VcfEntry> vcfEnties = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        for (VcfEntry ve : vcfEnties) {
            StringBuilder msg = new StringBuilder();
            boolean ok = false;
            for (VcfEffect veff : ve.getVcfEffects()) {
                String eff;
                if (veff.getTranscriptId() == null || !veff.getTranscriptId().equals(trId)) continue;
                String vep = ve.getInfo("EFF_V");
                if (vep.equals(eff = veff.getEffectType().toString())) {
                    ok = true;
                    continue;
                }
                if (vep.equals("CODON_INSERTION") && eff.equals("CODON_CHANGE_PLUS_CODON_INSERTION")) {
                    ok = true;
                    continue;
                }
                if (vep.equals("STOP_GAINED,CODON_INSERTION") && eff.equals("STOP_GAINED")) {
                    ok = true;
                    continue;
                }
                if (eff.equals("SPLICE_SITE_REGION")) {
                    ok = true;
                    continue;
                }
                String line = "\n" + ve + "\n\tSnpEff:" + veff + "\n\tVEP   :" + ve.getInfo("EFF_V") + "\t" + ve.getInfo("AA") + "\t" + ve.getInfo("CODON") + "\n";
                msg.append(line);
            }
            if (ok) continue;
            throw new RuntimeException(msg.toString());
        }
    }

    public void compareVepSO(String genome, String vcf, String trId) {
        String[] args = new String[]{"-classic", "-sequenceOntology", genome, vcf};
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.cmd();
        cmdEff.setVerbose(this.verbose);
        cmdEff.setSupressOutput(!this.verbose);
        List<VcfEntry> vcfEnties = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        for (VcfEntry ve : vcfEnties) {
            HashSet<String> vepSos = new HashSet<String>();
            String vepSo = ve.getInfo("SO");
            for (String so : vepSo.split(",")) {
                if (so.equals("feature_elongation")) {
                    so = null;
                } else if (so.equals("feature_truncation")) {
                    so = null;
                }
                if (so == null) continue;
                vepSos.add(so);
            }
            HashSet<String> effSos = new HashSet<String>();
            List<VcfEffect> veffs = ve.getVcfEffects();
            for (VcfEffect veff : veffs) {
                if (!veff.getTranscriptId().equals(trId)) continue;
                String effs = veff.getEffString();
                for (String eff : effs.split("\\+")) {
                    if (eff.equals("5_prime_UTR_premature_start_codon_gain_variant")) {
                        eff = "5_prime_UTR_variant";
                    }
                    if (eff.equals("disruptive_inframe_insertion")) {
                        eff = "inframe_insertion";
                    }
                    if (eff.equals("conservative_inframe_insertion")) {
                        eff = "inframe_insertion";
                    }
                    if (eff.equals("start_lost")) {
                        eff = "initiator_codon_variant";
                    }
                    effSos.add(eff);
                }
            }
            boolean error = !effSos.containsAll(vepSos);
            if (!error) continue;
            String msg = "\n" + ve;
            msg = msg + "\n\tSnpEff    : ";
            for (String e : effSos) {
                msg = msg + e + " ";
            }
            msg = msg + "\n\tVEP       : ";
            for (String e : vepSos) {
                msg = msg + e + " ";
            }
            msg = msg + "\n\tMarker    : " + ve.getChromosomeName() + ":" + ve.getStart() + "-" + ve.getEnd();
            Gpr.debug(msg);
            throw new RuntimeException(msg);
        }
    }

    Marker findMarker(SnpEffectPredictor sep, Variant variant, EffectType effectType, Transcript tr, Marker markerFilter) {
        Markers markers = sep.queryDeep(variant);
        for (Marker m : markers) {
            Marker mfilter = null;
            if (markerFilter != null) {
                mfilter = (Marker)m.findParent(markerFilter.getClass());
            }
            Transcript mtr = (Transcript)m.findParent(Transcript.class);
            if (this.debug) {
                Gpr.debug("\tLooking for '" + (Object)((Object)effectType) + "' in '" + (markerFilter != null ? markerFilter.getId() : "NULL") + "', class: " + (markerFilter != null ? markerFilter.getClass().getSimpleName() : "") + "\t\tFound: '" + (Object)((Object)m.getType()) + "', mfilter: " + (mfilter != null ? mfilter.getId() : "NULL") + ", parent: " + m.getParent().getClass().getSimpleName());
            }
            if (m.getType() != effectType || mfilter == null || mtr == null) continue;
            if (markerFilter != null) {
                if (!mfilter.getId().equals(markerFilter.getId())) continue;
                return m;
            }
            if (tr != null) {
                if (!mtr.getId().equals(tr.getId())) continue;
                return m;
            }
            return m;
        }
        throw new RuntimeException("Cannot find '" + (Object)((Object)effectType) + "' " + (markerFilter != null ? "for exon " + markerFilter.getId() : "") + ", seqChange: " + variant);
    }

    public void init() {
    }

    public SnpEffectPredictor loadSnpEffectPredictor(String genome, boolean build) {
        Config config = new Config(genome);
        SnpEffectPredictor sep = SnpEffectPredictor.load(config);
        sep.createGenomicRegions();
        if (build) {
            sep.buildForest();
        }
        return sep;
    }

    public String showTranscripts(Genome genome) {
        return this.showTranscripts(genome, false);
    }

    public String showTranscripts(Genome genome, boolean hideProtein) {
        StringBuilder sb = new StringBuilder();
        sb.append(genome.getVersion() + "\n");
        for (Chromosome chr : genome) {
            sb.append(chr + "\n");
        }
        ArrayList<Gene> genes = new ArrayList<Gene>();
        for (Gene gene : genome.getGenes()) {
            genes.add(gene);
        }
        Collections.sort(genes);
        for (Gene gene : genes) {
            if (hideProtein) {
                for (Transcript tr : gene.sortedStrand()) {
                    tr.setProteinCoding(false);
                }
            }
            sb.append(gene);
            for (Transcript tr : gene.sortedStrand()) {
                sb.append("\t\tCDS '" + tr.getId() + "': " + tr.cds() + "\n");
            }
        }
        return sb.toString();
    }

    public List<VcfEntry> snpEffect(String genome, String vcfFile, String[] otherArgs) {
        return this.snpEffect(genome, vcfFile, otherArgs, EffFormatVersion.FORMAT_EFF_4);
    }

    public List<VcfEntry> snpEffect(String genome, String vcfFile, String[] otherArgs, EffFormatVersion effFormatVersion) {
        ArrayList<String> args = new ArrayList<String>();
        if (otherArgs != null) {
            for (String a : otherArgs) {
                args.add(a);
            }
        }
        args.add(genome);
        args.add(vcfFile);
        SnpEff cmd = new SnpEff(args.toArray(new String[0]));
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.cmd();
        cmdEff.setVerbose(this.verbose);
        cmdEff.setSupressOutput(!this.verbose);
        if (effFormatVersion != null) {
            cmdEff.setFormatVersion(effFormatVersion);
        }
        List<VcfEntry> list2 = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        return list2;
    }

    public void snpEffectCancer(String vcfFile, String txtFile, String genome, boolean classic, String hgsvP, String hgvsC, String genotype, String trId) {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("-cancer");
        argList.add("-hgvs");
        if (classic) {
            argList.add("-classic");
        }
        if (txtFile != null) {
            argList.add("-cancerSamples");
            argList.add(txtFile);
        }
        argList.add(genome);
        argList.add(vcfFile);
        String[] args = argList.toArray(new String[0]);
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.cmd();
        cmdEff.setVerbose(this.verbose);
        cmdEff.setSupressOutput(!this.verbose);
        List<VcfEntry> list2 = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        boolean found = false;
        for (VcfEntry vcfEntry : list2) {
            if (this.debug) {
                System.err.println(vcfEntry);
            }
            for (VcfEffect eff : vcfEntry.getVcfEffects()) {
                if (this.debug) {
                    System.err.println("\t" + eff + "\n\t\tHGVS.p : " + eff.getHgvsProt() + "\n\t\tHGVS.c : " + eff.getHgvsDna() + "\n\t\tGenotype: " + eff.getGenotype());
                }
                if (trId != null && !trId.equals(eff.getTranscriptId()) || !genotype.equals(eff.getGenotype())) continue;
                if (hgsvP != null) {
                    Assert.assertEquals(hgsvP, eff.getHgvsP());
                }
                if (hgvsC != null) {
                    Assert.assertEquals(hgvsC, eff.getHgvsDna());
                }
                found = true;
            }
        }
        if (!found) {
            throw new RuntimeException("Genotype '" + genotype + "' not found.");
        }
    }

    LinkedList<VariantEffect> variantEffects(Variant variant, EffectType effectType, Marker marker) {
        VariantEffect changeEffect = new VariantEffect(variant);
        changeEffect.set(marker, effectType, effectType.effectImpact(), "");
        LinkedList<VariantEffect> variantEffects = new LinkedList<VariantEffect>();
        variantEffects.add(changeEffect);
        return variantEffects;
    }
}

