/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.fastq;

import java.util.Collections;
import java.util.LinkedList;
import org.snpeff.fastq.Fastq;
import org.snpeff.fastq.FastqTools;
import org.snpeff.fastq.FastqTrimmer;

public class FastqTrimmerMedian
extends FastqTrimmer {
    int runningMedianLength;

    public FastqTrimmerMedian(int qualityThreshold, int minBases, int runningMedianLength) {
        super(qualityThreshold, minBases);
        this.runningMedianLength = runningMedianLength;
    }

    int median(int[] qual, int i) {
        LinkedList<Integer> list2 = new LinkedList<Integer>();
        int k = 0;
        int j = i - this.runningMedianLength + 1;
        while (k < this.runningMedianLength) {
            if (j >= 0 && j < qual.length) {
                list2.add(qual[j]);
            }
            ++k;
            ++j;
        }
        Collections.sort(list2);
        int size2 = list2.size();
        int med = 0;
        med = list2.size() % 2 == 1 ? (Integer)list2.get(size2 / 2) : ((Integer)list2.get(size2 / 2 - 1) + (Integer)list2.get(size2 / 2)) / 2;
        return med;
    }

    @Override
    int trimIndex(Fastq fastq) {
        int[] qual = FastqTools.qualtityArray(fastq);
        for (int i = 0; i < qual.length; ++i) {
            int median = this.median(qual, i);
            if (median >= this.qualityThreshold) continue;
            return i;
        }
        return qual.length;
    }
}

