/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.snpeff.fileIterator.RegulationFileIterator;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Regulation;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;

public class RegulationFileConsensus {
    boolean verbose = false;
    int totalCount = 0;
    int totalLineNum = 0;
    long totalLength = 0L;
    String outputDir;
    Map<String, RegulationConsensus> regConsByName = new HashMap<String, RegulationConsensus>();
    Map<String, ArrayList<Regulation>> regListByRegType = new HashMap<String, ArrayList<Regulation>>();

    public void consensus(Regulation reg) {
        String name = reg.getName();
        String regType = reg.getRegulationType();
        String key = regType + "_" + name;
        RegulationConsensus regCons = this.regConsByName.get(key);
        if (regCons == null) {
            regCons = new RegulationConsensus();
            this.regConsByName.put(key, regCons);
        }
        regCons.add(reg);
    }

    void flush() {
        for (RegulationConsensus regCons : this.regConsByName.values()) {
            regCons.flush();
        }
    }

    public Collection<String> getRegTypes() {
        return this.regListByRegType.keySet();
    }

    public ArrayList<Regulation> getRegulationList(String regType) {
        ArrayList<Regulation> regs = this.regListByRegType.get(regType);
        if (regs == null) {
            if (this.verbose) {
                Timer.showStdErr("\tAdding regulatory type: '" + regType + "'");
            }
            regs = new ArrayList();
            this.regListByRegType.put(regType, regs);
        }
        return regs;
    }

    public void readFile(RegulationFileIterator regulationFileIterator) {
        String chromo = "";
        int lineNum = 1;
        for (Regulation reg : regulationFileIterator) {
            if (!chromo.equals(reg.getChromosomeName())) {
                this.flush();
            }
            this.consensus(reg);
            ++lineNum;
            ++this.totalLineNum;
            chromo = reg.getChromosomeName();
        }
        this.flush();
        if (this.verbose) {
            Timer.showStdErr("Done");
            double perc = 100.0 * (double)this.totalCount / (double)this.totalLineNum;
            System.err.println("\tTotal lines                 : " + lineNum);
            System.err.println("\tTotal annotation count      : " + this.totalCount);
            System.err.println("\tPercent                     : " + String.format("%.1f%%", perc));
            System.err.println("\tTotal annotated length      : " + this.totalLength);
            System.err.println("\tNumber of cell/annotations  : " + this.regConsByName.size());
        }
    }

    public void save() {
        this.flush();
        for (String regType : this.regListByRegType.keySet()) {
            Markers markersToSave = new Markers();
            markersToSave.addAll((Collection<? extends Marker>)this.regListByRegType.get(regType));
            if (markersToSave.isEmpty()) continue;
            String rType = Gpr.sanityzeFileName(regType);
            String fileName = this.outputDir + "/regulation_" + rType + ".bin";
            if (this.verbose) {
                Timer.showStdErr("\tSaving database '" + regType + "' (" + markersToSave.size() + " markers) in file '" + fileName + "'");
            }
            markersToSave.save(fileName);
        }
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    void show(Regulation reg) {
        System.out.println(reg);
    }

    class RegulationConsensus {
        int count = 1;
        Regulation consensus = null;

        RegulationConsensus() {
        }

        void add(Regulation r) {
            if (this.consensus == null) {
                this.consensus = r;
                this.count = 1;
            } else if (this.consensus.intersects(r)) {
                this.consensus.setStart(Math.max(this.consensus.getStart(), r.getStart()));
                this.consensus.setEnd(Math.max(this.consensus.getEnd(), r.getEnd()));
                ++this.count;
            } else {
                this.flush();
                this.consensus = r;
                this.count = 1;
            }
        }

        void flush() {
            if (this.consensus != null) {
                ++RegulationFileConsensus.this.totalCount;
                RegulationFileConsensus.this.totalLength += (long)this.consensus.size();
                ArrayList<Regulation> regs = RegulationFileConsensus.this.getRegulationList(this.consensus.getRegulationType());
                regs.add(this.consensus);
            }
        }
    }
}

