/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.internal.runners.ClassRoadie;
import org.junit.internal.runners.CompositeRunner;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.JUnit4ClassRunner;
import org.junit.internal.runners.MethodValidator;
import org.junit.internal.runners.TestClass;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameterized
extends CompositeRunner {
    private final TestClass fTestClass;

    public Parameterized(Class<?> klass) throws Exception {
        super(klass.getName());
        this.fTestClass = new TestClass(klass);
        MethodValidator methodValidator = new MethodValidator(this.fTestClass);
        methodValidator.validateStaticMethods();
        methodValidator.validateInstanceMethods();
        methodValidator.assertValid();
        int i = 0;
        for (Object each : this.getParametersList()) {
            if (each instanceof Object[]) {
                this.add(new TestClassRunnerForParameters(this.fTestClass, (Object[])each, i++));
                continue;
            }
            throw new Exception(String.format("%s.%s() must return a Collection of arrays.", this.fTestClass.getName(), this.getParametersMethod().getName()));
        }
    }

    @Override
    public void run(final RunNotifier notifier) {
        new ClassRoadie(notifier, this.fTestClass, this.getDescription(), new Runnable(){

            public void run() {
                Parameterized.this.runChildren(notifier);
            }
        }).runProtected();
    }

    private Collection<?> getParametersList() throws IllegalAccessException, InvocationTargetException, Exception {
        return (Collection)this.getParametersMethod().invoke(null, new Object[0]);
    }

    private Method getParametersMethod() throws Exception {
        List<Method> methods = this.fTestClass.getAnnotatedMethods(Parameters.class);
        for (Method each : methods) {
            int modifiers = each.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            return each;
        }
        throw new Exception("No public static parameters method on class " + this.getName());
    }

    public static Collection<Object[]> eachOne(Object ... params) {
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        for (Object param2 : params) {
            results.add(new Object[]{param2});
        }
        return results;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Parameters {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestClassRunnerForParameters
    extends JUnit4ClassRunner {
        private final Object[] fParameters;
        private final int fParameterSetNumber;
        private final Constructor<?> fConstructor;

        TestClassRunnerForParameters(TestClass testClass, Object[] parameters, int i) throws InitializationError {
            super(testClass.getJavaClass());
            this.fParameters = parameters;
            this.fParameterSetNumber = i;
            this.fConstructor = this.getOnlyConstructor();
        }

        @Override
        protected Object createTest() throws Exception {
            return this.fConstructor.newInstance(this.fParameters);
        }

        @Override
        protected String getName() {
            return String.format("[%s]", this.fParameterSetNumber);
        }

        @Override
        protected String testName(Method method) {
            return String.format("%s[%s]", method.getName(), this.fParameterSetNumber);
        }

        private Constructor<?> getOnlyConstructor() {
            Constructor<?>[] constructors = this.getTestClass().getJavaClass().getConstructors();
            Assert.assertEquals(1L, constructors.length);
            return constructors[0];
        }

        @Override
        protected void validate() throws InitializationError {
        }

        @Override
        public void run(RunNotifier notifier) {
            this.runMethods(notifier);
        }
    }
}

