/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.io.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.biojava3.core.exceptions.ParserException;
import org.biojava3.core.sequence.io.util.IOUtils;

public class ClasspathResource {
    private final String location;
    private final boolean preCache;
    private final Boolean isGzip;

    public ClasspathResource(String location) {
        this(location, false);
    }

    public ClasspathResource(String location, boolean preCache) {
        this.location = location;
        this.preCache = preCache;
        this.isGzip = null;
    }

    public ClasspathResource(String location, boolean preCache, boolean isGzip) {
        this.location = location;
        this.preCache = preCache;
        this.isGzip = isGzip;
    }

    public InputStream getInputStream() {
        return this.createClasspathInputStream();
    }

    public BufferedReader getBufferedReader() {
        return new BufferedReader(new InputStreamReader(this.getInputStream()));
    }

    public List<String> getList() {
        return IOUtils.getList(this.getBufferedReader());
    }

    private InputStream createClasspathInputStream() {
        InputStream is;
        InputStream classpathIs = this.getClass().getClassLoader().getResourceAsStream(this.location);
        if (classpathIs == null) {
            throw new IllegalArgumentException("Location " + this.location + " resulted in a null InputStream");
        }
        if (this.preCache) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                IOUtils.copy(classpathIs, os);
            }
            catch (IOException e) {
                throw new ParserException("Cannot copy classpath InputStream", e);
            }
            finally {
                IOUtils.close(classpathIs);
            }
            is = new ByteArrayInputStream(os.toByteArray());
        } else {
            is = classpathIs;
        }
        if (this.isGzip()) {
            try {
                return new GZIPInputStream(is);
            }
            catch (IOException e) {
                throw new ParserException("Cannot open stream as a GZIP stream", e);
            }
        }
        return is;
    }

    private boolean isGzip() {
        if (this.isGzip != null) {
            return this.isGzip;
        }
        return this.location.endsWith(".gz");
    }
}

