/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.biojava3.core.sequence.ProteinSequence;
import org.biojava3.core.sequence.compound.AminoAcidCompound;
import org.biojava3.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava3.core.sequence.io.ProteinSequenceCreator;
import org.biojava3.core.sequence.template.AbstractSequence;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.ProxySequenceReader;

public class CasePreservingProteinSequenceCreator
extends ProteinSequenceCreator {
    public CasePreservingProteinSequenceCreator(CompoundSet<AminoAcidCompound> compoundSet) {
        super(compoundSet);
    }

    @Override
    public AbstractSequence<AminoAcidCompound> getSequence(ProxySequenceReader<AminoAcidCompound> proxyLoader, long index2) {
        AbstractSequence<AminoAcidCompound> seq2 = super.getSequence(proxyLoader, index2);
        seq2.setUserCollection(CasePreservingProteinSequenceCreator.getStringCase(proxyLoader.getSequenceAsString()));
        return seq2;
    }

    @Override
    public AbstractSequence<AminoAcidCompound> getSequence(String sequence2, long index2) {
        AbstractSequence<AminoAcidCompound> seq2 = super.getSequence(sequence2.toUpperCase(Locale.ENGLISH), index2);
        seq2.setUserCollection(CasePreservingProteinSequenceCreator.getStringCase(sequence2));
        return seq2;
    }

    @Override
    public AbstractSequence<AminoAcidCompound> getSequence(List<AminoAcidCompound> list2) {
        AbstractSequence<AminoAcidCompound> seq2 = super.getSequence(list2);
        ArrayList<Object> strCase = new ArrayList<Object>(seq2.getLength());
        for (int i = 0; i < seq2.getLength(); ++i) {
            strCase.add(true);
        }
        seq2.setUserCollection(strCase);
        return seq2;
    }

    private static List<Object> getStringCase(String str) {
        ArrayList<Object> types = new ArrayList<Object>(str.length());
        for (int i = 0; i < str.length(); ++i) {
            types.add(Character.isUpperCase(str.charAt(i)));
        }
        return types;
    }

    public static void main(String[] args) {
        CasePreservingProteinSequenceCreator creator = new CasePreservingProteinSequenceCreator(AminoAcidCompoundSet.getAminoAcidCompoundSet());
        AbstractSequence<AminoAcidCompound> seq2 = creator.getSequence("aaAA", 0L);
        System.out.println(seq2.getSequenceAsString());
        System.out.println(seq2.getUserCollection());
    }

    public static void setLowercaseToNull(ProteinSequence seq2, Object[] out) {
        Collection<Object> userCollection = seq2.getUserCollection();
        if (userCollection == null) {
            throw new IllegalArgumentException("Sequence doesn't contain valid case info");
        }
        if (userCollection.size() != out.length) {
            throw new IllegalArgumentException("Sequence length doesn't math output array length");
        }
        int pos = 0;
        for (Object isAligned : userCollection) {
            assert (isAligned instanceof Boolean);
            if (!((Boolean)isAligned).booleanValue()) {
                out[pos] = null;
            }
            ++pos;
        }
    }
}

