/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.scop;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.structure.align.client.JFatCatClient;
import org.biojava.bio.structure.align.util.HTTPConnectionTools;
import org.biojava.bio.structure.domain.SerializableCache;
import org.biojava.bio.structure.scop.RemoteScopInstallation;
import org.biojava.bio.structure.scop.ScopCategory;
import org.biojava.bio.structure.scop.ScopDatabase;
import org.biojava.bio.structure.scop.ScopDescription;
import org.biojava.bio.structure.scop.ScopDomain;
import org.biojava.bio.structure.scop.ScopNode;
import org.biojava.bio.structure.scop.server.ScopDomains;

public class CachedRemoteScopInstallation
extends SerializableCache<String, ScopDomain>
implements ScopDatabase {
    private static String CACHE_FILE_NAME = "remotescopinstallation.ser";
    RemoteScopInstallation proxy = new RemoteScopInstallation();
    SerializableCache<Integer, ScopDescription> scopDescriptionCache = new SerializableCache("scopDescriptionCache.ser");

    public CachedRemoteScopInstallation() {
        this(true);
    }

    public CachedRemoteScopInstallation(boolean useCache) {
        super(CACHE_FILE_NAME);
        if (!useCache) {
            System.err.println("CachedRemoteScopInstallation disableing cache");
            this.disableCache();
            this.scopDescriptionCache.disableCache();
        } else if (this.serializedCache.size() < 8000) {
            this.loadRepresentativeDomains();
        }
    }

    private void loadRepresentativeDomains() {
        ScopDomains results = null;
        try {
            URL u = new URL("http://source.rcsb.org/jfatcatserver/domains/getRepresentativeScopDomains");
            System.out.println(u);
            InputStream response = HTTPConnectionTools.getInputStream(u);
            String xml = JFatCatClient.convertStreamToString(response);
            results = ScopDomains.fromXML(xml);
            System.out.println("got " + results.getScopDomain().size() + " domain ranges for Scop domains from server.");
            for (ScopDomain dom : results.getScopDomain()) {
                String scopId = dom.getScopId();
                this.serializedCache.put(scopId, dom);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<ScopDescription> getByCategory(ScopCategory category) {
        return this.proxy.getByCategory(category);
    }

    @Override
    public List<ScopDescription> filterByClassificationId(String query) {
        return this.proxy.filterByClassificationId(query);
    }

    @Override
    public List<ScopNode> getTree(ScopDomain domain) {
        return this.proxy.getTree(domain);
    }

    @Override
    public List<ScopDomain> filterByDomainName(String query) {
        return this.proxy.filterByDomainName(query);
    }

    @Override
    public List<ScopDescription> filterByDescription(String query) {
        return this.proxy.filterByClassificationId(query);
    }

    @Override
    public ScopDescription getScopDescriptionBySunid(int sunid) {
        ScopDescription desc = this.scopDescriptionCache.get(sunid);
        if (desc != null) {
            return desc;
        }
        desc = this.proxy.getScopDescriptionBySunid(sunid);
        if (desc != null) {
            this.scopDescriptionCache.cache(sunid, desc);
        }
        return desc;
    }

    @Override
    public List<ScopDomain> getDomainsForPDB(String pdbId) {
        return this.proxy.getDomainsForPDB(pdbId);
    }

    @Override
    public ScopDomain getDomainByScopID(String scopId) {
        ScopDomain dom;
        if (this.serializedCache != null && this.serializedCache.containsKey(scopId) && (dom = (ScopDomain)this.serializedCache.get(scopId)) != null) {
            return dom;
        }
        dom = this.proxy.getDomainByScopID(scopId);
        if (dom != null) {
            this.cache(scopId, dom);
        }
        return dom;
    }

    @Override
    public ScopNode getScopNode(int sunid) {
        return this.proxy.getScopNode(sunid);
    }

    @Override
    public String getScopVersion() {
        return this.proxy.getScopVersion();
    }

    @Override
    public List<ScopDomain> getScopDomainsBySunid(Integer sunid) {
        return this.proxy.getScopDomainsBySunid(sunid);
    }

    @Override
    public void flushCache() {
        System.out.println("flushing CachedRemoteScopInstallation");
        super.flushCache();
        this.scopDescriptionCache.flushCache();
    }

    @Override
    public List<String> getComments(int sunid) {
        return new ArrayList<String>(1);
    }
}

