/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.quaternary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.AtomImpl;
import org.biojava.bio.structure.Calc;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.io.mmcif.model.PdbxStructAssembly;
import org.biojava.bio.structure.io.mmcif.model.PdbxStructAssemblyGen;
import org.biojava.bio.structure.io.mmcif.model.PdbxStructOperList;
import org.biojava.bio.structure.jama.Matrix;
import org.biojava.bio.structure.quaternary.ModelTransformationMatrix;
import org.biojava.bio.structure.quaternary.OperatorResolver;
import org.biojava.bio.structure.quaternary.OrderedPair;

public class BiologicalAssemblyBuilder {
    OperatorResolver operatorResolver;
    String asymId;
    PdbxStructAssembly psa;
    List<PdbxStructAssemblyGen> psags;
    List<ModelTransformationMatrix> modelTransformations;

    public BiologicalAssemblyBuilder() {
        this.init();
    }

    private void init() {
        this.operatorResolver = new OperatorResolver();
        this.modelTransformations = new ArrayList<ModelTransformationMatrix>(1);
    }

    public Structure rebuildQuaternaryStructure(Structure asymUnit, List<ModelTransformationMatrix> transformations) {
        Structure s = asymUnit.clone();
        ArrayList<Chain> transformedChains = new ArrayList<Chain>();
        s.setChains(transformedChains);
        for (ModelTransformationMatrix max2 : transformations) {
            boolean foundChain = false;
            for (Chain c : asymUnit.getChains()) {
                String intChainID = c.getInternalChainID();
                if (intChainID == null) {
                    intChainID = c.getChainID();
                }
                if (!max2.ndbChainId.equals(intChainID)) continue;
                foundChain = true;
                Chain newChain = (Chain)c.clone();
                Matrix m = max2.getMatrix();
                double[] vector = max2.getVector();
                AtomImpl v = new AtomImpl();
                v.setCoords(vector);
                for (Group g : newChain.getAtomGroups()) {
                    for (Atom a : g.getAtoms()) {
                        Calc.rotate(a, m);
                        Calc.shift(a, (Atom)v);
                    }
                }
                this.addCheckChainModel(s, newChain);
            }
            if (foundChain) continue;
        }
        s.setBiologicalAssembly(true);
        return s;
    }

    private void addCheckChainModel(Structure s, Chain newChain) {
        for (int i = 0; i < s.nrModels(); ++i) {
            List<Chain> model = s.getModel(i);
            boolean found = false;
            for (Chain c : model) {
                if (!c.getChainID().equals(newChain.getChainID())) continue;
                found = true;
                break;
            }
            if (found) continue;
            model.add(newChain);
            return;
        }
        ArrayList<Chain> newModel = new ArrayList<Chain>();
        newModel.add(newChain);
        s.addModel(newModel);
    }

    public ArrayList<ModelTransformationMatrix> getBioUnitTransformationList(PdbxStructAssembly psa, List<PdbxStructAssemblyGen> psags, List<PdbxStructOperList> operators) {
        this.init();
        this.psa = psa;
        this.psags = psags;
        this.asymId = psa.getId();
        for (PdbxStructOperList oper : operators) {
            ModelTransformationMatrix transform2 = new ModelTransformationMatrix();
            transform2.id = oper.getId();
            transform2.setTransformationMatrix(oper.getMatrix(), oper.getVector());
            this.modelTransformations.add(transform2);
        }
        ArrayList<ModelTransformationMatrix> transformations = this.getBioUnitTransformationsListUnaryOperators(psa.getId());
        transformations.addAll(this.getBioUnitTransformationsListBinaryOperators(psa.getId()));
        transformations.trimToSize();
        return transformations;
    }

    private ArrayList<ModelTransformationMatrix> getBioUnitTransformationsListBinaryOperators(String assemblyId) {
        ArrayList<ModelTransformationMatrix> transformations = new ArrayList<ModelTransformationMatrix>();
        List<OrderedPair<String>> operators = this.operatorResolver.getBinaryOperators();
        for (PdbxStructAssemblyGen psag : this.psags) {
            if (!psag.getAssembly_id().equals(assemblyId)) continue;
            List<String> asymIds = Arrays.asList(psag.getAsym_id_list().split(","));
            this.operatorResolver.parseOperatorExpressionString(psag.getOper_expression());
            for (String chainId : asymIds) {
                for (OrderedPair<String> operator : operators) {
                    ModelTransformationMatrix original1 = this.getModelTransformationMatrix(operator.getElement1());
                    ModelTransformationMatrix original2 = this.getModelTransformationMatrix(operator.getElement2());
                    ModelTransformationMatrix transform2 = ModelTransformationMatrix.multiply4square_x_4square2(original1, original2);
                    transform2.ndbChainId = chainId;
                    transform2.id = original1.id + "x" + original2.id;
                    transformations.add(transform2);
                }
            }
        }
        return transformations;
    }

    private ModelTransformationMatrix getModelTransformationMatrix(String operator) {
        for (ModelTransformationMatrix transform2 : this.modelTransformations) {
            if (!transform2.id.equals(operator)) continue;
            return transform2;
        }
        System.err.println("Could not find modelTransformationmatrix for " + operator);
        return new ModelTransformationMatrix();
    }

    private ArrayList<ModelTransformationMatrix> getBioUnitTransformationsListUnaryOperators(String assemblyId) {
        ArrayList<ModelTransformationMatrix> transformations = new ArrayList<ModelTransformationMatrix>();
        for (PdbxStructAssemblyGen psag : this.psags) {
            if (!psag.getAssembly_id().equals(assemblyId)) continue;
            this.operatorResolver.parseOperatorExpressionString(psag.getOper_expression());
            List<String> operators = this.operatorResolver.getUnaryOperators();
            List<String> asymIds = Arrays.asList(psag.getAsym_id_list().split(","));
            for (String chainId : asymIds) {
                for (String operator : operators) {
                    ModelTransformationMatrix original = this.getModelTransformationMatrix(operator);
                    ModelTransformationMatrix transform2 = new ModelTransformationMatrix(original);
                    transform2.ndbChainId = chainId;
                    transform2.id = operator;
                    transformations.add(transform2);
                }
            }
        }
        return transformations;
    }
}

