/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.DBRef;
import org.biojava.bio.structure.Element;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.PDBHeader;
import org.biojava.bio.structure.SSBond;
import org.biojava.bio.structure.Site;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava3.core.util.XMLWriter;

public class FileConvert {
    Structure structure;
    boolean printConnections;
    static DecimalFormat d3 = (DecimalFormat)NumberFormat.getInstance(Locale.UK);
    static DecimalFormat d2;
    private static final String newline;

    public FileConvert(Structure struc) {
        this.structure = struc;
        this.printConnections = true;
    }

    private static String alignRight(String input2, int length) {
        int n = input2.length();
        if (n >= length) {
            return input2;
        }
        String spaces2 = "                           ";
        int diff2 = length - n;
        StringBuffer s = new StringBuffer();
        s.append(spaces2.substring(0, diff2));
        s.append(input2);
        return s.toString();
    }

    private static String alignLeft(String input2, int length) {
        if (input2.length() >= length) {
            return input2;
        }
        String spaces2 = "                           ";
        input2 = input2 + spaces2.substring(0, length - input2.length());
        return input2;
    }

    public boolean doPrintConnections() {
        return this.printConnections;
    }

    public void setPrintConnections(boolean printConnections) {
        this.printConnections = printConnections;
    }

    private String printPDBConnections() {
        StringBuffer str = new StringBuffer();
        List<Map<String, Integer>> cons = this.structure.getConnections();
        for (int cnr = 0; cnr < cons.size(); ++cnr) {
            Map<String, Integer> con = cons.get(cnr);
            Integer as = con.get("atomserial");
            String atomserial = "";
            String bond1 = "";
            String bond2 = "";
            String bond3 = "";
            String bond4 = "";
            String hyd1 = "";
            String hyd2 = "";
            String salt1 = "";
            String hyd3 = "";
            String hyd4 = "";
            String salt2 = "";
            if (con.containsKey("bond1")) {
                bond1 = con.get("bond1").toString();
            }
            if (con.containsKey("bond2")) {
                bond2 = con.get("bond2").toString();
            }
            if (con.containsKey("bond3")) {
                bond3 = con.get("bond3").toString();
            }
            if (con.containsKey("bond4")) {
                bond4 = con.get("bond4").toString();
            }
            if (con.containsKey("hyd1")) {
                hyd1 = con.get("hyd1").toString();
            }
            if (con.containsKey("hyd2")) {
                hyd2 = con.get("hyd2").toString();
            }
            if (con.containsKey("salt1")) {
                salt1 = con.get("salt1").toString();
            }
            if (con.containsKey("hyd3")) {
                hyd3 = con.get("hyd3").toString();
            }
            if (con.containsKey("hyd4")) {
                hyd4 = con.get("hyd4").toString();
            }
            if (con.containsKey("salt2")) {
                salt2 = con.get("salt2").toString();
            }
            atomserial = FileConvert.alignRight("" + as, 5);
            bond1 = FileConvert.alignRight(bond1, 5);
            bond2 = FileConvert.alignRight(bond2, 5);
            bond3 = FileConvert.alignRight(bond3, 5);
            bond4 = FileConvert.alignRight(bond4, 5);
            hyd1 = FileConvert.alignRight(hyd1, 5);
            hyd2 = FileConvert.alignRight(hyd2, 5);
            salt1 = FileConvert.alignRight(salt1, 5);
            hyd3 = FileConvert.alignRight(hyd3, 5);
            hyd4 = FileConvert.alignRight(hyd4, 5);
            salt2 = FileConvert.alignRight(salt2, 5);
            String connectLine = "CONECT" + atomserial + bond1 + bond2 + bond3 + bond4 + hyd1 + hyd2 + salt1 + hyd3 + hyd4 + salt2;
            str.append(connectLine).append(newline);
        }
        return str.toString();
    }

    public String toPDB() {
        StringBuffer str = new StringBuffer();
        PDBHeader header = this.structure.getPDBHeader();
        header.toPDB(str);
        if (!this.structure.getSites().isEmpty()) {
            str.append("REMARK 800                                                                      ").append(newline);
            str.append("REMARK 800 SITE                                                                 ").append(newline);
            for (Site site : this.structure.getSites()) {
                site.remark800toPDB(str);
            }
        }
        for (DBRef dbref : this.structure.getDBRefs()) {
            dbref.toPDB(str);
            str.append(newline);
        }
        for (SSBond ssbond : this.structure.getSSBonds()) {
            ssbond.toPDB(str);
            str.append(newline);
        }
        for (Site site : this.structure.getSites()) {
            try {
                site.toPDB(str);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int nrModels = this.structure.nrModels();
        if (this.structure.isNmr()) {
            str.append("EXPDTA    NMR, " + nrModels + " STRUCTURES" + newline);
        }
        for (int m = 0; m < nrModels; ++m) {
            List<Chain> model = this.structure.getModel(m);
            if (this.structure.isNmr()) {
                str.append("MODEL      " + (m + 1) + newline);
            }
            int nrChains = model.size();
            for (int c = 0; c < nrChains; ++c) {
                Chain chain2 = model.get(c);
                int nrGroups = chain2.getAtomLength();
                for (int h = 0; h < nrGroups; ++h) {
                    Group g = chain2.getAtomGroup(h);
                    FileConvert.toPDB(g, str);
                }
            }
            if (!this.structure.isNmr()) continue;
            str.append("ENDMDL").append(newline);
        }
        if (this.doPrintConnections()) {
            str.append(this.printPDBConnections());
        }
        return str.toString();
    }

    private static void toPDB(Group g, StringBuffer str) {
        int groupsize = g.size();
        for (int atompos = 0; atompos < groupsize; ++atompos) {
            Atom a = null;
            try {
                a = g.getAtom(atompos);
            }
            catch (StructureException e) {
                System.err.println(e);
                continue;
            }
            FileConvert.toPDB(a, str);
        }
        if (g.hasAltLoc()) {
            for (Group alt : g.getAltLocs()) {
                FileConvert.toPDB(alt, str);
            }
        }
    }

    public static String toPDB(Atom a) {
        StringBuffer w = new StringBuffer();
        FileConvert.toPDB(a, w);
        return w.toString();
    }

    public static String toPDB(Chain chain2) {
        StringBuffer w = new StringBuffer();
        int nrGroups = chain2.getAtomLength();
        for (int h = 0; h < nrGroups; ++h) {
            Group g = chain2.getAtomGroup(h);
            FileConvert.toPDB(g, w);
        }
        return w.toString();
    }

    public static String toPDB(Group g) {
        StringBuffer w = new StringBuffer();
        FileConvert.toPDB(g, w);
        return w.toString();
    }

    public static void toPDB(Atom a, StringBuffer str) {
        Group g = a.getGroup();
        Chain c = g.getChain();
        String chainID = c.getChainID();
        String type = g.getType();
        String record = "";
        record = type.equals("hetatm") ? "HETATM" : "ATOM  ";
        String resName = g.getPDBName();
        String pdbcode = g.getResidueNumber().toString();
        int seri = a.getPDBserial();
        String serial = FileConvert.alignRight("" + seri, 5);
        String fullname = a.getFullName();
        Character altLoc = a.getAltLoc();
        String resseq = "";
        resseq = FileConvert.hasInsertionCode(pdbcode) ? FileConvert.alignRight("" + pdbcode, 5) : FileConvert.alignRight("" + pdbcode, 4) + " ";
        String x2 = FileConvert.alignRight("" + d3.format(a.getX()), 8);
        String y = FileConvert.alignRight("" + d3.format(a.getY()), 8);
        String z = FileConvert.alignRight("" + d3.format(a.getZ()), 8);
        String occupancy = FileConvert.alignRight("" + d2.format(a.getOccupancy()), 6);
        String tempfactor = FileConvert.alignRight("" + d2.format(a.getTempFactor()), 6);
        String leftResName = FileConvert.alignLeft(resName, 3);
        StringBuffer s = new StringBuffer();
        s.append(record);
        s.append(serial);
        s.append(" ");
        s.append(fullname);
        s.append(altLoc);
        s.append(leftResName);
        s.append(" ");
        s.append(chainID);
        s.append(resseq);
        s.append("   ");
        s.append(x2);
        s.append(y);
        s.append(z);
        s.append(occupancy);
        s.append(tempfactor);
        Element e = a.getElement();
        String eString = e.toString().toUpperCase();
        if (e.equals(Element.R)) {
            eString = "X";
        }
        str.append(String.format("%-76s%2s", s.toString(), eString));
        str.append(newline);
    }

    private static boolean hasInsertionCode(String pdbserial) {
        try {
            Integer.parseInt(pdbserial);
        }
        catch (NumberFormatException e) {
            return true;
        }
        return false;
    }

    public void toDASStructure(XMLWriter xw) throws IOException {
        if (this.structure == null) {
            System.err.println("can not convert structure null");
            return;
        }
        Map<String, Object> header = this.structure.getHeader();
        xw.openTag("object");
        xw.attribute("dbAccessionId", this.structure.getPDBCode());
        xw.attribute("intObjectId", this.structure.getPDBCode());
        String modificationDate = (String)header.get("modDate");
        xw.attribute("objectVersion", modificationDate);
        xw.attribute("type", "protein structure");
        xw.attribute("dbSource", "PDB");
        xw.attribute("dbVersion", "20070116");
        xw.attribute("dbCoordSys", "PDBresnum,Protein Structure");
        xw.closeTag("object");
        for (int modelnr = 0; modelnr < this.structure.nrModels(); ++modelnr) {
            for (int chainnr = 0; chainnr < this.structure.size(modelnr); ++chainnr) {
                Chain chain2 = this.structure.getChain(modelnr, chainnr);
                xw.openTag("chain");
                xw.attribute("id", chain2.getChainID());
                xw.attribute("SwissprotId", chain2.getSwissprotId());
                if (this.structure.isNmr()) {
                    xw.attribute("model", Integer.toString(modelnr + 1));
                }
                for (int groupnr = 0; groupnr < chain2.getAtomLength(); ++groupnr) {
                    Group gr = chain2.getAtomGroup(groupnr);
                    xw.openTag("group");
                    xw.attribute("name", gr.getPDBName());
                    xw.attribute("type", gr.getType());
                    xw.attribute("groupID", gr.getResidueNumber().toString());
                    List<Atom> atoms = gr.getAtoms();
                    for (int atomnr = 0; atomnr < atoms.size(); ++atomnr) {
                        Atom atom = atoms.get(atomnr);
                        xw.openTag("atom");
                        xw.attribute("atomID", Integer.toString(atom.getPDBserial()));
                        xw.attribute("atomName", atom.getFullName());
                        xw.attribute("x", Double.toString(atom.getX()));
                        xw.attribute("y", Double.toString(atom.getY()));
                        xw.attribute("z", Double.toString(atom.getZ()));
                        xw.closeTag("atom");
                    }
                    xw.closeTag("group");
                }
                xw.closeTag("chain");
            }
        }
        if (this.doPrintConnections()) {
            List<Map<String, Integer>> cons = this.structure.getConnections();
            for (int cnr = 0; cnr < cons.size(); ++cnr) {
                Map<String, Integer> con = cons.get(cnr);
                Integer as = con.get("atomserial");
                int atomserial = as;
                ArrayList<Integer> atomids = new ArrayList<Integer>();
                if (con.containsKey("salt1")) {
                    atomids.add(con.get("salt1"));
                }
                if (con.containsKey("salt2")) {
                    atomids.add(con.get("salt2"));
                }
                if (atomids.size() != 0) {
                    this.addConnection(xw, "salt", atomserial, atomids);
                    atomids = new ArrayList();
                }
                if (con.containsKey("hydrogen1")) {
                    atomids.add(con.get("hydrogen1"));
                }
                if (con.containsKey("hydrogen2")) {
                    atomids.add(con.get("hydrogen2"));
                }
                if (con.containsKey("hydrogen3")) {
                    atomids.add(con.get("hydrogen3"));
                }
                if (con.containsKey("hydrogen4")) {
                    atomids.add(con.get("hydrogen4"));
                }
                if (atomids.size() != 0) {
                    this.addConnection(xw, "hydrogen", atomserial, atomids);
                    atomids = new ArrayList();
                }
                if (con.containsKey("bond1")) {
                    atomids.add(con.get("bond1"));
                }
                if (con.containsKey("bond2")) {
                    atomids.add(con.get("bond2"));
                }
                if (con.containsKey("bond3")) {
                    atomids.add(con.get("bond3"));
                }
                if (con.containsKey("bond4")) {
                    atomids.add(con.get("bond4"));
                }
                if (atomids.size() == 0) continue;
                this.addConnection(xw, "bond", atomserial, atomids);
            }
        }
    }

    private void addConnection(XMLWriter xw, String connType, int atomserial, List<Integer> atomids) {
        try {
            xw.openTag("connect");
            xw.attribute("atomSerial", Integer.toString(atomserial));
            xw.attribute("type", connType);
            for (int i = 0; i < atomids.size(); ++i) {
                Integer atomid = atomids.get(i);
                if (atomid == null) continue;
                int aid = atomid;
                xw.openTag("atomID");
                xw.attribute("atomID", Integer.toString(aid));
                xw.closeTag("atomID");
            }
            xw.closeTag("connect");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        d3.setMaximumIntegerDigits(3);
        d3.setMinimumFractionDigits(3);
        d3.setMaximumFractionDigits(3);
        d2 = (DecimalFormat)NumberFormat.getInstance(Locale.UK);
        d2.setMaximumIntegerDigits(2);
        d2.setMinimumFractionDigits(2);
        d2.setMaximumFractionDigits(2);
        newline = System.getProperty("line.separator");
    }
}

