/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.align.util;

import java.io.StringWriter;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.AtomImpl;
import org.biojava.bio.structure.Calc;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.align.model.AFPChain;
import org.biojava.bio.structure.jama.Matrix;

public final class RotationAxis {
    static final double MIN_ANGLE = Math.toRadians(5.0);
    private double theta;
    private Atom rotationAxis;
    private Atom rotationPos;
    private Atom screwTranslation;
    private Atom otherTranslation;

    public double getAngle() {
        return this.theta;
    }

    public Atom getRotationAxis() {
        return this.rotationAxis;
    }

    public Atom getRotationPos() {
        return this.rotationPos;
    }

    public Atom getScrewTranslation() {
        return this.screwTranslation;
    }

    @Deprecated
    public Atom getOtherTranslation() {
        return this.otherTranslation;
    }

    public RotationAxis(AFPChain afpChain) throws StructureException {
        if (afpChain.getAlnLength() < 1) {
            throw new StructureException("No aligned residues");
        }
        this.init(afpChain.getBlockRotationMatrix()[0], afpChain.getBlockShiftVector()[0]);
    }

    public RotationAxis(Matrix rotation, Atom translation) {
        this.init(rotation, translation);
    }

    private void init(Matrix rotation, Atom translation) {
        if (rotation.getColumnDimension() != 3 || rotation.getRowDimension() != 3) {
            throw new IllegalArgumentException("Expected 3x3 rotation matrix");
        }
        double c = (rotation.trace() - 1.0) / 2.0;
        this.theta = Math.acos(c);
        if (this.theta < MIN_ANGLE) {
            this.calculateTranslationalAxis(rotation, translation);
        } else {
            this.calculateRotationalAxis(rotation, translation, c);
        }
    }

    private void calculateRotationalAxis(Matrix rotation, Atom translation, double c) {
        int i;
        double sum2 = 0.0;
        double[] rotAx = new double[3];
        for (i = 0; i < 3; ++i) {
            rotAx[i] = Math.sqrt(rotation.get(i, i) - c);
            sum2 += rotAx[i] * rotAx[i];
        }
        i = 0;
        while (i < 3) {
            int n = i++;
            rotAx[n] = rotAx[n] / Math.sqrt(sum2);
        }
        double d0 = rotation.get(2, 1) - rotation.get(1, 2);
        double d1 = rotation.get(0, 2) - rotation.get(2, 0);
        double d2 = rotation.get(1, 0) - rotation.get(0, 1);
        double s12 = rotation.get(2, 1) + rotation.get(1, 2);
        double s02 = rotation.get(0, 2) + rotation.get(2, 0);
        double s01 = rotation.get(1, 0) + rotation.get(0, 1);
        if (Math.abs(d0) < Math.abs(d1)) {
            if (Math.abs(d1) < Math.abs(d2)) {
                if (d2 >= 0.0) {
                    if (s02 < 0.0) {
                        rotAx[0] = -rotAx[0];
                    }
                    if (s12 < 0.0) {
                        rotAx[1] = -rotAx[1];
                    }
                } else {
                    rotAx[2] = -rotAx[2];
                    if (s02 >= 0.0) {
                        rotAx[0] = -rotAx[0];
                    }
                    if (s12 >= 0.0) {
                        rotAx[1] = -rotAx[1];
                    }
                }
            } else if (d1 >= 0.0) {
                if (s01 < 0.0) {
                    rotAx[0] = -rotAx[0];
                }
                if (s12 < 0.0) {
                    rotAx[2] = -rotAx[2];
                }
            } else {
                rotAx[1] = -rotAx[1];
                if (s01 >= 0.0) {
                    rotAx[0] = -rotAx[0];
                }
                if (s12 >= 0.0) {
                    rotAx[2] = -rotAx[2];
                }
            }
        } else if (Math.abs(d0) < Math.abs(d2)) {
            if (d2 >= 0.0) {
                if (s02 < 0.0) {
                    rotAx[0] = -rotAx[0];
                }
                if (s12 < 0.0) {
                    rotAx[1] = -rotAx[1];
                }
            } else {
                rotAx[2] = -rotAx[2];
                if (s02 >= 0.0) {
                    rotAx[0] = -rotAx[0];
                }
                if (s12 >= 0.0) {
                    rotAx[1] = -rotAx[1];
                }
            }
        } else if (d0 >= 0.0) {
            if (s01 < 0.0) {
                rotAx[1] = -rotAx[1];
            }
            if (s02 < 0.0) {
                rotAx[2] = -rotAx[2];
            }
        } else {
            rotAx[0] = -rotAx[0];
            if (s01 >= 0.0) {
                rotAx[1] = -rotAx[1];
            }
            if (s02 >= 0.0) {
                rotAx[2] = -rotAx[2];
            }
        }
        this.rotationAxis = new AtomImpl();
        this.rotationAxis.setCoords(rotAx);
        double dotProduct = Calc.skalarProduct(this.rotationAxis, translation);
        this.screwTranslation = Calc.scale(this.rotationAxis, dotProduct);
        this.otherTranslation = Calc.subtract(translation, this.screwTranslation);
        Atom hypot = Calc.vectorProduct(this.otherTranslation, this.rotationAxis);
        Calc.scaleEquals(hypot, 0.5 / Math.tan(this.theta / 2.0));
        this.rotationPos = Calc.scaleAdd(0.5, this.otherTranslation, hypot);
    }

    private void calculateTranslationalAxis(Matrix rotation, Atom translation) {
        this.rotationAxis = Calc.scale(translation, 1.0 / Calc.amount(translation));
        this.rotationPos = null;
        this.screwTranslation = translation;
        this.otherTranslation = new AtomImpl();
        this.otherTranslation.setCoords(new double[]{0.0, 0.0, 0.0});
    }

    public String getJmolScript(Atom[] atoms) {
        boolean positiveScrew;
        Atom axialPt;
        double max2;
        double width = 0.5;
        String axisColor = "yellow";
        String screwColor = "orange";
        double min2 = max2 = Calc.skalarProduct(this.rotationAxis, atoms[0]);
        for (int i = 1; i < atoms.length; ++i) {
            double prod = Calc.skalarProduct(this.rotationAxis, atoms[i]);
            if (prod < min2) {
                min2 = prod;
            }
            if (!(prod > max2)) continue;
            max2 = prod;
        }
        double uLen = Calc.skalarProduct(this.rotationAxis, this.rotationAxis);
        min2 /= uLen;
        max2 /= uLen;
        if (this.rotationPos == null) {
            Atom center = Calc.centerOfMass(atoms);
            Atom centerOnAxis = Calc.scale(this.rotationAxis, Calc.skalarProduct(center, this.rotationAxis));
            axialPt = Calc.subtract(center, centerOnAxis);
        } else {
            axialPt = this.rotationPos;
        }
        Atom axisMin = (Atom)axialPt.clone();
        Calc.scaleAdd(min2, this.rotationAxis, axisMin);
        Atom axisMax = (Atom)axialPt.clone();
        Calc.scaleAdd(max2, this.rotationAxis, axisMax);
        StringWriter result2 = new StringWriter();
        result2.append("set defaultDrawArrowScale 2.0;");
        result2.append(String.format("draw ID rot CYLINDER {%f,%f,%f} {%f,%f,%f} WIDTH %f COLOR %s ;", axisMin.getX(), axisMin.getY(), axisMin.getZ(), axisMax.getX(), axisMax.getY(), axisMax.getZ(), 0.5, "yellow"));
        boolean bl = positiveScrew = Math.signum(this.rotationAxis.getX()) == Math.signum(this.screwTranslation.getX());
        if (positiveScrew) {
            result2.append(String.format("draw ID screw VECTOR {%f,%f,%f} {%f,%f,%f} WIDTH %f COLOR %s ;", axisMax.getX(), axisMax.getY(), axisMax.getZ(), this.screwTranslation.getX(), this.screwTranslation.getY(), this.screwTranslation.getZ(), 0.5, "orange"));
        } else {
            result2.append(String.format("draw ID screw VECTOR {%f,%f,%f} {%f,%f,%f} WIDTH %f COLOR %s ;", axisMin.getX(), axisMin.getY(), axisMin.getZ(), this.screwTranslation.getX(), this.screwTranslation.getY(), this.screwTranslation.getZ(), 0.5, "orange"));
        }
        if (this.rotationPos != null) {
            result2.append(System.getProperty("line.separator"));
            result2.append(String.format("draw ID rotArc ARC {%f,%f,%f} {%f,%f,%f} {0,0,0} {0,%f,%d} SCALE 500 DIAMETER %f COLOR %s;", axisMin.getX(), axisMin.getY(), axisMin.getZ(), axisMax.getX(), axisMax.getY(), axisMax.getZ(), Math.toDegrees(this.theta), positiveScrew ? 0 : 1, 0.5, "yellow"));
        }
        return result2.toString();
    }

    public static double getAngle(AFPChain afpChain) throws StructureException {
        if (afpChain.getBlockNum() < 1) {
            throw new StructureException("No aligned residues");
        }
        Matrix rotation = afpChain.getBlockRotationMatrix()[0];
        if (rotation == null) {
            throw new NullPointerException("AFPChain does not contain a rotation matrix");
        }
        return RotationAxis.getAngle(rotation);
    }

    public static double getAngle(Matrix rotation) {
        double c = (rotation.trace() - 1.0) / 2.0;
        return Math.acos(c);
    }
}

