/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.ResidueNumber;
import org.biojava.bio.structure.io.mmcif.chem.ResidueType;

public class AtomPositionMap {
    private HashMap<ResidueNumber, Integer> hashMap = new HashMap();
    private TreeMap<ResidueNumber, Integer> treeMap;
    public static final Set<String> AMINO_ACID_NAMES = new TreeSet<String>();
    public static final GroupMatcher AMINO_ACID_MATCHER;
    public static final GroupMatcher ANYTHING_MATCHER;

    public AtomPositionMap(Atom[] atoms) {
        this(atoms, AMINO_ACID_MATCHER);
    }

    public AtomPositionMap(Atom[] atoms, GroupMatcher matcher) {
        for (int i = 0; i < atoms.length; ++i) {
            Group group = atoms[i].getGroup();
            ResidueNumber rn = group.getResidueNumber();
            if (!matcher.matches(group) || this.hashMap.containsKey(rn)) continue;
            this.hashMap.put(rn, i + 1);
        }
        ValueComparator<ResidueNumber, Integer> vc = new ValueComparator<ResidueNumber, Integer>(this.hashMap);
        this.treeMap = new TreeMap(vc);
        this.treeMap.putAll(this.hashMap);
    }

    public int calcLength(int positionA, int positionB, char startingChain) {
        return this.calcLength(positionA, positionB, String.valueOf(startingChain));
    }

    public int calcLength(int positionA, int positionB, String startingChain) {
        int positionEnd;
        int positionStart;
        if (positionA <= positionB) {
            positionStart = positionA;
            positionEnd = positionB;
        } else {
            positionStart = positionB;
            positionEnd = positionA;
        }
        return this.calcLengthDirectional(positionStart, positionEnd, startingChain);
    }

    public int calcLengthDirectional(ResidueNumber start, ResidueNumber end) {
        return this.calcLengthDirectional((int)this.getPosition(start), (int)this.getPosition(end), start.getChainId());
    }

    public int calcLengthDirectional(int positionStart, int positionEnd, char startingChain) {
        return this.calcLengthDirectional(positionStart, positionEnd, String.valueOf(startingChain));
    }

    public int calcLengthDirectional(int positionStart, int positionEnd, String startingChain) {
        int count2 = 0;
        for (Map.Entry<ResidueNumber, Integer> entry : this.treeMap.entrySet()) {
            if (!entry.getKey().getChainId().equals(startingChain)) continue;
            if (entry.getValue() == positionStart) {
                count2 = 0;
            }
            if (entry.getValue() == positionEnd) {
                return count2;
            }
            ++count2;
        }
        return -1;
    }

    public int calcLength(ResidueNumber positionA, ResidueNumber positionB) {
        int pA = this.hashMap.get(positionA);
        int pB = this.hashMap.get(positionB);
        String chain2 = positionA.getChainId();
        if (pA > pB) {
            chain2 = positionB.getChainId();
        }
        return this.calcLength(pA, pB, chain2);
    }

    public NavigableMap<ResidueNumber, Integer> getNavMap() {
        return this.treeMap;
    }

    public Integer getPosition(ResidueNumber residueNumber) {
        return this.hashMap.get(residueNumber);
    }

    public ResidueNumber getFirst(String chainId) {
        Map.Entry<ResidueNumber, Integer> entry = this.treeMap.firstEntry();
        do {
            if (!entry.getKey().getChainId().equals(chainId)) continue;
            return entry.getKey();
        } while ((entry = this.treeMap.higherEntry(entry.getKey())) != null);
        return null;
    }

    public ResidueNumber getLast(String chainId) {
        Map.Entry<ResidueNumber, Integer> entry = this.treeMap.lastEntry();
        do {
            if (!entry.getKey().getChainId().equals(chainId)) continue;
            return entry.getKey();
        } while ((entry = this.treeMap.lowerEntry(entry.getKey())) != null);
        return null;
    }

    public ResidueNumber getFirst() {
        return this.treeMap.firstKey();
    }

    public ResidueNumber getLast() {
        return this.treeMap.lastKey();
    }

    static {
        AMINO_ACID_NAMES.addAll(Arrays.asList("ALA", "ARG", "ASN", "ASP", "CYS", "GLU", "GLN", "GLY", "HIS", "ILE", "LEU", "LYS", "MET", "PHE", "PRO", "SER", "THR", "TRP", "TYR", "VAL"));
        AMINO_ACID_NAMES.addAll(Arrays.asList("ASX", "GLX", "XLE", "XAA"));
        AMINO_ACID_MATCHER = new GroupMatcher(){

            @Override
            public boolean matches(Group group) {
                ResidueType type = group.getChemComp().getResidueType();
                return group.hasAtom(" CA ") || AMINO_ACID_NAMES.contains(group.getPDBName()) || type == ResidueType.lPeptideLinking || type == ResidueType.glycine || type == ResidueType.lPeptideAminoTerminus || type == ResidueType.lPeptideCarboxyTerminus || type == ResidueType.dPeptideLinking || type == ResidueType.dPeptideAminoTerminus || type == ResidueType.dPeptideCarboxyTerminus;
            }
        };
        ANYTHING_MATCHER = new GroupMatcher(){

            @Override
            public boolean matches(Group group) {
                return true;
            }
        };
    }

    private static class ValueComparator<T, V extends Comparable<V>>
    implements Comparator<T> {
        private Map<T, V> map;

        public ValueComparator(Map<T, V> map2) {
            this.map = map2;
        }

        @Override
        public int compare(T o1, T o2) {
            return ((Comparable)this.map.get(o1)).compareTo(this.map.get(o2));
        }
    }

    public static interface GroupMatcher {
        public boolean matches(Group var1);
    }
}

