/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.LongDiskDataStorage;
import org.apfloat.internal.LongMemoryDataStorage;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;

public class LongDataStorageBuilder
implements DataStorageBuilder {
    public DataStorage createDataStorage(long size2) throws ApfloatRuntimeException {
        ApfloatContext ctx = ApfloatContext.getContext();
        if (size2 <= (long)ctx.getMemoryTreshold()) {
            return new LongMemoryDataStorage();
        }
        return new LongDiskDataStorage();
    }

    public DataStorage createCachedDataStorage(long size2) throws ApfloatRuntimeException {
        ApfloatContext ctx = ApfloatContext.getContext();
        if (size2 <= ctx.getMaxMemoryBlockSize()) {
            return new LongMemoryDataStorage();
        }
        return new LongDiskDataStorage();
    }

    public DataStorage createDataStorage(DataStorage dataStorage) throws ApfloatRuntimeException {
        ApfloatContext ctx;
        long size2;
        if (dataStorage instanceof LongMemoryDataStorage && (size2 = dataStorage.getSize()) > (long)(ctx = ApfloatContext.getContext()).getMemoryTreshold()) {
            LongDiskDataStorage tmp = new LongDiskDataStorage();
            tmp.copyFrom(dataStorage);
            dataStorage = tmp;
        }
        return dataStorage;
    }
}

