/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.IntModConstants;
import org.apfloat.internal.IntParallelFNTStrategy;
import org.apfloat.internal.IntSixStepFNTStrategy;
import org.apfloat.internal.ParallelRunnable;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.internal.TransformLengthExceededException;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.Util;

public class IntFactor3SixStepNTTStrategy
extends IntParallelFNTStrategy {
    private IntSixStepFNTStrategy factor2Strategy;

    public IntFactor3SixStepNTTStrategy(IntSixStepFNTStrategy factor2Strategy) {
        this.factor2Strategy = factor2Strategy;
    }

    public void setParallelRunner(ParallelRunner parallelRunner) {
        super.setParallelRunner(parallelRunner);
        this.factor2Strategy.setParallelRunner(parallelRunner);
    }

    public void transform(DataStorage dataStorage, int modulus) throws ApfloatRuntimeException {
        long length = dataStorage.getSize();
        if (length > 0x3000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + length + " > " + 0x3000000L);
        }
        if (length > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + length);
        }
        int power2length = (int)(length & -length);
        if (length == (long)power2length) {
            this.factor2Strategy.transform(dataStorage, modulus);
        } else {
            assert (length == (long)(3 * power2length));
            this.setModulus(IntModConstants.MODULUS[modulus]);
            int w = this.getForwardNthRoot(IntModConstants.PRIMITIVE_ROOT[modulus], length);
            int w3 = this.modPow(w, power2length);
            ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)length);
            ArrayAccess arrayAccess0 = arrayAccess.subsequence(0, power2length);
            ArrayAccess arrayAccess1 = arrayAccess.subsequence(power2length, power2length);
            ArrayAccess arrayAccess2 = arrayAccess.subsequence(2 * power2length, power2length);
            this.transformColumns(false, arrayAccess0, arrayAccess1, arrayAccess2, power2length, w, w3);
            this.factor2Strategy.transform(arrayAccess0, modulus);
            this.factor2Strategy.transform(arrayAccess1, modulus);
            this.factor2Strategy.transform(arrayAccess2, modulus);
            arrayAccess.close();
        }
    }

    public void inverseTransform(DataStorage dataStorage, int modulus, long totalTransformLength) throws ApfloatRuntimeException {
        long length = dataStorage.getSize();
        if (Math.max(length, totalTransformLength) > 0x3000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + Math.max(length, totalTransformLength) + " > " + 0x3000000L);
        }
        if (length > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + length);
        }
        int power2length = (int)(length & -length);
        if (length == (long)power2length) {
            this.factor2Strategy.inverseTransform(dataStorage, modulus, totalTransformLength);
        } else {
            assert (length == (long)(3 * power2length));
            this.setModulus(IntModConstants.MODULUS[modulus]);
            int w = this.getInverseNthRoot(IntModConstants.PRIMITIVE_ROOT[modulus], length);
            int w3 = this.modPow(w, power2length);
            ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)length);
            ArrayAccess arrayAccess0 = arrayAccess.subsequence(0, power2length);
            ArrayAccess arrayAccess1 = arrayAccess.subsequence(power2length, power2length);
            ArrayAccess arrayAccess2 = arrayAccess.subsequence(2 * power2length, power2length);
            this.factor2Strategy.inverseTransform(arrayAccess0, modulus, totalTransformLength);
            this.factor2Strategy.inverseTransform(arrayAccess1, modulus, totalTransformLength);
            this.factor2Strategy.inverseTransform(arrayAccess2, modulus, totalTransformLength);
            this.transformColumns(true, arrayAccess0, arrayAccess1, arrayAccess2, power2length, w, w3);
            arrayAccess.close();
        }
    }

    public long getTransformLength(long size2) {
        return Util.round23up(size2);
    }

    private void transformColumns(final boolean isInverse, final ArrayAccess arrayAccess0, final ArrayAccess arrayAccess1, final ArrayAccess arrayAccess2, final int size2, final int w, int w3) throws ApfloatRuntimeException {
        final int ww = this.modMultiply(w, w);
        final int w1 = this.negate(this.modDivide(3, 2));
        final int w2 = this.modAdd(w3, this.modDivide(1, 2));
        ParallelRunnable parallelRunnable = new ParallelRunnable(){

            public int getLength() {
                return size2;
            }

            public Runnable getRunnable(int strideStartColumn, int strideColumns) {
                return new ColumnTransformRunnable(isInverse, arrayAccess0, arrayAccess1, arrayAccess2, strideStartColumn, strideColumns, w, ww, w1, w2);
            }
        };
        this.parallelRunner.runParallel(parallelRunnable);
    }

    private class ColumnTransformRunnable
    implements Runnable {
        private boolean isInverse;
        private ArrayAccess arrayAccess0;
        private ArrayAccess arrayAccess1;
        private ArrayAccess arrayAccess2;
        private int startColumn;
        private int columns;
        private int w;
        private int ww;
        private int w1;
        private int w2;

        public ColumnTransformRunnable(boolean isInverse, ArrayAccess arrayAccess0, ArrayAccess arrayAccess1, ArrayAccess arrayAccess2, int startColumn, int columns, int w, int ww, int w1, int w2) {
            this.isInverse = isInverse;
            this.arrayAccess0 = arrayAccess0;
            this.arrayAccess1 = arrayAccess1;
            this.arrayAccess2 = arrayAccess2;
            this.startColumn = startColumn;
            this.columns = columns;
            this.w = w;
            this.ww = ww;
            this.w1 = w1;
            this.w2 = w2;
        }

        public void run() {
            int tmp1 = IntFactor3SixStepNTTStrategy.this.modPow(this.w, this.startColumn);
            int tmp2 = IntFactor3SixStepNTTStrategy.this.modPow(this.ww, this.startColumn);
            int[] data0 = this.arrayAccess0.getIntData();
            int[] data1 = this.arrayAccess1.getIntData();
            int[] data2 = this.arrayAccess2.getIntData();
            int offset0 = this.arrayAccess0.getOffset() + this.startColumn;
            int offset1 = this.arrayAccess1.getOffset() + this.startColumn;
            int offset2 = this.arrayAccess2.getOffset() + this.startColumn;
            for (int i = 0; i < this.columns; ++i) {
                int x0 = data0[offset0 + i];
                int x1 = data1[offset1 + i];
                int x2 = data2[offset2 + i];
                if (this.isInverse) {
                    x1 = IntFactor3SixStepNTTStrategy.this.modMultiply(x1, tmp1);
                    x2 = IntFactor3SixStepNTTStrategy.this.modMultiply(x2, tmp2);
                }
                int t2 = IntFactor3SixStepNTTStrategy.this.modAdd(x1, x2);
                x2 = IntFactor3SixStepNTTStrategy.this.modSubtract(x1, x2);
                x0 = IntFactor3SixStepNTTStrategy.this.modAdd(x0, t2);
                t2 = IntFactor3SixStepNTTStrategy.this.modMultiply(t2, this.w1);
                x2 = IntFactor3SixStepNTTStrategy.this.modMultiply(x2, this.w2);
                t2 = IntFactor3SixStepNTTStrategy.this.modAdd(t2, x0);
                x1 = IntFactor3SixStepNTTStrategy.this.modAdd(t2, x2);
                x2 = IntFactor3SixStepNTTStrategy.this.modSubtract(t2, x2);
                if (!this.isInverse) {
                    x1 = IntFactor3SixStepNTTStrategy.this.modMultiply(x1, tmp1);
                    x2 = IntFactor3SixStepNTTStrategy.this.modMultiply(x2, tmp2);
                }
                data0[offset0 + i] = x0;
                data1[offset1 + i] = x1;
                data2[offset2 + i] = x2;
                tmp1 = IntFactor3SixStepNTTStrategy.this.modMultiply(tmp1, this.w);
                tmp2 = IntFactor3SixStepNTTStrategy.this.modMultiply(tmp2, this.ww);
            }
        }
    }
}

