/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.internal.FloatFactor3NTTStrategy;
import org.apfloat.internal.FloatFactor3SixStepNTTStrategy;
import org.apfloat.internal.FloatModMath;
import org.apfloat.internal.FloatSixStepFNTStrategy;
import org.apfloat.internal.FloatTableFNTStrategy;
import org.apfloat.internal.FloatTwoPassFNTStrategy;
import org.apfloat.spi.NTTBuilder;
import org.apfloat.spi.NTTStrategy;
import org.apfloat.spi.Util;

public class FloatNTTBuilder
implements NTTBuilder {
    public NTTStrategy createNTT(long size2) {
        long power2size;
        ApfloatContext ctx = ApfloatContext.getContext();
        int cacheSize = ctx.getCacheL1Size() / 4;
        long maxMemoryBlockSize = ctx.getMaxMemoryBlockSize() / 4L;
        boolean useFactor3 = false;
        if ((size2 = Util.round23up(size2)) != (power2size = size2 & -size2)) {
            useFactor3 = true;
        }
        FloatModMath transform2 = power2size <= (long)(cacheSize / 2) ? new FloatTableFNTStrategy() : (power2size <= maxMemoryBlockSize && power2size <= Integer.MAX_VALUE ? new FloatSixStepFNTStrategy() : new FloatTwoPassFNTStrategy());
        if (useFactor3) {
            transform2 = size2 <= maxMemoryBlockSize && size2 <= Integer.MAX_VALUE && transform2 instanceof FloatSixStepFNTStrategy ? new FloatFactor3SixStepNTTStrategy((FloatSixStepFNTStrategy)transform2) : new FloatFactor3NTTStrategy((NTTStrategy)((Object)transform2));
        }
        return transform2;
    }
}

