/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.DiskDataStorage;
import org.apfloat.internal.DoubleMatrix;
import org.apfloat.internal.DoubleMemoryArrayAccess;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;

public class DoubleDiskDataStorage
extends DiskDataStorage {
    private static final long serialVersionUID = 342871486421108657L;

    public DoubleDiskDataStorage() throws ApfloatRuntimeException {
    }

    protected DoubleDiskDataStorage(DoubleDiskDataStorage doubleDiskDataStorage, long offset, long length) {
        super(doubleDiskDataStorage, offset, length);
    }

    protected DataStorage implSubsequence(long offset, long length) throws ApfloatRuntimeException {
        return new DoubleDiskDataStorage(this, offset + this.getOffset(), length);
    }

    protected ArrayAccess implGetArray(int mode, long offset, int length) throws ApfloatRuntimeException {
        return new DoubleDiskArrayAccess(mode, this.getOffset() + offset, length);
    }

    protected synchronized ArrayAccess implGetTransposedArray(int mode, int startColumn, int columns, int rows) throws ApfloatRuntimeException {
        TransposedMemoryArrayAccess arrayAccess;
        block8: {
            int width = (int)(this.getSize() / (long)rows);
            if (columns != (columns & -columns) || rows != (rows & -rows) || startColumn + columns > width) {
                throw new ApfloatInternalException("Invalid size");
            }
            int blockSize = columns * rows;
            int b = Math.min(columns, rows);
            arrayAccess = new TransposedMemoryArrayAccess(mode, new double[blockSize], startColumn, columns, rows);
            if ((mode & 1) == 0) break block8;
            if (columns < rows) {
                long readPosition = startColumn;
                for (int i = 0; i < rows; i += b) {
                    int writePosition = i;
                    for (int j = 0; j < b; ++j) {
                        this.readToArray(readPosition, arrayAccess, writePosition, b);
                        readPosition += (long)width;
                        writePosition += rows;
                    }
                    ArrayAccess subArrayAccess = ((ArrayAccess)arrayAccess).subsequence(i, blockSize - i);
                    DoubleMatrix.transposeSquare(subArrayAccess, b, rows);
                }
            } else {
                int i;
                for (i = 0; i < b; ++i) {
                    long readPosition = startColumn + i * width;
                    int writePosition = i * b;
                    for (int j = 0; j < columns; j += b) {
                        this.readToArray(readPosition, arrayAccess, writePosition, b);
                        readPosition += (long)b;
                        writePosition += b * b;
                    }
                }
                for (i = 0; i < blockSize; i += b * b) {
                    ArrayAccess subArrayAccess = ((ArrayAccess)arrayAccess).subsequence(i, blockSize - i);
                    DoubleMatrix.transposeSquare(subArrayAccess, b, b);
                }
            }
        }
        return arrayAccess;
    }

    private synchronized void setTransposedArray(ArrayAccess arrayAccess, int startColumn, int columns, int rows) throws ApfloatRuntimeException {
        int width = (int)(this.getSize() / (long)rows);
        int blockSize = arrayAccess.getLength();
        int b = Math.min(columns, rows);
        if (columns < rows) {
            long writePosition = startColumn;
            for (int i = 0; i < rows; i += b) {
                int readPosition = i;
                ArrayAccess subArrayAccess = arrayAccess.subsequence(i, blockSize - i);
                DoubleMatrix.transposeSquare(subArrayAccess, b, rows);
                for (int j = 0; j < b; ++j) {
                    this.writeFromArray(arrayAccess, readPosition, writePosition, b);
                    readPosition += rows;
                    writePosition += (long)width;
                }
            }
        } else {
            int i;
            for (i = 0; i < blockSize; i += b * b) {
                ArrayAccess subArrayAccess = arrayAccess.subsequence(i, blockSize - i);
                DoubleMatrix.transposeSquare(subArrayAccess, b, b);
            }
            for (i = 0; i < b; ++i) {
                long writePosition = startColumn + i * width;
                int readPosition = i * b;
                for (int j = 0; j < columns; j += b) {
                    this.writeFromArray(arrayAccess, readPosition, writePosition, b);
                    readPosition += b * b;
                    writePosition += (long)b;
                }
            }
        }
    }

    private void readToArray(long readPosition, ArrayAccess arrayAccess, int writePosition, int length) throws ApfloatRuntimeException {
        ArrayAccess readArrayAccess = this.getArray(1, readPosition, length);
        System.arraycopy(readArrayAccess.getData(), readArrayAccess.getOffset(), arrayAccess.getData(), arrayAccess.getOffset() + writePosition, length);
        readArrayAccess.close();
    }

    private void writeFromArray(ArrayAccess arrayAccess, int readPosition, long writePosition, int length) throws ApfloatRuntimeException {
        ArrayAccess writeArrayAccess = this.getArray(2, writePosition, length);
        System.arraycopy(arrayAccess.getData(), arrayAccess.getOffset() + readPosition, writeArrayAccess.getData(), writeArrayAccess.getOffset(), length);
        writeArrayAccess.close();
    }

    public DataStorage.Iterator iterator(int mode, long startPosition, long endPosition) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException {
        if ((mode & 3) == 0) {
            throw new IllegalArgumentException("Illegal mode: " + mode);
        }
        return new BlockIterator(mode, startPosition, endPosition);
    }

    protected int getUnitSize() {
        return 8;
    }

    private class BlockIterator
    extends DataStorage.AbstractIterator {
        private ArrayAccess arrayAccess;
        private double[] data;
        private int offset;
        private int remaining;

        public BlockIterator(int mode, long startPosition, long endPosition) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException {
            super(DoubleDiskDataStorage.this, mode, startPosition, endPosition);
            this.arrayAccess = null;
            this.remaining = 0;
        }

        public void next() throws IllegalStateException, ApfloatRuntimeException {
            this.checkLength();
            assert (this.remaining > 0);
            this.checkAvailable();
            this.offset += this.getIncrement();
            --this.remaining;
            if (this.remaining == 0) {
                this.close();
            }
            super.next();
        }

        public double getDouble() throws IllegalStateException, ApfloatRuntimeException {
            this.checkGet();
            this.checkAvailable();
            return this.data[this.offset];
        }

        public void setDouble(double value2) throws IllegalStateException, ApfloatRuntimeException {
            this.checkSet();
            this.checkAvailable();
            this.data[this.offset] = value2;
        }

        public void close() throws ApfloatRuntimeException {
            if (this.arrayAccess != null) {
                this.data = null;
                this.arrayAccess.close();
                this.arrayAccess = null;
            }
        }

        private void checkAvailable() throws ApfloatRuntimeException {
            if (this.arrayAccess == null) {
                boolean isForward = this.getIncrement() > 0;
                int length = (int)Math.min(this.getLength(), (long)(DiskDataStorage.getBlockSize() / 8));
                long offset = isForward ? this.getPosition() : this.getPosition() - (long)length + 1L;
                this.arrayAccess = DoubleDiskDataStorage.this.getArray(this.getMode(), offset, length);
                this.data = this.arrayAccess.getDoubleData();
                this.offset = this.arrayAccess.getOffset() + (isForward ? 0 : length - 1);
                this.remaining = length;
            }
        }
    }

    private class TransposedMemoryArrayAccess
    extends DoubleMemoryArrayAccess {
        private static final long serialVersionUID = -3746109883682965310L;
        private int mode;
        private int startColumn;
        private int columns;
        private int rows;

        public TransposedMemoryArrayAccess(int mode, double[] data2, int startColumn, int columns, int rows) {
            super(data2, 0, data2.length);
            this.mode = mode;
            this.startColumn = startColumn;
            this.columns = columns;
            this.rows = rows;
        }

        public void close() throws ApfloatRuntimeException {
            if ((this.mode & 2) != 0 && this.getData() != null) {
                DoubleDiskDataStorage.this.setTransposedArray(this, this.startColumn, this.columns, this.rows);
            }
            super.close();
        }
    }

    private class DoubleDiskArrayAccess
    extends DoubleMemoryArrayAccess {
        private static final long serialVersionUID = -7097317279839657081L;
        private int mode;
        private long fileOffset;

        public DoubleDiskArrayAccess(int mode, long fileOffset, int length) throws ApfloatRuntimeException {
            super(new double[length], 0, length);
            this.mode = mode;
            this.fileOffset = fileOffset;
            if ((mode & 1) != 0) {
                final double[] array = this.getDoubleData();
                WritableByteChannel out = new WritableByteChannel(){
                    private int readPosition = 0;

                    public int write(ByteBuffer buffer) {
                        DoubleBuffer src = buffer.asDoubleBuffer();
                        int readLength = src.remaining();
                        src.get(array, this.readPosition, readLength);
                        this.readPosition += readLength;
                        buffer.position(buffer.position() + readLength * 8);
                        return readLength * 8;
                    }

                    public void close() {
                    }

                    public boolean isOpen() {
                        return true;
                    }
                };
                DoubleDiskDataStorage.this.transferTo(out, fileOffset * 8L, (long)length * 8L);
            }
        }

        public void close() throws ApfloatRuntimeException {
            if ((this.mode & 2) != 0 && this.getData() != null) {
                final double[] array = this.getDoubleData();
                ReadableByteChannel in = new ReadableByteChannel(){
                    private int writePosition = 0;

                    public int read(ByteBuffer buffer) {
                        DoubleBuffer dst = buffer.asDoubleBuffer();
                        int writeLength = dst.remaining();
                        dst.put(array, this.writePosition, writeLength);
                        this.writePosition += writeLength;
                        buffer.position(buffer.position() + writeLength * 8);
                        return writeLength * 8;
                    }

                    public void close() {
                    }

                    public boolean isOpen() {
                        return true;
                    }
                };
                DoubleDiskDataStorage.this.transferFrom(in, this.fileOffset * 8L, (long)array.length * 8L);
            }
            super.close();
        }
    }
}

