/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.tabix;

import net.sf.samtools.tabix.TabixReader;

public class TabixInterval {
    int tid;
    int beg;
    int end;

    public TabixInterval(TabixReader tabixReader, String s) {
        int col = 0;
        int end = 0;
        int beg = 0;
        while ((end = s.indexOf(9, beg)) >= 0 || end == -1) {
            if (++col == tabixReader.getmSc()) {
                this.tid = tabixReader.chr2tid(s.substring(beg, end));
            } else if (col == tabixReader.getmBc()) {
                this.end = Integer.parseInt(s.substring(beg, end == -1 ? s.length() : end));
                this.beg = this.end++;
                if ((tabixReader.getmPreset() & 0x10000) == 0) {
                    --this.beg;
                }
                if (this.beg < 0) {
                    this.beg = 0;
                }
                if (this.end < 1) {
                    this.end = 1;
                }
            } else if ((tabixReader.getmPreset() & 0xFFFF) == 0) {
                if (col == tabixReader.getmEc()) {
                    this.end = Integer.parseInt(s.substring(beg, end));
                }
            } else if ((tabixReader.getmPreset() & 0xFFFF) == 1) {
                if (col == 6) {
                    int l = 0;
                    String cigar = s.substring(beg, end);
                    int j = 0;
                    for (int i = 0; i < cigar.length(); ++i) {
                        char op;
                        if (cigar.charAt(i) <= '9' || (op = cigar.charAt(i)) != 'M' && op != 'D' && op != 'N') continue;
                        l += Integer.parseInt(cigar.substring(j, i));
                    }
                    this.end = this.beg + l;
                }
            } else if ((tabixReader.getmPreset() & 0xFFFF) == 2) {
                String alt;
                String string2 = alt = end >= 0 ? s.substring(beg, end) : s.substring(beg);
                if (col == 4) {
                    if (alt.length() > 0) {
                        this.end = this.beg + alt.length();
                    }
                } else if (col == 8) {
                    int e_off = -1;
                    int i = alt.indexOf("END=");
                    if (i == 0) {
                        e_off = 4;
                    } else if (i > 0 && (i = alt.indexOf(";END=")) >= 0) {
                        e_off = i + 5;
                    }
                    if (e_off > 0) {
                        i = alt.indexOf(";", e_off);
                        this.end = Integer.parseInt(i > e_off ? alt.substring(e_off, i) : alt.substring(e_off));
                    }
                }
            }
            if (end == -1) break;
            beg = end + 1;
        }
    }

    public String toString() {
        return "tid: " + this.tid + ", start: " + this.beg + ", end: " + this.end;
    }
}

