/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.tabix;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.sf.samtools.tabix.TPair64;
import net.sf.samtools.tabix.TabixReader;
import org.snpeff.util.Gpr;

public class TabixIndex {
    public static final int TAD_LIDX_SHIFT = 14;
    boolean debug;
    private HashMap<Integer, TPair64[]> binningIndex = new HashMap();
    private long[] linearIndex;

    public static String binInfo(int binNumber) {
        int binLevel = (int)Math.floor(Math.log(7 * binNumber + 1) / (3.0 * Math.log(2.0)));
        int binSize = 1 << 29 - 3 * binLevel;
        int offsetLevel = ((1 << 3 * binLevel) - 1) / 7;
        int start = (binNumber - offsetLevel) * binSize;
        int end = (binNumber + 1 - offsetLevel) * binSize;
        return "bin: " + binNumber + ", level: " + binLevel + ", size: " + binSize + ", offset: " + offsetLevel + ", interval: [ " + start + " , " + end + " )";
    }

    public TPair64[] get(int binNum) {
        return this.binningIndex.get(binNum);
    }

    public long minOffset(int beg) {
        if (this.linearIndex.length > 0) {
            int begTad = beg >> 14;
            if (begTad >= this.linearIndex.length) {
                return this.linearIndex[this.linearIndex.length - 1];
            }
            return this.linearIndex[begTad];
        }
        return 0L;
    }

    public void put(int bin, TPair64[] chunks) {
        this.binningIndex.put(bin, chunks);
    }

    public void readIndex(InputStream is) throws IOException {
        int numBins = TabixReader.readInt(is);
        if (this.debug) {
            Gpr.debug("Number of bins: " + numBins);
        }
        for (int j = 0; j < numBins; ++j) {
            int binNumber = TabixReader.readInt(is);
            int numChunks = TabixReader.readInt(is);
            TPair64[] chunks = new TPair64[numChunks];
            if (this.debug) {
                Gpr.debug("\t" + TabixIndex.binInfo(binNumber) + "\tnumChunks: " + numChunks);
            }
            for (int chunNum = 0; chunNum < chunks.length; ++chunNum) {
                TPair64 tp = new TPair64();
                tp.readIndex(is);
                chunks[chunNum] = tp;
                if (!this.debug) continue;
                Gpr.debug("\t\tchunk[" + chunNum + "]: " + chunks[chunNum]);
            }
            this.put(binNumber, chunks);
        }
        int linearIndexLen = TabixReader.readInt(is);
        long[] linearIndex = new long[linearIndexLen];
        for (int tid = 0; tid < linearIndex.length; ++tid) {
            linearIndex[tid] = TabixReader.readLong(is);
            if (!this.debug) continue;
            Gpr.debug("\tlinearIndex[" + tid + "] :" + linearIndex[tid]);
        }
        this.setLinearIndex(linearIndex);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setLinearIndex(long[] linearIndex) {
        this.linearIndex = linearIndex;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<Integer> keys = new ArrayList<Integer>();
        keys.addAll(this.binningIndex.keySet());
        Collections.sort(keys);
        sb.append("Binning index size:" + this.binningIndex.size() + "\n");
        for (Integer binNum : keys) {
            TPair64[] chunks = this.binningIndex.get(binNum);
            sb.append("\t" + TabixIndex.binInfo(binNum) + "\n\tNumber of chunks:" + chunks.length + "\n");
            for (int i = 0; i < chunks.length; ++i) {
                sb.append("\t\tchunk " + i + "\t" + chunks[i] + "\n");
            }
        }
        sb.append("Linear index size: " + this.linearIndex.length + "\n");
        for (int i = 0; i < this.linearIndex.length; ++i) {
            sb.append("\t" + i + "\t" + this.linearIndex[i] + "\n");
        }
        return sb.toString();
    }
}

