/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMValidationError;
import net.sf.samtools.TextCigarCodec;

public class Cigar {
    private final List<CigarElement> cigarElements = new ArrayList<CigarElement>();

    public Cigar() {
    }

    public Cigar(List<CigarElement> cigarElements) {
        this.cigarElements.addAll(cigarElements);
    }

    public List<CigarElement> getCigarElements() {
        return Collections.unmodifiableList(this.cigarElements);
    }

    public CigarElement getCigarElement(int i) {
        return this.cigarElements.get(i);
    }

    public void add(CigarElement cigarElement) {
        this.cigarElements.add(cigarElement);
    }

    public int numCigarElements() {
        return this.cigarElements.size();
    }

    public boolean isEmpty() {
        return this.cigarElements.isEmpty();
    }

    public int getReferenceLength() {
        int length = 0;
        for (CigarElement element : this.cigarElements) {
            switch (element.getOperator()) {
                case M: 
                case D: 
                case N: 
                case EQ: 
                case X: {
                    length += element.getLength();
                }
            }
        }
        return length;
    }

    public int getPaddedReferenceLength() {
        int length = 0;
        for (CigarElement element : this.cigarElements) {
            switch (element.getOperator()) {
                case M: 
                case D: 
                case N: 
                case EQ: 
                case X: 
                case P: {
                    length += element.getLength();
                }
            }
        }
        return length;
    }

    public int getReadLength() {
        return Cigar.getReadLength(this.cigarElements);
    }

    public static int getReadLength(List<CigarElement> cigarElements) {
        int length = 0;
        for (CigarElement element : cigarElements) {
            if (!element.getOperator().consumesReadBases()) continue;
            length += element.getLength();
        }
        return length;
    }

    public List<SAMValidationError> isValid(String readName, long recordNumber) {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<SAMValidationError> ret = null;
        boolean seenRealOperator = false;
        for (int i = 0; i < this.cigarElements.size(); ++i) {
            CigarOperator op;
            CigarElement element = this.cigarElements.get(i);
            if (element.getLength() == 0) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "CIGAR element with zero length", readName, recordNumber));
            }
            if (Cigar.isClippingOperator(op = element.getOperator())) {
                if (op == CigarOperator.H) {
                    if (i == 0 || i == this.cigarElements.size() - 1) continue;
                    if (ret == null) {
                        ret = new ArrayList();
                    }
                    ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "Hard clipping operator not at start or end of CIGAR", readName, recordNumber));
                    continue;
                }
                if (op != CigarOperator.S) {
                    throw new IllegalStateException("Should never happen: " + op.name());
                }
                if (i == 0 || i == this.cigarElements.size() - 1) continue;
                if (i == 1) {
                    if (this.cigarElements.size() == 3 && this.cigarElements.get(2).getOperator() == CigarOperator.H || this.cigarElements.get(0).getOperator() == CigarOperator.H) continue;
                    if (ret == null) {
                        ret = new ArrayList();
                    }
                    ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "Soft clipping CIGAR operator can only be inside of hard clipping operator", readName, recordNumber));
                    continue;
                }
                if (i == this.cigarElements.size() - 2) {
                    if (this.cigarElements.get(this.cigarElements.size() - 1).getOperator() == CigarOperator.H) continue;
                    if (ret == null) {
                        ret = new ArrayList();
                    }
                    ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "Soft clipping CIGAR operator can only be inside of hard clipping operator", readName, recordNumber));
                    continue;
                }
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "Soft clipping CIGAR operator can at start or end of read, or be inside of hard clipping operator", readName, recordNumber));
                continue;
            }
            if (Cigar.isRealOperator(op)) {
                CigarOperator nextOperator;
                seenRealOperator = true;
                if (!Cigar.isInDelOperator(op)) continue;
                for (int j = i + 1; !(j >= this.cigarElements.size() || Cigar.isRealOperator(nextOperator = this.cigarElements.get(j).getOperator()) && !Cigar.isInDelOperator(nextOperator) || Cigar.isPaddingOperator(nextOperator)); ++j) {
                    if (!Cigar.isInDelOperator(nextOperator) || op != nextOperator) continue;
                    if (ret == null) {
                        ret = new ArrayList();
                    }
                    ret.add(new SAMValidationError(SAMValidationError.Type.ADJACENT_INDEL_IN_CIGAR, "No M or N operator between pair of " + op.name() + " operators in CIGAR", readName, recordNumber));
                }
                continue;
            }
            if (!Cigar.isPaddingOperator(op) || i == 0) continue;
            if (i == this.cigarElements.size() - 1) {
                if (ret == null) {
                    ret = new ArrayList();
                }
                ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "Padding operator not valid at end of CIGAR", readName, recordNumber));
                continue;
            }
            if (Cigar.isRealOperator(this.cigarElements.get(i - 1).getOperator()) && Cigar.isRealOperator(this.cigarElements.get(i + 1).getOperator())) continue;
            if (ret == null) {
                ret = new ArrayList();
            }
            ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "Padding operator not between real operators in CIGAR", readName, recordNumber));
        }
        if (!seenRealOperator) {
            if (ret == null) {
                ret = new ArrayList<SAMValidationError>();
            }
            ret.add(new SAMValidationError(SAMValidationError.Type.INVALID_CIGAR, "No real operator (M|I|D|N) in CIGAR", readName, recordNumber));
        }
        return ret;
    }

    private static boolean isRealOperator(CigarOperator op) {
        return op == CigarOperator.M || op == CigarOperator.EQ || op == CigarOperator.X || op == CigarOperator.I || op == CigarOperator.D || op == CigarOperator.N;
    }

    private static boolean isInDelOperator(CigarOperator op) {
        return op == CigarOperator.I || op == CigarOperator.D;
    }

    private static boolean isClippingOperator(CigarOperator op) {
        return op == CigarOperator.S || op == CigarOperator.H;
    }

    private static boolean isPaddingOperator(CigarOperator op) {
        return op == CigarOperator.P;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cigar)) {
            return false;
        }
        Cigar cigar = (Cigar)o;
        return !(this.cigarElements != null ? !((Object)this.cigarElements).equals(cigar.cigarElements) : cigar.cigarElements != null);
    }

    public int hashCode() {
        return this.cigarElements != null ? ((Object)this.cigarElements).hashCode() : 0;
    }

    public String toString() {
        return TextCigarCodec.getSingleton().encode(this);
    }
}

