/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.Parseable;
import java.io.File;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;

public final class ConfigFactory {
    private ConfigFactory() {
    }

    public static Config load(String string2) {
        return ConfigFactory.load(Thread.currentThread().getContextClassLoader(), string2);
    }

    public static Config load(ClassLoader classLoader, String string2) {
        return ConfigFactory.load(classLoader, string2, ConfigParseOptions.defaults(), ConfigResolveOptions.defaults());
    }

    public static Config load(String string2, ConfigParseOptions configParseOptions, ConfigResolveOptions configResolveOptions) {
        return ConfigFactory.load(Thread.currentThread().getContextClassLoader(), string2, configParseOptions, configResolveOptions);
    }

    public static Config load(ClassLoader classLoader, String string2, ConfigParseOptions configParseOptions, ConfigResolveOptions configResolveOptions) {
        Config config = ConfigFactory.parseResourcesAnySyntax(classLoader, string2, configParseOptions);
        return ConfigFactory.load(classLoader, config, configResolveOptions);
    }

    public static Config load(Config config) {
        return ConfigFactory.load(Thread.currentThread().getContextClassLoader(), config);
    }

    public static Config load(ClassLoader classLoader, Config config) {
        return ConfigFactory.load(classLoader, config, ConfigResolveOptions.defaults());
    }

    public static Config load(Config config, ConfigResolveOptions configResolveOptions) {
        return ConfigFactory.load(Thread.currentThread().getContextClassLoader(), config, configResolveOptions);
    }

    public static Config load(ClassLoader classLoader, Config config, ConfigResolveOptions configResolveOptions) {
        return ConfigFactory.defaultOverrides(classLoader).withFallback(config).withFallback(ConfigFactory.defaultReference(classLoader)).resolve(configResolveOptions);
    }

    private static Config loadDefaultConfig(ClassLoader classLoader) {
        String string2;
        String string3;
        int n = 0;
        String string4 = System.getProperty("config.resource");
        if (string4 != null) {
            ++n;
        }
        if ((string3 = System.getProperty("config.file")) != null) {
            ++n;
        }
        if ((string2 = System.getProperty("config.url")) != null) {
            ++n;
        }
        if (n == 0) {
            return ConfigFactory.load(classLoader, "application");
        }
        if (n > 1) {
            throw new ConfigException.Generic("You set more than one of config.file='" + string3 + "', config.url='" + string2 + "', config.resource='" + string4 + "'; don't know which one to use!");
        }
        if (string4 != null) {
            if (string4.startsWith("/")) {
                string4 = string4.substring(1);
            }
            return ConfigFactory.load(classLoader, ConfigFactory.parseResources(classLoader, string4));
        }
        if (string3 != null) {
            return ConfigFactory.load(classLoader, ConfigFactory.parseFile(new File(string3)));
        }
        try {
            return ConfigFactory.load(classLoader, ConfigFactory.parseURL(new URL(string2)));
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConfigException.Generic("Bad URL in config.url system property: '" + string2 + "': " + malformedURLException.getMessage(), malformedURLException);
        }
    }

    public static Config load() {
        return ConfigFactory.load(Thread.currentThread().getContextClassLoader());
    }

    public static Config load(ClassLoader classLoader) {
        return ConfigFactory.loadDefaultConfig(classLoader);
    }

    public static Config defaultReference() {
        return ConfigFactory.defaultReference(Thread.currentThread().getContextClassLoader());
    }

    public static Config defaultReference(ClassLoader classLoader) {
        return ConfigImpl.defaultReference(classLoader);
    }

    public static Config defaultOverrides() {
        return ConfigFactory.systemProperties();
    }

    public static Config defaultOverrides(ClassLoader classLoader) {
        return ConfigFactory.systemProperties();
    }

    public static Config empty() {
        return ConfigFactory.empty(null);
    }

    public static Config empty(String string2) {
        return ConfigImpl.emptyConfig(string2);
    }

    public static Config systemProperties() {
        return ConfigImpl.systemPropertiesAsConfig();
    }

    public static Config systemEnvironment() {
        return ConfigImpl.envVariablesAsConfig();
    }

    public static Config parseProperties(Properties properties, ConfigParseOptions configParseOptions) {
        return Parseable.newProperties(properties, configParseOptions).parse().toConfig();
    }

    public static Config parseProperties(Properties properties) {
        return ConfigFactory.parseProperties(properties, ConfigParseOptions.defaults());
    }

    public static Config parseReader(Reader reader, ConfigParseOptions configParseOptions) {
        return Parseable.newReader(reader, configParseOptions).parse().toConfig();
    }

    public static Config parseReader(Reader reader) {
        return ConfigFactory.parseReader(reader, ConfigParseOptions.defaults());
    }

    public static Config parseURL(URL uRL, ConfigParseOptions configParseOptions) {
        return Parseable.newURL(uRL, configParseOptions).parse().toConfig();
    }

    public static Config parseURL(URL uRL) {
        return ConfigFactory.parseURL(uRL, ConfigParseOptions.defaults());
    }

    public static Config parseFile(File file, ConfigParseOptions configParseOptions) {
        return Parseable.newFile(file, configParseOptions).parse().toConfig();
    }

    public static Config parseFile(File file) {
        return ConfigFactory.parseFile(file, ConfigParseOptions.defaults());
    }

    public static Config parseFileAnySyntax(File file, ConfigParseOptions configParseOptions) {
        return ConfigImpl.parseFileAnySyntax(file, configParseOptions).toConfig();
    }

    public static Config parseFileAnySyntax(File file) {
        return ConfigFactory.parseFileAnySyntax(file, ConfigParseOptions.defaults());
    }

    public static Config parseResources(Class<?> clazz, String string2, ConfigParseOptions configParseOptions) {
        return Parseable.newResources(clazz, string2, configParseOptions).parse().toConfig();
    }

    public static Config parseResources(Class<?> clazz, String string2) {
        return ConfigFactory.parseResources(clazz, string2, ConfigParseOptions.defaults());
    }

    public static Config parseResourcesAnySyntax(Class<?> clazz, String string2, ConfigParseOptions configParseOptions) {
        return ConfigImpl.parseResourcesAnySyntax(clazz, string2, configParseOptions).toConfig();
    }

    public static Config parseResourcesAnySyntax(Class<?> clazz, String string2) {
        return ConfigFactory.parseResourcesAnySyntax(clazz, string2, ConfigParseOptions.defaults());
    }

    public static Config parseResources(ClassLoader classLoader, String string2, ConfigParseOptions configParseOptions) {
        return Parseable.newResources(classLoader, string2, configParseOptions).parse().toConfig();
    }

    public static Config parseResources(ClassLoader classLoader, String string2) {
        return ConfigFactory.parseResources(classLoader, string2, ConfigParseOptions.defaults());
    }

    public static Config parseResourcesAnySyntax(ClassLoader classLoader, String string2, ConfigParseOptions configParseOptions) {
        return ConfigImpl.parseResourcesAnySyntax(classLoader, string2, configParseOptions).toConfig();
    }

    public static Config parseResourcesAnySyntax(ClassLoader classLoader, String string2) {
        return ConfigFactory.parseResourcesAnySyntax(classLoader, string2, ConfigParseOptions.defaults());
    }

    public static Config parseResources(String string2, ConfigParseOptions configParseOptions) {
        return Parseable.newResources(Thread.currentThread().getContextClassLoader(), string2, configParseOptions).parse().toConfig();
    }

    public static Config parseResources(String string2) {
        return ConfigFactory.parseResources(Thread.currentThread().getContextClassLoader(), string2, ConfigParseOptions.defaults());
    }

    public static Config parseResourcesAnySyntax(String string2, ConfigParseOptions configParseOptions) {
        return ConfigImpl.parseResourcesAnySyntax(Thread.currentThread().getContextClassLoader(), string2, configParseOptions).toConfig();
    }

    public static Config parseResourcesAnySyntax(String string2) {
        return ConfigFactory.parseResourcesAnySyntax(Thread.currentThread().getContextClassLoader(), string2, ConfigParseOptions.defaults());
    }

    public static Config parseString(String string2, ConfigParseOptions configParseOptions) {
        return Parseable.newString(string2, configParseOptions).parse().toConfig();
    }

    public static Config parseString(String string2) {
        return ConfigFactory.parseString(string2, ConfigParseOptions.defaults());
    }

    public static Config parseMap(Map<String, ? extends Object> map2, String string2) {
        return ConfigImpl.fromPathMap(map2, string2).toConfig();
    }

    public static Config parseMap(Map<String, ? extends Object> map2) {
        return ConfigFactory.parseMap(map2, null);
    }
}

