/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sequence.editor;

import com.informagen.F;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

class StatusBar
extends JPanel {
    private int mType;
    private final JLabel mLocationLabel = new JLabel("", 2);
    private final JLabel mSizeLabel = new JLabel("", 4);
    private int size = 0;

    StatusBar() {
        this.setLayout(new GridLayout(1, 3));
        this.setFont(new Font("Courier", 0, 12));
        this.add(this.mLocationLabel);
        this.add(this.mSizeLabel);
        this.setNucleic();
        this.setCaretPosition(0);
        this.setLength(0);
    }

    void setCaretPosition(int n) {
        String string = new String(" Position: " + (n + 1));
        this.mLocationLabel.setText(string);
    }

    void setSelection(int n, int n2) {
        if (n != n2) {
            String string = new String("Selection: " + (n + 1) + "-" + n2);
            this.mLocationLabel.setText(string);
            this.updateSizeLabel(n2 - n);
        } else {
            this.setCaretPosition(n);
            this.updateSizeLabel(this.size);
        }
    }

    void setLength(int n) {
        this.size = n;
        this.updateSizeLabel(n);
    }

    void setSequencetype(int n) {
        this.mType = n;
    }

    public void setNucleic() {
        this.mType = 2;
    }

    public void setProtein() {
        this.mType = 1;
    }

    private void updateSizeLabel(int n) {
        String string = new String(Integer.toString(n));
        switch (this.mType) {
            case 2: 
            case 3: {
                if (n >= 10000) {
                    double d = (double)n / 1000.0;
                    string = new String(F.f(d, 6, 3));
                }
                string = string + (n > 10000 ? " Kb" : " bp");
                break;
            }
            case 1: {
                string = string + " aa";
            }
        }
        this.mSizeLabel.setText(string);
    }
}

