/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.format;

import com.informagen.sa.format.SequenceFormatter;
import org.apache.commons.lang.StringUtils;

public class FASTA
extends SequenceFormatter {
    public FASTA() {
        this.mBlockSize = 50;
        this.mLineSize = 50;
    }

    protected StringBuffer allocate() {
        int n = this.mSequence.length();
        return new StringBuffer(n + n / 60 + n / 10 + 60);
    }

    protected void formatHeader() {
        this.mFormatted.append('>');
        this.mCodeword = this.mCodeword != null ? this.mCodeword : "UNTITLED";
        this.mCodeword = StringUtils.substringBefore(this.mCodeword, "(");
        this.mCodeword = this.mCodeword.trim();
        this.mCodeword = this.mCodeword.replace(' ', '_');
        this.mFormatted.append(this.mCodeword);
        this.mFormatted.append(' ').append(this.mTitle);
        this.mFormatted.append('\n');
    }

    protected void formatSequence() {
        char[] cArray = this.mSequence.toCharArray();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            this.mFormatted.append(cArray[i]);
            ++n;
            if (++n2 == this.mBlockSize) {
                n2 = 0;
            }
            if (n != this.mLineSize) continue;
            this.mFormatted.append("\n");
            n = 0;
            n2 = 0;
        }
    }

    protected void formatEnding() {
        this.mFormatted.append("*\n");
    }
}

