/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.digest;

import com.informagen.F;
import com.informagen.sa.digest.Digest;
import com.informagen.sa.digest.DigestReportPanel;
import com.informagen.sa.digest.EnzymeCuts;
import java.util.Collections;
import java.util.Vector;

public class NonCuttersPanel
extends DigestReportPanel {
    private static final int COL1 = 15;
    private static final int COL2 = 20;
    private static final int COLS = 3;
    private static final String COLSPACE = " ";

    public NonCuttersPanel() {
        super("Non-Cutters");
    }

    public void digestChanged(Digest digest) {
        int n;
        this.writeHeader(digest);
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < 3; ++n) {
            stringBuffer.append(F.f("Enzyme", 15, (short)2)).append(F.f("Site", 20, (short)2)).append(COLSPACE);
        }
        stringBuffer.append("\n");
        for (n = 0; n < 3; ++n) {
            stringBuffer.append(F.f("-", 14, (short)16)).append(COLSPACE).append(F.f("-", 20, (short)16)).append(COLSPACE);
        }
        stringBuffer.append("\n");
        Vector vector = digest.getNonCutters();
        Collections.sort(vector, EnzymeCuts.getComparator());
        int n2 = vector.size();
        int n3 = (int)Math.ceil((double)n2 / 3.0);
        if (n2 > 0) {
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int n4 = j * n3 + i;
                    if (n4 >= n2) continue;
                    EnzymeCuts enzymeCuts = (EnzymeCuts)vector.elementAt(n4);
                    String string = enzymeCuts.getEnzymeName();
                    string = string.startsWith("*") ? string : COLSPACE + string;
                    stringBuffer.append(F.f(string, 15, (short)2));
                    stringBuffer.append(F.f(enzymeCuts.getEnzymeSite(), 20, (short)2));
                    stringBuffer.append(COLSPACE);
                }
                stringBuffer.append("\n");
            }
        }
        this.textArea.append(stringBuffer.toString());
    }
}

