/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.digest;

import com.informagen.Sequence;
import com.informagen.Util;
import com.informagen.sa.AnalysisPanel;
import com.informagen.sa.SAObject;
import com.informagen.sa.digest.AllCuttersPanel;
import com.informagen.sa.digest.Digest;
import com.informagen.sa.digest.DigestAnalysisPanel;
import com.informagen.sa.digest.EnzymeSelectionPanel;
import com.informagen.sa.digest.FragmentsPanel;
import com.informagen.sa.digest.GraphicDigestPanel;
import com.informagen.sa.digest.NonCuttersPanel;
import com.informagen.sa.digest.RestrictionMapPanel;
import com.informagen.sa.digest.SiteUsagePanel;
import com.informagen.sa.digest.UniqueCuttersPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DigestPanel
extends AnalysisPanel {
    final JTabbedPane tabbedPane = new JTabbedPane(1);
    private RestrictionMapPanel mapCard;
    private GraphicDigestPanel graphicCard;
    private AllCuttersPanel allSitesCard;
    private UniqueCuttersPanel uniqueSitesCard;
    private NonCuttersPanel absentSitesCard;
    private SiteUsagePanel siteUsageCard;
    private EnzymeSelectionPanel enzymesSelectionPanel;
    private FragmentsPanel fragmentsPanel;
    boolean enzymeSelectionChanged = false;
    Digest digest;
    private boolean threadIsRunning = false;
    DigestAnalysisPanel currentAnalysisPanel = null;

    public static String getAnalysisName() {
        return "Digest";
    }

    public DigestPanel() {
        this.buildUI();
        this.wireUI();
        this.tabbedPane.setSelectedIndex(6);
    }

    public boolean ignorePropertyChangeEvents() {
        return true;
    }

    public void changeSequence(SAObject sAObject, int[] nArray) {
        this.saObject = sAObject;
        this.sequence = sAObject.getSequence();
        this.selection = nArray;
        this.enzymesSelectionPanel.sequenceChanged();
        this.doDigest();
    }

    public void sequenceUnavailable() {
    }

    public void sequenceChanged(SAObject sAObject) {
        this.saObject = sAObject;
        this.sequence = sAObject.getSequence();
        this.enzymesSelectionPanel.sequenceChanged();
        this.doDigest();
    }

    public void selectionChanged(int[] nArray) {
        this.selection = nArray;
        if (this.enzymesSelectionPanel.selectionChanged()) {
            this.doDigest();
        } else {
            this.currentAnalysisPanel.selectionChanged(nArray);
        }
    }

    public void selectionCancelled() {
        this.selectionChanged(null);
    }

    public void cursorPositionChanged(int n) {
    }

    public void printPanel() {
        this.currentAnalysisPanel.printPanel();
    }

    public void savePanel() {
        this.currentAnalysisPanel.savePanel();
    }

    void enzymeSelectionChanged() {
        this.doDigest();
    }

    void buildUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildParameterCards(), "Center");
    }

    void wireUI() {
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DigestPanel.this.activatePanel(DigestPanel.this.tabbedPane.getSelectedComponent());
            }
        });
    }

    JPanel buildParameterCards() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String[] stringArray = new String[]{"Map", "Fragments", "All Sites", "Unique Sites", "Absent Sites", "Site Usage", "Enzymes"};
        Util.buildConstraints(gridBagConstraints, 0, 0, 0, 0, 1.0, 1.0, 10, 1);
        jPanel.add((Component)this.tabbedPane, gridBagConstraints);
        int n = 0;
        this.tabbedPane.addTab(stringArray[n++], this.createMapCard());
        this.tabbedPane.addTab(stringArray[n++], this.createFragmentsCard());
        this.tabbedPane.addTab(stringArray[n++], this.createAllSitesCard());
        this.tabbedPane.addTab(stringArray[n++], this.createUniqueSitesCard());
        this.tabbedPane.addTab(stringArray[n++], this.createAbsentSitesCard());
        this.tabbedPane.addTab(stringArray[n++], this.createSiteUsageCard());
        this.tabbedPane.addTab(stringArray[n++], this.createEnzymesCard());
        int n2 = 0;
        this.tabbedPane.setEnabledAt(n2++, true);
        this.tabbedPane.setEnabledAt(n2++, true);
        this.tabbedPane.setEnabledAt(n2++, true);
        this.tabbedPane.setEnabledAt(n2++, true);
        this.tabbedPane.setEnabledAt(n2++, true);
        this.tabbedPane.setEnabledAt(n2++, true);
        this.tabbedPane.setEnabledAt(n2++, true);
        return jPanel;
    }

    private JPanel createMapCard() {
        this.mapCard = new RestrictionMapPanel();
        return this.mapCard;
    }

    private JPanel createGraphicCard() {
        this.graphicCard = new GraphicDigestPanel();
        return this.graphicCard;
    }

    private JPanel createAllSitesCard() {
        this.allSitesCard = new AllCuttersPanel();
        return this.allSitesCard;
    }

    private JPanel createFragmentsCard() {
        this.fragmentsPanel = new FragmentsPanel();
        return this.fragmentsPanel;
    }

    private JPanel createUniqueSitesCard() {
        this.uniqueSitesCard = new UniqueCuttersPanel();
        return this.uniqueSitesCard;
    }

    private JPanel createAbsentSitesCard() {
        this.absentSitesCard = new NonCuttersPanel();
        return this.absentSitesCard;
    }

    private JPanel createSiteUsageCard() {
        this.siteUsageCard = new SiteUsagePanel();
        return this.siteUsageCard;
    }

    private JPanel createEnzymesCard() {
        this.enzymesSelectionPanel = new EnzymeSelectionPanel(this);
        return this.enzymesSelectionPanel;
    }

    void activatePanel(Component component) {
        if (component instanceof DigestAnalysisPanel) {
            this.currentAnalysisPanel = (DigestAnalysisPanel)((Object)component);
            if (this.digest != null) {
                this.currentAnalysisPanel.digestChanged(this.digest);
                this.currentAnalysisPanel.selectionChanged(this.selection);
            }
        }
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public int[] getSelection() {
        return this.selection;
    }

    public void doDigest() {
        if (this.threadIsRunning) {
            return;
        }
        if (this.sequence == null) {
            return;
        }
        if (this.sequence.isProtein()) {
            return;
        }
        this.digest = new Digest(this.sequence, this.enzymesSelectionPanel.getSelectedEnzymes());
        this.digest.doDigest();
        if (this.currentAnalysisPanel != null) {
            this.currentAnalysisPanel.digestChanged(this.digest);
            this.currentAnalysisPanel.selectionChanged(this.selection);
        }
    }
}

