/*
 * Decompiled with CFR 0.152.
 */
package com.informagen;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.text.JTextComponent;

public class Util {
    private static int nthWindow = 0;
    private static final int margin = 30;

    public static boolean isMacintosh() {
        return System.getProperty("os.name").equals("Mac OS");
    }

    public static boolean isMacOSX() {
        return System.getProperty("os.name").equals("Mac OS X");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static void requiresJVM(String string) throws Exception {
        String string2 = System.getProperty("java.version");
        if (string2.compareTo(string) < 0) {
            throw new Exception("This application requires JVM " + string + " or higher. JVM " + string2 + " was found.");
        }
    }

    public static Frame thisFrame(Container container) {
        Container container2 = container;
        while (container2.getParent() != null) {
            container2 = container2.getParent();
        }
        return (Frame)container2;
    }

    public static Point centerIt(Component component, Component component2) {
        Dimension dimension = component.getSize();
        Dimension dimension2 = component2.getSize();
        Point point = component.getLocationOnScreen();
        Point point2 = new Point(0, 0);
        point2.x = (dimension.width - dimension2.width) / 2 + point.x;
        point2.y = (dimension.height - dimension2.height) / 2 + point.y;
        return point2;
    }

    public static Point centerIt(Component component) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = component.getSize();
        Point point = new Point(0, 0);
        point.x = (dimension.width - dimension2.width) / 2;
        point.y = dimension.height / 2 - dimension2.height / 2;
        return point;
    }

    public static void waitForImage(Component component, Image image) {
        MediaTracker mediaTracker = new MediaTracker(component);
        try {
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static void wallPaper(Component component, Graphics graphics, Image image) {
        Dimension dimension = component.getSize();
        Util.waitForImage(component, image);
        int n = image.getWidth(component);
        int n2 = image.getHeight(component);
        for (int i = 0; i < dimension.width; i += n) {
            for (int j = 0; j < dimension.height; j += n2) {
                graphics.drawImage(image, i, j, component);
            }
        }
    }

    public static Point dialogPosition(Component component) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = component.getSize();
        Point point = new Point(0, 0);
        point.x = (dimension.width - dimension2.width) / 2;
        point.y = dimension.height / 3 - dimension2.height / 2;
        point.y = point.y > 0 ? point.y : 20;
        return point;
    }

    public static Point dialogPosition(Component component, Component component2) {
        Dimension dimension = component.getSize();
        Dimension dimension2 = component2.getSize();
        Point point = component.getLocationOnScreen();
        Point point2 = new Point(0, 0);
        point2.x = (dimension.width - dimension2.width) / 2 + point.x;
        point2.y = (dimension.height - dimension2.height) / 3 + point.y;
        return point2;
    }

    public static void windowDecorator(Window window, int n, int n2) {
        int n3 = nthWindow * 20 + 30;
        int n4 = nthWindow * 20 + 30;
        Dimension dimension = window.getToolkit().getScreenSize();
        dimension.width -= n3 + 30;
        dimension.height -= n4 + 30;
        if (n > 0 && n < dimension.width) {
            dimension.width = n;
        }
        if (n2 > 0 && n2 < dimension.height) {
            dimension.height = n2;
        }
        Point point = new Point(n3, n4);
        window.setLocation(point);
        window.setSize(dimension);
        nthWindow = nthWindow < 5 ? nthWindow + 1 : 0;
    }

    public static void windowDecorator(Window window, int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        Dimension dimension = window.getToolkit().getScreenSize();
        dimension.width -= 60;
        dimension.height -= 60;
        if (n5 > dimension.width || n5 < 0) {
            n5 = nthWindow * 20 + 30;
        }
        if (n6 > dimension.height || n6 < 0) {
            n6 = nthWindow * 20 + 30;
        }
        n7 = n3 < dimension.width ? n3 : dimension.width;
        n8 = n4 < dimension.height ? n4 : dimension.height;
        window.setLocation(n5, n6);
        window.setSize(n7, n8);
    }

    public static void clampWindow(Window window) {
        window.pack();
        Dimension dimension = window.getToolkit().getScreenSize();
        dimension.width -= 60;
        dimension.height -= 60;
        Dimension dimension2 = window.getSize();
        if (dimension2.width < dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height < dimension.height) {
            dimension.height = dimension2.height;
        }
        window.setSize(dimension);
        window.setLocation(Util.centerIt(window));
    }

    public static Dimension maxSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = new Dimension();
        dimension2.width = (int)((double)dimension.width * 0.9);
        dimension2.height = (int)((double)dimension.height * 0.9);
        return dimension2;
    }

    public static String findAndReplace(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            throw new NullPointerException("Util.findAndReplace doesn't work on nulls.");
        }
        String string4 = "";
        int n = string2.length();
        if (n == 0) {
            return string;
        }
        int n2 = string.indexOf(string2);
        while (n2 != -1) {
            string4 = string4 + string.substring(0, n2);
            string4 = string4 + string3;
            string = string.substring(n2 + n);
            n2 = string.indexOf(string2);
        }
        string4 = string4 + string;
        return string4;
    }

    public static void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.fill = n6;
    }

    public static boolean atUNH() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            byte[] byArray = inetAddress.getAddress();
            if ((byArray[0] & 0xFF) == 192 && (byArray[1] & 0xFF) == 168) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    public static boolean atHGS() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            byte[] byArray = inetAddress.getAddress();
            if ((byArray[0] & 0xFF) == 10) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    public static void autoSpellCheck(JTextComponent jTextComponent) {
        try {
            Class<?> clazz = Class.forName("com.apple.spell.ui.JTextComponentDriver");
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("startRealtimeChecking", JTextComponent.class);
            method.invoke(obj, jTextComponent);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

