/*
 * Decompiled with CFR 0.152.
 */
package com.informagen;

import java.util.Hashtable;

public class Sequence
implements Cloneable {
    private static final String IUPAC = "ABCDEFGHIJKLMNOPQRSTUVWXYZ-";
    private static final String IUPAC_PROTEIN = "ACDEFGHIKLMNPQRSTVWY";
    private static final String IUPAC_PROTEIN_DEGENERATE = "ACDEFGHIKLMNPQRSTVWY-BZX";
    private static final String IUPAC_DNA = "ATCGN";
    private static final String IUPAC_DNA_DEGENERATE = "ATCG-RYBDHVKMSWN";
    private static final String IUPAC_RNA = "AUCGN";
    private static final String IUPAC_RNA_DEGENERATE = "AUCG-RYWSKMBDHVN";
    static Hashtable naWeights = null;
    static Hashtable aaWeights = null;
    public static Hashtable pec = null;
    private static final int UNDEFINED = 0;
    public static final int PROT = 1;
    public static final int PROTEIN = 1;
    public static final int PEPTIDE = 1;
    public static final int DNA = 2;
    public static final int RNA = 3;
    public static final int PUREDNA = 4;
    public static final int PURERNA = 5;
    private static final int SIMPLE = 1;
    private static final int COMPLEX = 2;
    private String mUID = null;
    private String mTitle = null;
    private String mSequence = null;
    private int mType = 0;
    private String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ-";
    private boolean allowDegenerate = false;
    private boolean allowUnknown = true;
    private boolean allowGaps = false;

    public Sequence() {
    }

    public Sequence(String string) {
        this(string, IUPAC);
    }

    public Sequence(String string, String string2) {
        this.setSequence(string, string2);
        if (this.mType == 0) {
            this.mType = Sequence.guessType(this.mSequence);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Sequence createClone() {
        Sequence sequence = null;
        try {
            sequence = (Sequence)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return sequence;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getDescription());
        stringBuffer.append(" ").append(this.getLength()).append(this.isProtein() ? " aa" : " na");
        stringBuffer.append(" Title: ").append(this.getTitle());
        return stringBuffer.toString();
    }

    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mUID != null && !this.mUID.equals("")) {
            stringBuffer.append("UID: ").append(this.mUID).append("  Type: ");
        }
        switch (this.mType) {
            case 1: {
                stringBuffer.append("Protein");
                break;
            }
            case 2: {
                stringBuffer.append("DNA");
                break;
            }
            case 3: {
                stringBuffer.append("RNA");
                break;
            }
            default: {
                stringBuffer.append("UNDEFINED");
            }
        }
        stringBuffer.append(" ").append(this.getLength()).append(this.isProtein() ? " aa" : " bp");
        return stringBuffer.toString();
    }

    public void setSequence(String string) {
        this.alphabet = this.isProtein() ? (this.allowsDegenerate() ? IUPAC_PROTEIN_DEGENERATE : IUPAC_PROTEIN) : (this.isDNA() ? (this.allowsDegenerate() ? IUPAC_DNA_DEGENERATE : IUPAC_DNA) : (this.isRNA() ? (this.allowsDegenerate() ? IUPAC_RNA_DEGENERATE : IUPAC_RNA) : IUPAC));
        this.setSequence(string, this.alphabet);
    }

    public void setSequence(String string, String string2) {
        if (string != null) {
            char[] cArray = string.toUpperCase().toCharArray();
            string2 = string2.toUpperCase();
            StringBuffer stringBuffer = new StringBuffer(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                if (string2.indexOf(cArray[i]) == -1) continue;
                stringBuffer.append(string.charAt(i));
            }
            this.mSequence = new String(stringBuffer);
            if (this.mType == 0) {
                this.mType = Sequence.guessType(this.mSequence);
            }
        }
    }

    public String getSequence() {
        return this.mSequence;
    }

    public void setType(int n) {
        this.mType = n;
    }

    public int getType() {
        return this.mType;
    }

    public boolean isProtein() {
        return this.mType == 1;
    }

    public boolean isDNA() {
        return this.mType == 2;
    }

    public boolean isRNA() {
        return this.mType == 3;
    }

    public boolean isNucleic() {
        return this.isDNA() | this.isRNA();
    }

    public void setProtein() {
        this.mType = 1;
    }

    public void setDNA() {
        this.mType = 2;
    }

    public void setRNA() {
        this.mType = 3;
    }

    public boolean allowsDegenerate() {
        return this.allowDegenerate;
    }

    public void allowDegenerate(boolean bl) {
        this.allowDegenerate = bl;
    }

    public String getAlphabet() {
        return this.alphabet;
    }

    public void setUID(String string) {
        this.mUID = string;
    }

    public String getUID() {
        return this.mUID;
    }

    public void setTitle(String string) {
        this.mTitle = string;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public int getLength() {
        return this.mSequence == null ? 0 : this.mSequence.length();
    }

    public int checkSum() {
        return Sequence.checkSum(this.mSequence);
    }

    public void DNAtoRNA() {
        if (!this.isDNA()) {
            return;
        }
        this.mSequence = Sequence.DNAtoRNA(this.mSequence);
        this.mType = 3;
    }

    public void RNAtoDNA() {
        if (!this.isRNA()) {
            return;
        }
        this.mSequence = Sequence.RNAtoDNA(this.mSequence);
        this.mType = 2;
    }

    public void nucToProtein() {
        this.nucToProtein(false);
    }

    public void nucToProtein(boolean bl) {
        if (!this.isNucleic()) {
            return;
        }
        this.mSequence = Sequence.nucToProtein(this.mSequence);
        this.mType = 1;
    }

    public void revComp() {
        if (!this.isNucleic()) {
            return;
        }
        this.mSequence = Sequence.revComp(this.mSequence);
    }

    public void reverse() {
        StringBuffer stringBuffer = new StringBuffer(this.mSequence);
        stringBuffer.reverse();
        this.mSequence = stringBuffer.toString();
    }

    public double molwt() {
        double d = 0.0;
        if (this.mSequence == null || this.mSequence.length() == 0) {
            return d;
        }
        Hashtable hashtable = null;
        if (this.isProtein()) {
            if (aaWeights == null) {
                Sequence.loadAAweights();
            }
            hashtable = aaWeights;
        } else if (this.isNucleic()) {
            if (naWeights == null) {
                Sequence.loadNAweights();
            }
            hashtable = naWeights;
        } else {
            return d;
        }
        int n = this.mSequence.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Character c = new Character(Character.toUpperCase(this.mSequence.charAt(i)));
            Double d2 = (Double)hashtable.get(c);
            if (d2 == null) continue;
            ++n2;
            d += d2.doubleValue();
        }
        d = this.isProtein() ? (d -= (double)(n2 - 1) * 18.015) : (d += (double)(n2 - 1) * 61.0);
        return d;
    }

    public double gcPercent() {
        double d = 0.0;
        if (this.isProtein() || this.mSequence == null) {
            return d;
        }
        int n = this.mSequence.length();
        if (n == 0) {
            return d;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block5: for (int i = 0; i < n; ++i) {
            ++n4;
            switch (this.mSequence.charAt(i)) {
                case 'C': 
                case 'c': {
                    ++n2;
                    continue block5;
                }
                case 'G': 
                case 'g': {
                    ++n3;
                    continue block5;
                }
                case '-': {
                    --n4;
                }
            }
        }
        d = (double)(n2 + n3) / (double)n4 * 100.0;
        return d;
    }

    public double simpleTm() {
        double d = 0.0;
        if (this.isProtein() || this.mSequence == null) {
            return d;
        }
        int n = this.mSequence.length();
        if (n == 0) {
            return d;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        int n6 = 0;
        int n7 = 0;
        block8: for (int i = 0; i < n; ++i) {
            ++n7;
            switch (this.mSequence.charAt(i)) {
                case 'A': 
                case 'a': {
                    ++n2;
                    continue block8;
                }
                case 'C': 
                case 'c': {
                    ++n3;
                    continue block8;
                }
                case 'G': 
                case 'g': {
                    ++n4;
                    continue block8;
                }
                case 'T': 
                case 'U': 
                case 't': 
                case 'u': {
                    ++n5;
                    continue block8;
                }
                case 'N': 
                case 'n': {
                    ++n6;
                    continue block8;
                }
                case '-': {
                    --n7;
                }
            }
        }
        d = 2.0 * (double)(n2 + n5) + 4.0 * (double)(n3 + n4) + 3.0 * (double)n6;
        return d;
    }

    public double simpleConc() {
        double d = 0.0;
        if (!this.isDNA() || this.mSequence == null) {
            return d;
        }
        int n = this.mSequence.length();
        if (n == 0) {
            return d;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        block8: for (int i = 0; i < n; ++i) {
            ++n7;
            switch (this.mSequence.charAt(i)) {
                case 'A': 
                case 'a': {
                    ++n2;
                    continue block8;
                }
                case 'C': 
                case 'c': {
                    ++n3;
                    continue block8;
                }
                case 'G': 
                case 'g': {
                    ++n4;
                    continue block8;
                }
                case 'T': 
                case 't': {
                    ++n5;
                    continue block8;
                }
                case 'N': 
                case 'n': {
                    ++n6;
                    continue block8;
                }
                case '-': {
                    --n7;
                }
            }
        }
        double d2 = 15400 * n2 + 7400 * n3 + 11500 * n4 + 8700 * n5 + 10750 * n6;
        double d3 = 312.0 * (double)n2 + 288.0 * (double)n3 + 328.0 * (double)n4 + 303.0 * (double)n5 + 307.75 * (double)n6 - 61.0;
        d = 1.0 / (d2 / (1000.0 * d3));
        return d;
    }

    public double ugPerOD() {
        return this.ugPerOD(2);
    }

    public double ugPerOD(int n) {
        double d = 0.0;
        if (!this.isDNA() || this.mSequence == null) {
            return 0.0;
        }
        int n2 = this.mSequence.length();
        if (n2 == 0) {
            return d;
        }
        if (pec == null) {
            Sequence.loadPEC();
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        block17: for (int i = 0; i < n2; ++i) {
            Integer n10;
            if (i < n2 - 1 && (n10 = (Integer)pec.get(this.mSequence.substring(i, i + 2).toUpperCase())) != null) {
                n8 += n10.intValue();
            }
            if (i > 0 && i < n2 - 1) {
                switch (this.mSequence.charAt(i)) {
                    case 'A': 
                    case 'a': {
                        n9 += 15400;
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        n9 += 7400;
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        n9 += 11500;
                        break;
                    }
                    case 'T': 
                    case 't': {
                        n9 += 8700;
                        break;
                    }
                    case 'N': 
                    case 'n': {
                        n9 += 10750;
                    }
                }
            }
            switch (this.mSequence.charAt(i)) {
                case 'A': 
                case 'a': {
                    ++n3;
                    continue block17;
                }
                case 'C': 
                case 'c': {
                    ++n4;
                    continue block17;
                }
                case 'G': 
                case 'g': {
                    ++n5;
                    continue block17;
                }
                case 'T': 
                case 't': {
                    ++n6;
                    continue block17;
                }
                case 'N': 
                case 'n': {
                    ++n7;
                }
            }
        }
        double d2 = 0.0;
        switch (n) {
            case 1: {
                d2 = 15400 * n3 + 7400 * n4 + 11500 * n5 + 8700 * n6 + 10750 * n7;
                break;
            }
            default: {
                d2 = 2 * n8 - n9;
            }
        }
        double d3 = 312.0 * (double)n3 + 288.0 * (double)n4 + 328.0 * (double)n5 + 303.0 * (double)n6 + 307.75 * (double)n7 - 61.0;
        d = 1.0 / (d2 / (1000.0 * d3));
        return d;
    }

    public static int checkSum(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        char[] cArray = string.toCharArray();
        int n3 = cArray.length;
        for (int i = 0; i < n3; ++i) {
            n2 += ++n * Character.toUpperCase(cArray[i]);
            if (n != 57) continue;
            n = 0;
        }
        return n2 % 10000;
    }

    public static char codonToAA(String string) {
        int n;
        int n2;
        if (string.length() != 3) {
            return 'X';
        }
        string = string.toUpperCase();
        char[] cArray = new char[]{'\b', '\u0007', '\u0004', '\u000b', '\u0000', '\u0000', '\u0002', '\r', '\u0000', '\u0000', '\u0003', '\u0000', '\f', '\u000f', '\u0000', '\u0000', '\u0000', '\n', '\u0006', '\u0001', '\u0001', '\u000e', '\t', '\u000f', '\u0005', '\u0000'};
        int[][] nArrayArray = new int[][]{{0, 16, 32, 48, 0}, {0, 4, 8, 12, 0}, {1, 2, 3, 4, 1}};
        int[] nArray = new int[]{1, 4, 8, 2};
        int[] nArray2 = new int[]{0, 0, 0};
        String string2 = "TCAGU";
        String string3 = " FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG";
        int n3 = 0;
        for (n2 = 0; n2 < 3; ++n2) {
            int n4 = string2.indexOf(string.charAt(n2));
            if (n4 > -1) {
                n3 += nArrayArray[n2][n4];
                continue;
            }
            n3 += 65;
        }
        if (n3 <= 64) {
            n = string3.charAt(n3);
        } else {
            n = 88;
            nArray2[0] = cArray[string.charAt(0) - 65];
            nArray2[1] = cArray[string.charAt(1) - 65];
            nArray2[2] = cArray[string.charAt(2) - 65];
            int n5 = 0;
            block1: for (n2 = 0; n2 <= 3; ++n2) {
                if ((nArray[n2] & nArray2[0]) == 0) continue;
                for (int i = 0; i <= 3; ++i) {
                    if ((nArray[i] & nArray2[1]) == 0) continue;
                    for (int j = 0; j <= 3; ++j) {
                        if ((nArray[j] & nArray2[2]) == 0) continue;
                        n3 = nArrayArray[0][n2] + nArrayArray[1][i] + nArrayArray[2][j];
                        if (++n5 == 1) {
                            n = string3.charAt(n3);
                            continue;
                        }
                        if (n == string3.charAt(n3)) continue;
                        n = 88;
                        break block1;
                    }
                }
            }
            if (n == 88) {
                if (string.equalsIgnoreCase("YTX")) {
                    n = 76;
                }
                if (string.equalsIgnoreCase("MGX")) {
                    n = 82;
                }
                if (string.equalsIgnoreCase("WSX")) {
                    n = 83;
                }
            }
        }
        return (char)n;
    }

    public static String oneToThree(char c) {
        String[] stringArray = new String[]{"Ala", "Asx", "Cys", "Asp", "Glu", "Phe", "Gly", "His", "Ile", "???", "Lys", "Leu", "Met", "Asn", "???", "Pro", "Gln", "Arg", "Ser", "Thr", "???", "Val", "Trp", "???", "Tyr", "Unk", "***"};
        int n = 26;
        if (Character.isLetter(c)) {
            n = Character.isLowerCase(c) ? c - 97 : c - 65;
        }
        return stringArray[n];
    }

    public static String makeTriplets(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 3);
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(string.charAt(i));
            if ((i + 1) % 3 != 0) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static String makeVerboseProtein(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 3);
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(Sequence.oneToThree(string.charAt(i)));
        }
        return stringBuffer.toString();
    }

    public static String makeSparseProtein(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 3);
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(" ").append(string.charAt(i)).append(" ");
        }
        return stringBuffer.toString();
    }

    public static String DNAtoRNA(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == 'T') {
                cArray[i] = 85;
            }
            if (cArray[i] != 't') continue;
            cArray[i] = 117;
        }
        return new String(cArray);
    }

    public static String RNAtoDNA(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == 'U') {
                cArray[i] = 84;
            }
            if (cArray[i] != 'u') continue;
            cArray[i] = 116;
        }
        return new String(cArray);
    }

    public static int guessType(String string) {
        if (string == null) {
            return 2;
        }
        int n = string.length();
        if (n == 0) {
            return 2;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        block10: for (int i = 0; i < n; ++i) {
            ++n7;
            switch (string.charAt(i)) {
                case 'A': 
                case 'a': {
                    ++n2;
                    continue block10;
                }
                case 'C': 
                case 'c': {
                    ++n3;
                    continue block10;
                }
                case 'G': 
                case 'g': {
                    ++n4;
                    continue block10;
                }
                case 'T': 
                case 't': {
                    ++n5;
                    continue block10;
                }
                case 'U': 
                case 'u': {
                    ++n6;
                    continue block10;
                }
                case '-': 
                case 'N': 
                case 'n': {
                    --n7;
                }
            }
        }
        try {
            if ((n2 + n3 + n4 + n5 + n6) * 100 / n7 > 85) {
                return n5 > n6 ? 2 : 3;
            }
            return 1;
        }
        catch (Exception exception) {
            return 2;
        }
    }

    public static String revComp(String string) {
        if (string == null) {
            return null;
        }
        int n = Sequence.guessType(string);
        if (n == 1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        for (int i = 0; i <= (n2 - 1) / 2; ++i) {
            int n3 = n2 - i - 1;
            char c = Sequence.compBase(cArray[i]);
            cArray[i] = Sequence.compBase(cArray[n3]);
            cArray[n3] = c;
        }
        String string2 = new String(cArray);
        if (n == 3) {
            string2 = Sequence.DNAtoRNA(string2);
        }
        return string2;
    }

    public static String nucToProtein(String string) {
        return Sequence.nucToProtein(string, false);
    }

    public static String nucToProtein(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        StringBuffer stringBuffer = new StringBuffer(n / 3);
        for (int i = 0; i <= n - 3; i += 3) {
            String string2 = string.substring(i, i + 3);
            stringBuffer.append(Sequence.codonToAA(string2));
            if (stringBuffer.charAt(stringBuffer.length() - 1) != '*') continue;
            if (bl) break;
            stringBuffer.setCharAt(stringBuffer.length() - 1, '*');
        }
        return stringBuffer.toString();
    }

    public static int[] toBinary(String string) {
        int[] nArray = new int[string.length()];
        char[] cArray = string.toUpperCase().toCharArray();
        block17: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case 'A': {
                    nArray[i] = 1;
                    continue block17;
                }
                case 'C': {
                    nArray[i] = 2;
                    continue block17;
                }
                case 'M': {
                    nArray[i] = 3;
                    continue block17;
                }
                case 'G': {
                    nArray[i] = 4;
                    continue block17;
                }
                case 'R': {
                    nArray[i] = 5;
                    continue block17;
                }
                case 'S': {
                    nArray[i] = 6;
                    continue block17;
                }
                case 'V': {
                    nArray[i] = 7;
                    continue block17;
                }
                case 'T': 
                case 'U': {
                    nArray[i] = 8;
                    continue block17;
                }
                case 'W': {
                    nArray[i] = 9;
                    continue block17;
                }
                case 'Y': {
                    nArray[i] = 10;
                    continue block17;
                }
                case 'H': {
                    nArray[i] = 11;
                    continue block17;
                }
                case 'K': {
                    nArray[i] = 12;
                    continue block17;
                }
                case 'D': {
                    nArray[i] = 13;
                    continue block17;
                }
                case 'B': {
                    nArray[i] = 14;
                    continue block17;
                }
                case 'N': 
                case 'X': {
                    nArray[i] = 15;
                    continue block17;
                }
                default: {
                    nArray[i] = 0;
                }
            }
        }
        return nArray;
    }

    public static char compBase(char c) {
        char[] cArray = new char[]{'T', 'V', 'G', 'H', '-', '-', 'C', 'D', '-', '-', 'M', '-', 'K', 'N', '-', '-', '-', 'Y', 'S', 'A', 'A', 'B', 'W', 'X', 'R', '-'};
        char c2 = c;
        if (Character.isLetter(c)) {
            c2 = Character.isLowerCase(c) ? (char)(cArray[c - 97] + 32) : cArray[c - 65];
        }
        return Character.isLowerCase(c) ? Character.toLowerCase(c2) : c2;
    }

    private static void loadNAweights() {
        naWeights = new Hashtable(6);
        naWeights.put(new Character('A'), new Double(251.2));
        naWeights.put(new Character('C'), new Double(227.2));
        naWeights.put(new Character('G'), new Double(267.2));
        naWeights.put(new Character('T'), new Double(243.2));
        naWeights.put(new Character('U'), new Double(251.2));
        naWeights.put(new Character('N'), new Double(247.2));
    }

    private static void loadAAweights() {
        aaWeights = new Hashtable(22);
        aaWeights.put(new Character('A'), new Double(89.09));
        aaWeights.put(new Character('C'), new Double(121.15));
        aaWeights.put(new Character('D'), new Double(133.1));
        aaWeights.put(new Character('E'), new Double(147.13));
        aaWeights.put(new Character('F'), new Double(165.19));
        aaWeights.put(new Character('G'), new Double(75.07));
        aaWeights.put(new Character('H'), new Double(155.16));
        aaWeights.put(new Character('I'), new Double(131.17));
        aaWeights.put(new Character('K'), new Double(146.19));
        aaWeights.put(new Character('L'), new Double(131.17));
        aaWeights.put(new Character('M'), new Double(149.21));
        aaWeights.put(new Character('N'), new Double(132.12));
        aaWeights.put(new Character('P'), new Double(115.13));
        aaWeights.put(new Character('Q'), new Double(146.15));
        aaWeights.put(new Character('R'), new Double(174.2));
        aaWeights.put(new Character('S'), new Double(105.09));
        aaWeights.put(new Character('T'), new Double(119.12));
        aaWeights.put(new Character('V'), new Double(117.15));
        aaWeights.put(new Character('W'), new Double(204.23));
        aaWeights.put(new Character('Y'), new Double(181.19));
        aaWeights.put(new Character('B'), new Double(132.61));
        aaWeights.put(new Character('Z'), new Double(146.64));
    }

    private static void loadPEC() {
        pec = new Hashtable(20);
        pec.put("AA", new Integer(13700));
        pec.put("AC", new Integer(10600));
        pec.put("AG", new Integer(12500));
        pec.put("AT", new Integer(11400));
        pec.put("AN", new Integer(12050));
        pec.put("CA", new Integer(10600));
        pec.put("CC", new Integer(7300));
        pec.put("CG", new Integer(9000));
        pec.put("CT", new Integer(7600));
        pec.put("CN", new Integer(8625));
        pec.put("GA", new Integer(12600));
        pec.put("GC", new Integer(8800));
        pec.put("GG", new Integer(10800));
        pec.put("GT", new Integer(10000));
        pec.put("GN", new Integer(10550));
        pec.put("TA", new Integer(11700));
        pec.put("TC", new Integer(8100));
        pec.put("TG", new Integer(9500));
        pec.put("TT", new Integer(8400));
        pec.put("TN", new Integer(9425));
        pec.put("NA", new Integer(12150));
        pec.put("NC", new Integer(8700));
        pec.put("NG", new Integer(10450));
        pec.put("NT", new Integer(9350));
        pec.put("NN", new Integer(10162));
    }
}

