/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.util;

import ch.randelshofer.quaqua.util.Images;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class ImageBevelBorder13
implements Border,
UIResource {
    private static final boolean VERBOSE = false;
    private Image image;
    private Insets borderInsets;
    private Insets imageInsets;
    private boolean fillContentArea;

    public ImageBevelBorder13(Image img, Insets borderInsets) {
        this(img, borderInsets, borderInsets, true);
    }

    public ImageBevelBorder13(Image img, Insets imageInsets, Insets borderInsets) {
        this(img, imageInsets, borderInsets, true);
    }

    public ImageBevelBorder13(Image img, Insets imageInsets, Insets borderInsets, boolean fillContentArea) {
        this.image = img;
        this.imageInsets = imageInsets;
        this.borderInsets = borderInsets;
        this.fillContentArea = fillContentArea;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public Insets getBorderInsets(Component c) {
        return (Insets)this.borderInsets.clone();
    }

    public void paintBorder(Component c, Graphics gr, int x, int y, int width, int height) {
        if (this.image == null) {
            return;
        }
        BufferedImage image = Images.toBufferedImage(this.image);
        if (!gr.getClipBounds().intersects(x, y, width, height)) {
            return;
        }
        Graphics2D g = (Graphics2D)gr;
        int top = this.imageInsets.top;
        int left = this.imageInsets.left;
        int bottom = this.imageInsets.bottom;
        int right = this.imageInsets.right;
        int imgWidth = image.getWidth();
        int imgHeight = image.getHeight();
        if (this.fillContentArea && width == imgWidth && height == imgHeight) {
            g.drawImage((Image)image, x, y, c);
            return;
        }
        if (width == imgWidth) {
            left = imgWidth;
            right = 0;
        }
        if (height == imgHeight) {
            top = imgHeight;
            bottom = 0;
        }
        if (width < left + right) {
            left = Math.min(left, width / 2);
            right = width - left;
        }
        if (height < top + bottom) {
            top = Math.min(top, height / 2);
            bottom = height - top;
        }
        if (top > 0 && left > 0) {
            g.drawImage(image, x, y, x + left, y + top, 0, 0, left, top, c);
        }
        if (top > 0 && right > 0) {
            g.drawImage(image, x + width - right, y, x + width, y + top, imgWidth - right, 0, imgWidth, top, c);
        }
        if (bottom > 0 && left > 0) {
            g.drawImage(image, x, y + height - bottom, x + left, y + height, 0, imgHeight - bottom, left, imgHeight, c);
        }
        if (bottom > 0 && right > 0) {
            g.drawImage(image, x + width - right, y + height - bottom, x + width, y + height, imgWidth - right, imgHeight - bottom, imgWidth, imgHeight, c);
        }
        BufferedImage subImg = null;
        if (top > 0 && left + right < width) {
            subImg = image.getSubimage(left, 0, imgWidth - right - left, top);
            g.drawImage(subImg, x + left, y, width - left - right, top, c);
        }
        if (bottom > 0 && left + right < width) {
            subImg = image.getSubimage(left, imgHeight - bottom, imgWidth - right - left, bottom);
            g.drawImage(subImg, x + left, y + height - bottom, width - left - right, bottom, c);
        }
        if (left > 0 && top + bottom < height) {
            subImg = image.getSubimage(0, top, left, imgHeight - top - bottom);
            g.drawImage(subImg, x, y + top, left, height - top - bottom, c);
        }
        if (right > 0 && top + bottom < height) {
            subImg = image.getSubimage(imgWidth - right, top, right, imgHeight - top - bottom);
            g.drawImage(subImg, x + width - right, y + top, right, height - top - bottom, c);
        }
        if (this.fillContentArea && left + right < width && top + bottom < height) {
            g.setColor(new Color(image.getRGB(left, top), true));
            g.fillRect(x + left, y + top, width - right - left, height - top - bottom);
        }
    }
}

