/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.AnimatedBorder;
import ch.randelshofer.quaqua.ButtonStateBorder;
import ch.randelshofer.quaqua.FocusBorder;
import ch.randelshofer.quaqua.OverlayBorder;
import ch.randelshofer.quaqua.QuaquaBorderFactory;
import ch.randelshofer.quaqua.QuaquaColorWellBorder;
import ch.randelshofer.quaqua.QuaquaToolBarButtonStateBorder;
import ch.randelshofer.quaqua.QuaquaToolBarTabButtonBorder;
import ch.randelshofer.quaqua.VisualMargin;
import ch.randelshofer.quaqua.util.Images;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;

public class QuaquaButtonBorder
implements Border,
UIResource {
    private static Border regularPushButtonBorder;
    private static Border smallPushButtonBorder;
    private static Border squareBorder;
    private static Border placardBorder;
    private static Border colorWellBorder;
    private static Border bevelBorder;
    private static Border toolBarBorder;
    private static Border toolBarRolloverBorder;
    private static Border toolBarTabBorder;
    private static Border toggleWestBorder;
    private static Border toggleEastBorder;
    private static Border toggleCenterBorder;
    private static Border toggleBorder;
    private static Border helpBorder;
    private static Border tableHeaderBorder;
    private String defaultStyle;

    public QuaquaButtonBorder(String defaultStyle) {
        this.defaultStyle = defaultStyle;
    }

    public Border getBorder(JComponent c) {
        Border b = null;
        String style = this.getStyle(c);
        if (style.equals("text") || style.equals("push")) {
            b = c.getFont().getSize() <= 11 ? this.getSmallPushButtonBorder() : this.getRegularPushButtonBorder();
        } else if (style.equals("toolBar")) {
            if (toolBarBorder == null) {
                toolBarBorder = new CompoundBorder(new EmptyBorder(-1, -1, -1, -2), new QuaquaToolBarButtonStateBorder(Images.createImage(QuaquaButtonBorder.class.getResource("images/Toggle.borders.png")), 10, true, new Insets(8, 10, 15, 10), new Insets(4, 6, 4, 6), true, false));
            }
            b = toolBarBorder;
        } else if (style.equals("toolBarRollover")) {
            if (toolBarRolloverBorder == null) {
                toolBarRolloverBorder = new CompoundBorder(new EmptyBorder(-1, -1, -1, -2), new QuaquaToolBarButtonStateBorder(Images.createImage(QuaquaButtonBorder.class.getResource("images/Toggle.borders.png")), 10, true, new Insets(8, 10, 15, 10), new Insets(4, 6, 4, 6), true, true));
            }
            b = toolBarRolloverBorder;
        } else if (style.equals("toolBarTab")) {
            if (toolBarTabBorder == null) {
                toolBarTabBorder = new QuaquaToolBarTabButtonBorder();
            }
            b = toolBarTabBorder;
        } else if (style.equals("square") || style.equals("toolbar")) {
            b = this.getSquareBorder();
        } else if (style.equals("placard")) {
            b = this.getPlacardBorder();
        } else if (style.equals("tableHeader")) {
            b = this.getTableHeaderBorder();
        } else if (style.equals("colorWell")) {
            if (colorWellBorder == null) {
                colorWellBorder = new CompoundBorder(new VisualMargin(2, 2, 2, 2), new OverlayBorder(new CompoundBorder(new EmptyBorder(2, 2, 2, 2), new QuaquaColorWellBorder()), new FocusBorder(QuaquaBorderFactory.create(Images.createImage(QuaquaButtonBorder.class.getResource("images/Square.focusRing.png")), new Insets(10, 9, 10, 8), new Insets(6, 9, 6, 9), true))));
            }
            b = colorWellBorder;
        } else if (style.equals("icon") || style.equals("bevel")) {
            if (bevelBorder == null) {
                Insets borderInsets = new Insets(4, 3, 3, 3);
                FocusBorder focusBorder = new FocusBorder(QuaquaBorderFactory.create(Images.createImage(QuaquaButtonBorder.class.getResource("images/RoundedBevel.focusRing.png")), new Insets(10, 9, 10, 8), borderInsets, true));
                bevelBorder = new CompoundBorder(new VisualMargin(3, 2, 2, 2), new OverlayBorder(new ButtonStateBorder(Images.createImage(QuaquaButtonBorder.class.getResource("images/RoundedBevel.borders.png")), 10, true, new Insets(10, 9, 10, 8), borderInsets, true), focusBorder));
            }
            b = bevelBorder;
        } else if (style.equals("toggle")) {
            if (toggleBorder == null) {
                Insets borderInsets = new Insets(3, 5, 3, 5);
                toggleBorder = new CompoundBorder(new VisualMargin(2, 2, 2, 2), new OverlayBorder(new ButtonStateBorder(Images.createImage(QuaquaButtonBorder.class.getResource("images/Toggle.borders.png")), 10, true, new Insets(8, 10, 15, 10), borderInsets, true), new FocusBorder(QuaquaBorderFactory.create(Images.createImage(QuaquaButtonBorder.class.getResource("images/Toggle.focusRing.png")), new Insets(8, 10, 15, 10), borderInsets, false))));
            }
            b = toggleBorder;
        } else if (style.equals("toggleEast")) {
            if (toggleEastBorder == null) {
                Insets borderInsets = new Insets(3, 1, 3, 5);
                VisualMargin cm = new VisualMargin(2, 0, 2, 2);
                toggleEastBorder = new CompoundBorder(cm, new OverlayBorder(new ButtonStateBorder(Images.createImage(QuaquaButtonBorder.class.getResource("images/Toggle.east.borders.png")), 10, true, new Insets(8, 1, 15, 10), borderInsets, true), new FocusBorder(QuaquaBorderFactory.create(Images.createImage(QuaquaButtonBorder.class.getResource("images/Toggle.east.focusRing.png")), new Insets(8, 4, 15, 10), borderInsets, false))));
                cm.setFixed(false, true, false, false);
            }
            b = toggleEastBorder;
        } else if (style.equals("toggleCenter")) {
            if (toggleCenterBorder == null) {
                Insets borderInsets = new Insets(3, 1, 3, 1);
                VisualMargin cm = new VisualMargin(2, 0, 2, 0);
                toggleCenterBorder = new CompoundBorder(cm, new OverlayBorder(new ButtonStateBorder(Images.createImage(QuaquaButtonBorder.class.getResource("images/Toggle.center.borders.png")), 10, true, new Insets(8, 0, 15, 1), borderInsets, true), new FocusBorder(QuaquaBorderFactory.create(Images.createImage(QuaquaButtonBorder.class.getResource("images/Toggle.center.focusRing.png")), new Insets(8, 4, 15, 4), borderInsets, false))));
                cm.setFixed(false, true, false, true);
            }
            b = toggleCenterBorder;
        } else if (style.equals("toggleWest")) {
            if (toggleWestBorder == null) {
                Insets borderInsets = new Insets(3, 5, 3, 1);
                VisualMargin cm = new VisualMargin(2, 2, 2, 0);
                toggleWestBorder = new CompoundBorder(cm, new OverlayBorder(new ButtonStateBorder(Images.createImage(QuaquaButtonBorder.class.getResource("images/Toggle.west.borders.png")), 10, true, new Insets(8, 10, 15, 1), borderInsets, true), new FocusBorder(QuaquaBorderFactory.create(Images.createImage(QuaquaButtonBorder.class.getResource("images/Toggle.west.focusRing.png")), new Insets(8, 10, 15, 4), borderInsets, false))));
                cm.setFixed(false, false, false, true);
            }
            b = toggleWestBorder;
        } else if (style.equals("help")) {
            if (helpBorder == null) {
                helpBorder = new VisualMargin(2, 3, 2, 3);
            }
            b = helpBorder;
        } else {
            b = c.getParent() instanceof JToolBar ? this.getSquareBorder() : (c.getFont().getSize() <= 11 ? this.getSmallPushButtonBorder() : this.getRegularPushButtonBorder());
        }
        if (b == null) {
            throw new InternalError(style);
        }
        return b;
    }

    private Border getRegularPushButtonBorder() {
        if (regularPushButtonBorder == null) {
            Insets borderInsets = new Insets(3, 8, 3, 8);
            BufferedImage[] imageFrames = Images.split(Images.createImage(QuaquaButtonBorder.class.getResource("images/Button.default.png")), 12, true);
            Border[] borderFrames = new Border[12];
            for (int i = 0; i < 12; ++i) {
                borderFrames[i] = QuaquaBorderFactory.create((Image)imageFrames[i], new Insets(11, 13, 13, 13), borderInsets, true);
            }
            ButtonStateBorder buttonStateBorder = new ButtonStateBorder(Images.split(Images.createImage(QuaquaButtonBorder.class.getResource("images/Button.borders.png")), 10, true), new Insets(11, 13, 13, 13), borderInsets, true);
            buttonStateBorder.setBorder(10, new AnimatedBorder(borderFrames, 100L));
            regularPushButtonBorder = new CompoundBorder(new VisualMargin(2, 4, 2, 4), new OverlayBorder(buttonStateBorder, new FocusBorder(QuaquaBorderFactory.create(Images.createImage(QuaquaButtonBorder.class.getResource("images/Button.focusRing.png")), new Insets(12, 13, 12, 13), borderInsets, false))));
        }
        return regularPushButtonBorder;
    }

    private Border getSquareBorder() {
        if (squareBorder == null) {
            squareBorder = new CompoundBorder(new VisualMargin(2, 2, 2, 2), new OverlayBorder(new CompoundBorder(new EmptyBorder(2, 2, 2, 2), QuaquaBorderFactory.createSquareButtonBorder()), new FocusBorder(QuaquaBorderFactory.create(Images.createImage(QuaquaButtonBorder.class.getResource("images/Square.focusRing.png")), new Insets(10, 9, 10, 8), new Insets(6, 9, 6, 9), true))));
        }
        return squareBorder;
    }

    private Border getPlacardBorder() {
        if (placardBorder == null) {
            placardBorder = new CompoundBorder(new VisualMargin(2, 2, 2, 2), new OverlayBorder(new CompoundBorder(new EmptyBorder(1, 2, 1, 2), QuaquaBorderFactory.createPlacardButtonBorder()), new FocusBorder(QuaquaBorderFactory.create(Images.createImage(QuaquaButtonBorder.class.getResource("images/Square.focusRing.png")), new Insets(10, 9, 10, 8), new Insets(6, 9, 6, 9), true))));
        }
        return placardBorder;
    }

    private Border getTableHeaderBorder() {
        if (tableHeaderBorder == null) {
            tableHeaderBorder = new ButtonStateBorder(Images.createImage(QuaquaButtonBorder.class.getResource("images/TableHeader.borders.png")), 4, true, new Insets(7, 1, 8, 1), new Insets(1, 2, 1, 2), true);
        }
        return tableHeaderBorder;
    }

    private Border getSmallPushButtonBorder() {
        if (smallPushButtonBorder == null) {
            Insets borderInsets = new Insets(3, 8, 3, 8);
            BufferedImage[] imageFrames = Images.split(Images.createImage(QuaquaButtonBorder.class.getResource("images/Button.small.default.png")), 12, true);
            Border[] borderFrames = new Border[12];
            for (int i = 0; i < 12; ++i) {
                borderFrames[i] = QuaquaBorderFactory.create((Image)imageFrames[i], new Insets(9, 13, 12, 13), borderInsets, true);
            }
            ButtonStateBorder buttonStateBorder = new ButtonStateBorder(Images.split(Images.createImage(QuaquaButtonBorder.class.getResource("images/Button.small.borders.png")), 10, true), new Insets(9, 13, 12, 13), borderInsets, true);
            buttonStateBorder.setBorder(10, new AnimatedBorder(borderFrames, 100L));
            smallPushButtonBorder = new CompoundBorder(new VisualMargin(2, 3, 2, 3), new OverlayBorder(buttonStateBorder, new FocusBorder(QuaquaBorderFactory.create(Images.createImage(QuaquaButtonBorder.class.getResource("images/Button.small.focusRing.png")), new Insets(9, 14, 12, 14), borderInsets, false))));
        }
        return smallPushButtonBorder;
    }

    public Insets getDefaultMargin(JComponent c) {
        boolean isSmall;
        Insets margin = null;
        String style = this.getStyle(c);
        boolean bl = isSmall = c.getFont().getSize() <= 11;
        margin = style.equals("text") || style.equals("push") ? (isSmall ? new Insets(1, 4, 1, 4) : new Insets(1, 8, 2, 8)) : (style.equals("toolBar") ? new Insets(0, 0, 0, 0) : (style.equals("toolBarRollover") ? new Insets(0, 0, 0, 0) : (style.equals("toolBarTab") ? new Insets(0, 0, 0, 0) : (style.equals("square") ? (isSmall ? new Insets(1, 6, 1, 6) : new Insets(1, 6, 2, 6)) : (style.equals("placard") ? (isSmall ? new Insets(1, 6, 1, 6) : new Insets(1, 6, 2, 6)) : (style.equals("colorWell") ? (isSmall ? new Insets(1, 6, 1, 6) : new Insets(1, 6, 2, 6)) : (style.equals("icon") || style.equals("bevel") ? (isSmall ? new Insets(1, 6, 1, 6) : new Insets(1, 6, 2, 6)) : (style.equals("toggle") ? (isSmall ? new Insets(1, 5, 1, 5) : new Insets(1, 5, 2, 5)) : (style.equals("toggleEast") ? (isSmall ? new Insets(1, 5, 1, 5) : new Insets(1, 5, 2, 5)) : (style.equals("toggleCenter") ? (isSmall ? new Insets(1, 5, 1, 5) : new Insets(1, 5, 2, 5)) : (style.equals("toggleWest") ? (isSmall ? new Insets(1, 5, 1, 5) : new Insets(1, 5, 2, 5)) : (style.equals("help") ? new Insets(0, 0, 0, 0) : (c.getParent() instanceof JToolBar ? new Insets(0, 0, 0, 0) : (c.getFont().getSize() <= 11 ? new Insets(0, 0, 0, 0) : new Insets(0, 0, 0, 0)))))))))))))));
        return margin;
    }

    public boolean isFixedHeight(JComponent c) {
        String style = this.getStyle(c).toLowerCase();
        return style.equals("text") || style.equals("push") || style.startsWith("toggle");
    }

    protected String getStyle(JComponent c) {
        String style = (String)c.getClientProperty("Quaqua.Button.style");
        if (style == null) {
            style = (String)c.getClientProperty("JButton.buttonType");
        }
        if (style == null) {
            style = this.defaultStyle;
        }
        return style;
    }

    public boolean hasPressedCue(JComponent c) {
        Border b = this.getBorder(c);
        return b != toolBarBorder;
    }

    public Insets getVisualMargin(Component c) {
        Border b = this.getBorder((JComponent)c);
        if (b instanceof VisualMargin) {
            return ((VisualMargin)b).getVisualMargin(c);
        }
        if (b instanceof CompoundBorder && (b = ((CompoundBorder)b).getOutsideBorder()) instanceof VisualMargin) {
            return ((VisualMargin)b).getVisualMargin(c);
        }
        return new Insets(0, 0, 0, 0);
    }

    public Insets getBorderInsets(Component c) {
        JComponent jc;
        Insets insets;
        if (c instanceof JComponent && (insets = (Insets)(jc = (JComponent)c).getClientProperty("Quaqua.Border.insets")) != null) {
            return (Insets)insets.clone();
        }
        boolean isBorderPainted = true;
        if (c instanceof AbstractButton) {
            isBorderPainted = ((AbstractButton)c).isBorderPainted();
        }
        if (!isBorderPainted) {
            insets = (Insets)UIManager.getInsets("Component.visualMargin").clone();
        } else {
            insets = this.getBorder((JComponent)c).getBorderInsets(c);
            if (c instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)c;
                Insets margin = b.getMargin();
                if (margin == null || margin instanceof UIResource) {
                    margin = this.getDefaultMargin((JComponent)c);
                }
                if (margin != null) {
                    insets.top += margin.top;
                    insets.left += margin.left;
                    insets.bottom += margin.bottom;
                    insets.right += margin.right;
                }
            }
        }
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.getBorder((JComponent)c).paintBorder(c, g, x, y, width, height);
    }
}

