/*
 * Decompiled with CFR 0.152.
 */
package neobio.alignment;

import java.io.IOException;
import java.io.Reader;
import neobio.alignment.CharSequence;
import neobio.alignment.IncompatibleScoringSchemeException;
import neobio.alignment.InvalidSequenceException;
import neobio.alignment.PairwiseAlignment;
import neobio.alignment.PairwiseAlignmentAlgorithm;

public class SmithWaterman
extends PairwiseAlignmentAlgorithm {
    protected CharSequence seq1;
    protected CharSequence seq2;
    protected int[][] matrix;
    protected int max_row;
    protected int max_col;

    protected void loadSequencesInternal(Reader reader, Reader reader2) throws IOException, InvalidSequenceException {
        this.seq1 = new CharSequence(reader);
        this.seq2 = new CharSequence(reader2);
    }

    protected void unloadSequencesInternal() {
        this.seq1 = null;
        this.seq2 = null;
        this.matrix = null;
    }

    protected PairwiseAlignment computePairwiseAlignment() throws IncompatibleScoringSchemeException {
        this.computeMatrix();
        PairwiseAlignment pairwiseAlignment = this.buildOptimalAlignment();
        this.matrix = null;
        return pairwiseAlignment;
    }

    protected void computeMatrix() throws IncompatibleScoringSchemeException {
        int n = this.seq1.length() + 1;
        int n2 = this.seq2.length() + 1;
        this.matrix = new int[n][n2];
        int n3 = 0;
        while (n3 < n2) {
            this.matrix[0][n3] = 0;
            ++n3;
        }
        int n4 = 0;
        this.max_col = 0;
        this.max_row = 0;
        int n5 = 1;
        while (n5 < n) {
            this.matrix[n5][0] = 0;
            n3 = 1;
            while (n3 < n2) {
                int n6 = this.matrix[n5][n3 - 1] + this.scoreInsertion(this.seq2.charAt(n3));
                int n7 = this.matrix[n5 - 1][n3 - 1] + this.scoreSubstitution(this.seq1.charAt(n5), this.seq2.charAt(n3));
                int n8 = this.matrix[n5 - 1][n3] + this.scoreDeletion(this.seq1.charAt(n5));
                this.matrix[n5][n3] = this.max(n6, n7, n8, 0);
                if (this.matrix[n5][n3] > n4) {
                    n4 = this.matrix[n5][n3];
                    this.max_row = n5;
                    this.max_col = n3;
                }
                ++n3;
            }
            ++n5;
        }
    }

    protected PairwiseAlignment buildOptimalAlignment() throws IncompatibleScoringSchemeException {
        int n = this.max_row;
        int n2 = this.max_col;
        int n3 = this.matrix[n][n2];
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        while ((n > 0 || n2 > 0) && this.matrix[n][n2] > 0) {
            int n4;
            if (n2 > 0 && this.matrix[n][n2] == this.matrix[n][n2 - 1] + this.scoreInsertion(this.seq2.charAt(n2))) {
                stringBuffer.insert(0, '-');
                stringBuffer2.insert(0, ' ');
                stringBuffer3.insert(0, this.seq2.charAt(n2));
                --n2;
                continue;
            }
            if (n > 0 && n2 > 0 && this.matrix[n][n2] == this.matrix[n - 1][n2 - 1] + (n4 = this.scoreSubstitution(this.seq1.charAt(n), this.seq2.charAt(n2)))) {
                stringBuffer.insert(0, this.seq1.charAt(n));
                if (this.seq1.charAt(n) == this.seq2.charAt(n2)) {
                    if (this.useMatchTag()) {
                        stringBuffer2.insert(0, '|');
                    } else {
                        stringBuffer2.insert(0, this.seq1.charAt(n));
                    }
                } else if (n4 > 0) {
                    stringBuffer2.insert(0, '+');
                } else {
                    stringBuffer2.insert(0, ' ');
                }
                stringBuffer3.insert(0, this.seq2.charAt(n2));
                --n;
                --n2;
                continue;
            }
            stringBuffer.insert(0, this.seq1.charAt(n));
            stringBuffer2.insert(0, ' ');
            stringBuffer3.insert(0, '-');
            --n;
        }
        return new PairwiseAlignment(stringBuffer.toString(), stringBuffer2.toString(), stringBuffer3.toString(), n3);
    }

    protected int computeScore() throws IncompatibleScoringSchemeException {
        int n = this.seq1.length() + 1;
        int n2 = this.seq2.length() + 1;
        int n3 = 0;
        if (n <= n2) {
            int[] nArray = new int[n];
            int n4 = 0;
            while (n4 < n) {
                nArray[n4] = 0;
                ++n4;
            }
            int n5 = 1;
            while (n5 < n2) {
                int n6 = 0;
                n4 = 1;
                while (n4 < n) {
                    int n7 = nArray[n4] + this.scoreInsertion(this.seq2.charAt(n5));
                    int n8 = nArray[n4 - 1] + this.scoreSubstitution(this.seq1.charAt(n4), this.seq2.charAt(n5));
                    int n9 = n6 + this.scoreDeletion(this.seq1.charAt(n4));
                    nArray[n4 - 1] = n6;
                    n6 = this.max(n7, n8, n9, 0);
                    if (n6 > n3) {
                        n3 = n6;
                    }
                    ++n4;
                }
                nArray[n - 1] = n6;
                ++n5;
            }
        } else {
            int[] nArray = new int[n2];
            int n10 = 0;
            while (n10 < n2) {
                nArray[n10] = 0;
                ++n10;
            }
            int n11 = 1;
            while (n11 < n) {
                int n12 = 0;
                n10 = 1;
                while (n10 < n2) {
                    int n13 = n12 + this.scoreInsertion(this.seq2.charAt(n10));
                    int n14 = nArray[n10 - 1] + this.scoreSubstitution(this.seq1.charAt(n11), this.seq2.charAt(n10));
                    int n15 = nArray[n10] + this.scoreDeletion(this.seq1.charAt(n11));
                    nArray[n10 - 1] = n12;
                    n12 = this.max(n13, n14, n15, 0);
                    if (n12 > n3) {
                        n3 = n12;
                    }
                    ++n10;
                }
                nArray[n2 - 1] = n12;
                ++n11;
            }
        }
        return n3;
    }
}

