/*
 * Decompiled with CFR 0.152.
 */
package neobio.alignment;

import java.io.IOException;
import java.io.Reader;
import neobio.alignment.CharSequence;
import neobio.alignment.IncompatibleScoringSchemeException;
import neobio.alignment.InvalidSequenceException;
import neobio.alignment.PairwiseAlignment;
import neobio.alignment.PairwiseAlignmentAlgorithm;

public class NeedlemanWunsch
extends PairwiseAlignmentAlgorithm {
    protected CharSequence seq1;
    protected CharSequence seq2;
    protected int[][] matrix;

    protected void loadSequencesInternal(Reader reader, Reader reader2) throws IOException, InvalidSequenceException {
        this.seq1 = new CharSequence(reader);
        this.seq2 = new CharSequence(reader2);
    }

    protected void unloadSequencesInternal() {
        this.seq1 = null;
        this.seq2 = null;
        this.matrix = null;
    }

    protected PairwiseAlignment computePairwiseAlignment() throws IncompatibleScoringSchemeException {
        this.computeMatrix();
        PairwiseAlignment pairwiseAlignment = this.buildOptimalAlignment();
        this.matrix = null;
        return pairwiseAlignment;
    }

    protected void computeMatrix() throws IncompatibleScoringSchemeException {
        int n = this.seq1.length() + 1;
        int n2 = this.seq2.length() + 1;
        this.matrix = new int[n][n2];
        this.matrix[0][0] = 0;
        int n3 = 1;
        while (n3 < n2) {
            this.matrix[0][n3] = this.matrix[0][n3 - 1] + this.scoreInsertion(this.seq2.charAt(n3));
            ++n3;
        }
        int n4 = 1;
        while (n4 < n) {
            this.matrix[n4][0] = this.matrix[n4 - 1][0] + this.scoreDeletion(this.seq1.charAt(n4));
            n3 = 1;
            while (n3 < n2) {
                int n5 = this.matrix[n4][n3 - 1] + this.scoreInsertion(this.seq2.charAt(n3));
                int n6 = this.matrix[n4 - 1][n3 - 1] + this.scoreSubstitution(this.seq1.charAt(n4), this.seq2.charAt(n3));
                int n7 = this.matrix[n4 - 1][n3] + this.scoreDeletion(this.seq1.charAt(n4));
                this.matrix[n4][n3] = this.max(n5, n6, n7);
                ++n3;
            }
            ++n4;
        }
    }

    protected PairwiseAlignment buildOptimalAlignment() throws IncompatibleScoringSchemeException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        int n = this.matrix.length - 1;
        int n2 = this.matrix[n].length - 1;
        int n3 = this.matrix[n][n2];
        while (n > 0 || n2 > 0) {
            int n4;
            if (n2 > 0 && this.matrix[n][n2] == this.matrix[n][n2 - 1] + this.scoreInsertion(this.seq2.charAt(n2))) {
                stringBuffer.insert(0, '-');
                stringBuffer2.insert(0, ' ');
                stringBuffer3.insert(0, this.seq2.charAt(n2));
                --n2;
                continue;
            }
            if (n > 0 && n2 > 0 && this.matrix[n][n2] == this.matrix[n - 1][n2 - 1] + (n4 = this.scoreSubstitution(this.seq1.charAt(n), this.seq2.charAt(n2)))) {
                stringBuffer.insert(0, this.seq1.charAt(n));
                if (this.seq1.charAt(n) == this.seq2.charAt(n2)) {
                    if (this.useMatchTag()) {
                        stringBuffer2.insert(0, '|');
                    } else {
                        stringBuffer2.insert(0, this.seq1.charAt(n));
                    }
                } else if (n4 > 0) {
                    stringBuffer2.insert(0, '+');
                } else {
                    stringBuffer2.insert(0, ' ');
                }
                stringBuffer3.insert(0, this.seq2.charAt(n2));
                --n;
                --n2;
                continue;
            }
            stringBuffer.insert(0, this.seq1.charAt(n));
            stringBuffer2.insert(0, ' ');
            stringBuffer3.insert(0, '-');
            --n;
        }
        return new PairwiseAlignment(stringBuffer.toString(), stringBuffer2.toString(), stringBuffer3.toString(), n3);
    }

    protected int computeScore() throws IncompatibleScoringSchemeException {
        int n;
        int n2 = this.seq1.length() + 1;
        if (n2 <= (n = this.seq2.length() + 1)) {
            int[] nArray = new int[n2];
            nArray[0] = 0;
            int n3 = 1;
            while (n3 < n2) {
                nArray[n3] = nArray[n3 - 1] + this.scoreDeletion(this.seq1.charAt(n3));
                ++n3;
            }
            int n4 = 1;
            while (n4 < n) {
                int n5 = nArray[0] + this.scoreInsertion(this.seq2.charAt(n4));
                n3 = 1;
                while (n3 < n2) {
                    int n6 = nArray[n3] + this.scoreInsertion(this.seq2.charAt(n4));
                    int n7 = nArray[n3 - 1] + this.scoreSubstitution(this.seq1.charAt(n3), this.seq2.charAt(n4));
                    int n8 = n5 + this.scoreDeletion(this.seq1.charAt(n3));
                    nArray[n3 - 1] = n5;
                    n5 = this.max(n6, n7, n8);
                    ++n3;
                }
                nArray[n2 - 1] = n5;
                ++n4;
            }
            return nArray[n2 - 1];
        }
        int[] nArray = new int[n];
        nArray[0] = 0;
        int n9 = 1;
        while (n9 < n) {
            nArray[n9] = nArray[n9 - 1] + this.scoreInsertion(this.seq2.charAt(n9));
            ++n9;
        }
        int n10 = 1;
        while (n10 < n2) {
            int n11 = nArray[0] + this.scoreDeletion(this.seq1.charAt(n10));
            n9 = 1;
            while (n9 < n) {
                int n12 = n11 + this.scoreInsertion(this.seq2.charAt(n9));
                int n13 = nArray[n9 - 1] + this.scoreSubstitution(this.seq1.charAt(n10), this.seq2.charAt(n9));
                int n14 = nArray[n9] + this.scoreDeletion(this.seq1.charAt(n10));
                nArray[n9 - 1] = n11;
                n11 = this.max(n12, n13, n14);
                ++n9;
            }
            nArray[n - 1] = n11;
            ++n10;
        }
        return nArray[n - 1];
    }
}

