/*
 * Decompiled with CFR 0.152.
 */
package com.infocom.print;

import com.infocom.print.PFInchUnit;
import com.infocom.print.PFPoint;
import com.infocom.print.PFPrintObject;
import com.infocom.print.PFUnit;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.text.AttributedString;
import java.util.Vector;

public class PFParagraph
extends PFPrintObject {
    public static final int LEFT_JUSTIFIED = 0;
    public static final int RIGHT_JUSTIFIED = 1;
    public static final int CENTER_JUSTIFIED = 2;
    public static final int FULL_JUSTIFIED = 3;
    private AttributedString text;
    private Font font = new Font("serif", 0, 12);
    private int horizontalAlignment = 0;
    private Color textColor = Color.black;
    private boolean autoAdjustHeight = false;

    public PFParagraph() {
    }

    public PFParagraph(AttributedString attributedString) {
        this.text = attributedString;
    }

    public void setText(AttributedString attributedString) {
        this.text = attributedString;
        if (this.autoAdjustHeight) {
            this.setHeight(this.getTextHeight());
        }
    }

    public void setText(String string) {
        this.text = new AttributedString(string);
        this.text.addAttribute(TextAttribute.FONT, new Font("serif", 0, 12));
        this.setText(this.text);
    }

    public void setAutoAdjustHeight(boolean bl) {
        this.autoAdjustHeight = bl;
    }

    public boolean isAutoAdjustHeight() {
        return this.autoAdjustHeight;
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void print(Graphics2D graphics2D) {
        this.computePositionAndSize();
        graphics2D.setColor(this.textColor);
        graphics2D.setFont(this.font);
        switch (this.horizontalAlignment) {
            case 0: {
                this.renderLeftJustified(graphics2D);
                break;
            }
            case 1: {
                this.renderRightJustified(graphics2D);
                break;
            }
            case 2: {
                this.renderCenterJustified(graphics2D);
                break;
            }
            case 3: {
                this.renderFullyJustified(graphics2D);
            }
        }
        this.printChilds(graphics2D);
    }

    public PFUnit getTextHeight() {
        TextLayout textLayout;
        PFInchUnit pFInchUnit = new PFInchUnit(0.0);
        this.computePositionAndSize();
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        double d = this.getDrawingSize().getWidth().getPoints();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(this.text.getIterator(), new FontRenderContext(null, true, true));
        while ((textLayout = lineBreakMeasurer.nextLayout((float)d)) != null) {
            double_.y += (double)(textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading());
        }
        pFInchUnit.setPoints(double_.y);
        return pFInchUnit;
    }

    public PFPoint getNextParagraphPosition() {
        TextLayout textLayout;
        double d = 0.0;
        this.computePositionAndSize();
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        double d2 = this.getDrawingSize().getWidth().getPoints();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(this.text.getIterator(), new FontRenderContext(null, true, true));
        while ((textLayout = lineBreakMeasurer.nextLayout((float)d2)) != null) {
            double_.y += (double)(textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading());
            d = textLayout.getAscent();
        }
        PFInchUnit pFInchUnit = new PFInchUnit();
        pFInchUnit.setPoints(double_.y);
        return new PFPoint(this.getPosition().getX(), pFInchUnit);
    }

    private void renderCenterJustified(Graphics2D graphics2D) {
        TextLayout textLayout;
        Point2D.Double double_ = this.getDrawingOrigin().getPoint2D();
        double d = this.getDrawingSize().getWidth().getPoints();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(this.text.getIterator(), new FontRenderContext(null, true, true));
        while ((textLayout = lineBreakMeasurer.nextLayout((float)d)) != null) {
            double_.y += (double)textLayout.getAscent();
            float f = (float)(double_.x + d / 2.0) - textLayout.getAdvance() / 2.0f;
            textLayout.draw(graphics2D, f, (float)double_.y);
            double_.y += (double)(textLayout.getDescent() + textLayout.getLeading());
        }
    }

    private void renderRightJustified(Graphics2D graphics2D) {
        TextLayout textLayout;
        Point2D.Double double_ = this.getDrawingOrigin().getPoint2D();
        double d = this.getDrawingSize().getWidth().getPoints();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(this.text.getIterator(), new FontRenderContext(null, true, true));
        while ((textLayout = lineBreakMeasurer.nextLayout((float)d)) != null) {
            double_.y += (double)textLayout.getAscent();
            float f = (float)(double_.x + d) - textLayout.getAdvance();
            textLayout.draw(graphics2D, f, (float)double_.y);
            double_.y += (double)(textLayout.getDescent() + textLayout.getLeading());
        }
    }

    private void renderLeftJustified(Graphics2D graphics2D) {
        TextLayout textLayout;
        Point2D.Double double_ = this.getDrawingOrigin().getPoint2D();
        double d = this.getDrawingSize().getWidth().getPoints();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(this.text.getIterator(), new FontRenderContext(null, true, true));
        while ((textLayout = lineBreakMeasurer.nextLayout((float)d)) != null) {
            double_.y += (double)textLayout.getAscent();
            textLayout.draw(graphics2D, (float)double_.x, (float)double_.y);
            double_.y += (double)(textLayout.getDescent() + textLayout.getLeading());
        }
    }

    private void renderFullyJustified(Graphics2D graphics2D) {
        TextLayout textLayout;
        Point2D.Double double_ = this.getDrawingOrigin().getPoint2D();
        double d = this.getDrawingSize().getWidth().getPoints();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(this.text.getIterator(), new FontRenderContext(null, true, true));
        Vector<TextLayout> vector = new Vector<TextLayout>();
        while ((textLayout = lineBreakMeasurer.nextLayout((float)d)) != null) {
            vector.add(textLayout);
        }
        for (int i = 0; i < vector.size(); ++i) {
            textLayout = (TextLayout)vector.get(i);
            TextLayout textLayout2 = i != vector.size() - 1 ? textLayout.getJustifiedLayout((float)d) : textLayout;
            double_.y += (double)textLayout2.getAscent();
            textLayout2.draw(graphics2D, (float)double_.x, (float)double_.y);
            double_.y += (double)(textLayout2.getDescent() + textLayout2.getLeading());
        }
    }

    public void setFont(Font font) {
        if (font != null) {
            this.font = font;
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setTextColor(Color color) {
        if (color != null) {
            this.textColor = color;
        }
    }

    public Color getTextColor() {
        return this.textColor;
    }
}

