/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.base.unix.FileLinkType;
import ch.systemsx.cisd.hdf5.h5ar.ArchiveEntryCompleteness;
import ch.systemsx.cisd.hdf5.h5ar.HDF5ArchiveUpdater;
import ch.systemsx.cisd.hdf5.h5ar.IdCache;
import ch.systemsx.cisd.hdf5.h5ar.LinkRecord;
import ch.systemsx.cisd.hdf5.h5ar.Utils;

public final class ArchiveEntry {
    private final String path;
    private final String parentPath;
    private final String name;
    private final String realPath;
    private final String realParentPath;
    private final String realName;
    private final ArchiveEntryCompleteness completeness;
    private final boolean hasLinkTarget;
    private final String linkTarget;
    private final FileLinkType linkType;
    private final FileLinkType verifiedLinkType;
    private final long size;
    private long verifiedSize;
    private final long lastModified;
    private final long verifiedLastModified;
    private int crc32;
    private boolean knowsChecksum;
    private int verifiedCrc32;
    private final int uid;
    private final int gid;
    private final IdCache idCache;
    private final short permissions;
    private final String errorLineOrNull;

    ArchiveEntry(String dir, String path, LinkRecord link, IdCache idCache) {
        this(dir, path, link, idCache, null);
    }

    ArchiveEntry(String dir, String path, LinkRecord link, IdCache idCache, String errorLineOrNull) {
        this.realParentPath = this.parentPath = dir != null ? dir : Utils.getParentPath(path);
        this.path = path;
        this.realPath = path;
        this.realName = this.name = link.getLinkName();
        this.idCache = idCache;
        this.completeness = link.getCompleteness();
        this.hasLinkTarget = link.tryGetLinkTarget() != null;
        this.linkTarget = this.hasLinkTarget ? link.tryGetLinkTarget() : "?";
        this.linkType = link.getLinkType();
        this.verifiedLinkType = link.getVerifiedType();
        this.size = link.getSize();
        this.verifiedSize = link.getVerifiedSize();
        this.lastModified = link.getLastModified();
        this.verifiedLastModified = link.getVerifiedLastModified();
        this.crc32 = link.getCrc32();
        this.knowsChecksum = link.hasCRC32Checksum();
        this.verifiedCrc32 = link.getVerifiedCrc32();
        this.uid = link.getUid();
        this.gid = link.getGid();
        this.permissions = link.getPermissions();
        this.errorLineOrNull = errorLineOrNull;
    }

    ArchiveEntry(ArchiveEntry pathInfo, ArchiveEntry linkInfo) {
        this.parentPath = pathInfo.parentPath;
        this.path = pathInfo.path;
        this.name = pathInfo.name;
        this.realParentPath = linkInfo.parentPath;
        this.realPath = linkInfo.realPath;
        this.realName = linkInfo.name;
        this.idCache = pathInfo.idCache;
        this.completeness = linkInfo.completeness;
        this.hasLinkTarget = linkInfo.hasLinkTarget;
        this.linkTarget = linkInfo.linkTarget;
        this.linkType = linkInfo.linkType;
        this.verifiedLinkType = linkInfo.verifiedLinkType;
        this.size = linkInfo.size;
        this.verifiedSize = linkInfo.verifiedSize;
        this.lastModified = Math.max(pathInfo.lastModified, linkInfo.lastModified);
        this.verifiedLastModified = Math.max(pathInfo.verifiedLastModified, linkInfo.verifiedLastModified);
        this.crc32 = linkInfo.crc32;
        this.knowsChecksum = linkInfo.knowsChecksum;
        this.verifiedCrc32 = linkInfo.verifiedCrc32;
        this.uid = linkInfo.uid;
        this.gid = linkInfo.gid;
        this.permissions = linkInfo.permissions;
        this.errorLineOrNull = null;
    }

    ArchiveEntry(String errorLineOrNull) {
        this.errorLineOrNull = errorLineOrNull;
        this.path = null;
        this.parentPath = null;
        this.name = null;
        this.realPath = null;
        this.realParentPath = null;
        this.realName = null;
        this.idCache = null;
        this.completeness = null;
        this.linkTarget = null;
        this.hasLinkTarget = false;
        this.linkType = null;
        this.verifiedLinkType = null;
        this.size = -1L;
        this.verifiedSize = -1L;
        this.lastModified = -1L;
        this.verifiedLastModified = -1L;
        this.crc32 = 0;
        this.verifiedCrc32 = 0;
        this.uid = -1;
        this.gid = -1;
        this.permissions = (short)-1;
    }

    void setDataSetInfo(HDF5ArchiveUpdater.DataSetInfo dataSetInfo) {
        this.verifiedSize = dataSetInfo.size;
        this.verifiedCrc32 = this.crc32 = dataSetInfo.crc32;
        this.knowsChecksum = true;
    }

    public String getPath() {
        return this.path;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public String getName() {
        return this.name;
    }

    public String getRealPath() {
        return this.realPath;
    }

    public String getRealParentPath() {
        return this.realParentPath;
    }

    public String getRealName() {
        return this.realName;
    }

    public ArchiveEntryCompleteness getCompleteness() {
        return this.completeness;
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    public boolean hasLinkTarget() {
        return this.hasLinkTarget;
    }

    public FileLinkType getLinkType() {
        return this.linkType;
    }

    public boolean isDirectory() {
        return this.linkType == FileLinkType.DIRECTORY;
    }

    public boolean isSymLink() {
        return this.linkType == FileLinkType.SYMLINK;
    }

    public boolean isRegularFile() {
        return this.linkType == FileLinkType.REGULAR_FILE;
    }

    public long getSize() {
        return this.size;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getLastModifiedStr() {
        return ArchiveEntry.getLastModifiedStr(this.lastModified);
    }

    private static String getLastModifiedStr(long lastModified) {
        if (lastModified >= 0L) {
            return String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS", lastModified * 1000L);
        }
        return "?";
    }

    public boolean hasChecksum() {
        return this.knowsChecksum;
    }

    public int getCrc32() {
        return this.crc32;
    }

    public String getCrc32Str() {
        return Utils.crc32ToString(this.crc32);
    }

    public String getUser(boolean numeric) {
        return this.uid >= 0 ? this.idCache.getUser(this.uid, numeric) : "?";
    }

    public int getUid() {
        return this.uid;
    }

    public String getGroup(boolean numeric) {
        return this.gid >= 0 ? this.idCache.getGroup(this.gid, numeric) : "?";
    }

    public int getGid() {
        return this.gid;
    }

    public short getPermissions() {
        return this.permissions;
    }

    public String getPermissionsString(boolean numeric) {
        return this.permissions >= 0 ? Utils.permissionsToString(this.permissions, this.linkType == FileLinkType.DIRECTORY, numeric) : "?";
    }

    public String tryGetErrorLine() {
        return this.errorLineOrNull;
    }

    public FileLinkType tryGetVerifiedLinkType() {
        return this.verifiedLinkType;
    }

    public long getVerifiedSize() {
        return this.verifiedSize;
    }

    public int getVerifiedCrc32() {
        return this.verifiedCrc32;
    }

    public String getVerifiedCrc32Str() {
        return Utils.crc32ToString(this.verifiedCrc32);
    }

    public long getVerifiedLastModified() {
        return this.verifiedLastModified;
    }

    public String getVerifiedLastModifiedStr() {
        return ArchiveEntry.getLastModifiedStr(this.verifiedLastModified);
    }

    public boolean hasVerificationInfo() {
        return this.verifiedLinkType != null || this.verifiedSize != -1L || this.verifiedCrc32 != 0 || this.verifiedLastModified != -1L || this.errorLineOrNull != null;
    }

    public boolean isOK() {
        return this.errorLineOrNull == null && this.linkTypeOK() && this.sizeOK() && this.lastModifiedOK() && this.checksumOK();
    }

    public boolean linkTypeOK() {
        return this.verifiedLinkType == null || this.linkType == this.verifiedLinkType;
    }

    public boolean sizeOK() {
        return this.verifiedSize == -1L || this.size == this.verifiedSize;
    }

    public boolean lastModifiedOK() {
        return this.verifiedLastModified == -1L || this.lastModified == -1L || this.lastModified == this.verifiedLastModified;
    }

    public boolean checksumOK() {
        return !this.knowsChecksum || this.verifiedSize == -1L || this.crc32 == this.verifiedCrc32;
    }

    public String getStatus(boolean verbose) {
        if (!this.isOK()) {
            if (this.errorLineOrNull != null) {
                return "ERROR: " + this.errorLineOrNull;
            }
            if (!this.linkTypeOK()) {
                return verbose ? String.format("ERROR: Entry '%s' failed link type test, expected: %s, found: %s.", this.path, this.linkType, this.verifiedLinkType) : "WRONG TYPE";
            }
            if (!this.sizeOK()) {
                return verbose ? String.format("ERROR: Entry '%s' failed size test, expected: %d, found: %d.", this.path, this.size, this.verifiedSize) : "WRONG SIZE";
            }
            if (!this.checksumOK()) {
                return verbose ? String.format("ERROR: Entry '%s' failed CRC checksum test, expected: %s, found: %s.", this.path, Utils.crc32ToString(this.crc32), Utils.crc32ToString(this.verifiedCrc32)) : "WRONG CRC32";
            }
            if (!this.lastModifiedOK()) {
                return verbose ? String.format("ERROR: Entry '%s' failed last modification test, expected: %s, found: %s.", this.path, this.getLastModifiedStr(), this.getVerifiedLastModifiedStr()) : "WRONG LASTMODIFICATION";
            }
        }
        return "OK";
    }

    public String describeLink() {
        return this.describeLink(true, false, true);
    }

    public String describeLink(boolean verbose) {
        return this.describeLink(verbose, false, true);
    }

    public String describeLink(boolean verbose, boolean numeric) {
        return this.describeLink(verbose, numeric, true);
    }

    public String describeLink(boolean verbose, boolean numeric, boolean includeCheck) {
        StringBuilder builder = new StringBuilder();
        if (!verbose) {
            builder.append(this.path);
        } else {
            switch (this.completeness) {
                case BASE: {
                    if (this.linkType == FileLinkType.SYMLINK) {
                        builder.append(String.format("          \t%s -> %s", this.path, this.linkTarget));
                        break;
                    }
                    if (this.linkType == FileLinkType.DIRECTORY) {
                        builder.append(String.format("       DIR\t%s", this.path));
                        break;
                    }
                    builder.append(String.format("%10d\t%s\t%s%s", this.size, Utils.crc32ToString(this.crc32), this.path, this.linkType == FileLinkType.REGULAR_FILE ? "" : "\t*"));
                    break;
                }
                case LAST_MODIFIED: {
                    if (this.linkType == FileLinkType.SYMLINK) {
                        builder.append(String.format("          \t%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS\t%2$s -> %3$s", this.lastModified * 1000L, this.path, this.linkTarget));
                        break;
                    }
                    if (this.linkType == FileLinkType.DIRECTORY) {
                        builder.append(String.format("       DIR\t%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS\t%2$s", this.lastModified * 1000L, this.path));
                        break;
                    }
                    builder.append(String.format("%10d\t%2$tY-%2$tm-%2$td %2$tH:%2$tM:%2$tS\t%3$s\t%4$s%5$s", this.size, this.lastModified * 1000L, Utils.crc32ToString(this.crc32), this.path, this.linkType == FileLinkType.REGULAR_FILE ? "" : "\t*"));
                    break;
                }
                case FULL: {
                    if (this.linkType == FileLinkType.SYMLINK) {
                        builder.append(String.format("%s\t%s\t%s\t          \t%4$tY-%4$tm-%4$td %4$tH:%4$tM:%4$tS\t        \t%5$s -> %6$s", Utils.permissionsToString(this.permissions, false, numeric), this.getUser(numeric), this.getGroup(numeric), this.lastModified * 1000L, this.path, this.linkTarget));
                        break;
                    }
                    if (this.linkType == FileLinkType.DIRECTORY) {
                        builder.append(String.format("%s\t%s\t%s\t       DIR\t%4$tY-%4$tm-%4$td %4$tH:%4$tM:%4$tS\t        \t%5$s", Utils.permissionsToString(this.permissions, true, numeric), this.getUser(numeric), this.getGroup(numeric), this.lastModified * 1000L, this.path));
                        break;
                    }
                    builder.append(String.format("%s\t%s\t%s\t%10d\t%5$tY-%5$tm-%5$td %5$tH:%5$tM:%5$tS\t%6$s\t%7$s%8$s", Utils.permissionsToString(this.permissions, false, numeric), this.getUser(numeric), this.getGroup(numeric), this.size, this.lastModified * 1000L, Utils.crc32ToString(this.crc32), this.path, this.linkType == FileLinkType.REGULAR_FILE ? "" : "\t*"));
                    break;
                }
                default: {
                    throw new Error("Unknown level of link completeness: " + (Object)((Object)this.completeness));
                }
            }
        }
        if (includeCheck && this.hasVerificationInfo()) {
            builder.append('\t');
            builder.append(this.getStatus(false));
        }
        return builder.toString();
    }

    public String toString() {
        return this.describeLink();
    }
}

