/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Board;
import edsim51di.Gui;
import edsim51di.Motor;
import edsim51di.MotorAnimation;
import edsim51di.PeripheralMainPanel;
import edsim51sh.EdSim51Button;
import edsim51sh.InfoButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class MotorGraphics
extends PeripheralMainPanel
implements ActionListener,
ChangeListener {
    private InfoButton infoButton = new InfoButton(this, "The motor can be rotated either clockwise or anticlockwise.\nIts direction is controlled by motor control bit 0 and motor control bit 1\n(inputs A and B to the bridge driver in the logic diagram).\n\nBit 0 (A)   Bit 1 (B)\n    0               0             off\n    0               1             anticlockwise\n    1               0             clockwise\n    1               1             off\n\nThe sensor produces a logic zero whenever the motor arm lines up with it.\n\nThe speed of the motor is not controlled by the 8051.\n\nIf the update frequency is high, it is difficult to perceive the motor's direction.\nTherefore, when the motor is running, a blue arrow indicates its direction.\nReduce the update frequency to 1 to clearly see the motor rotating.", "EdSim51DI - Motor Information", "information");
    private JPanel sliderPanel = new JPanel();
    private JSlider slider = new JSlider();
    private EdSim51Button disableButton = new EdSim51Button();
    private JLabel maxLabel = new JLabel("MAX");
    private JLabel minLabel = new JLabel("MIN");
    private Dimension sliderDimensionSmall = new Dimension(20, 80);
    private Dimension sliderDimensionLarge = new Dimension(30, 120);
    private Color grey = new Color(230, 230, 230);
    private Board board;
    private Motor motor;
    private MotorAnimation motorAnimation = new MotorAnimation();

    MotorGraphics(Board board, Motor motor) {
        this.board = board;
        this.motor = motor;
        this.setLayout(new GridBagLayout());
        this.sliderPanel.setBackground(Color.WHITE);
        this.sliderPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.slider.setOrientation(1);
        this.slider.setMinimum(0);
        this.slider.setMaximum(10);
        this.slider.setValue(5);
        this.slider.setToolTipText("motor current");
        this.slider.addChangeListener(this);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 3;
        this.sliderPanel.add((Component)this.slider, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.sliderPanel.add((Component)this.maxLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(15, 0, 0, 0);
        this.sliderPanel.add((Component)this.infoButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 15;
        this.sliderPanel.add((Component)this.minLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.sliderPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.add((Component)this.motorAnimation, gbc);
        this.setEnableButtonTextAndPanelBackground();
        this.disableButton.setMargin(new Insets(1, 1, 1, 1));
        this.disableButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.disableButton, gbc);
        this.setEnableButtonTextAndPanelBackground();
    }

    MotorAnimation getMotorAnimation() {
        return this.motorAnimation;
    }

    int getMotorSpeed() {
        return this.slider.getValue();
    }

    @Override
    void setSize(boolean small) {
        Dimension d;
        int size;
        if (small) {
            size = 12;
            d = this.sliderDimensionSmall;
        } else {
            size = 18;
            d = this.sliderDimensionLarge;
        }
        Gui.setSize(this.slider, d);
        Gui.setFont(this.maxLabel, 1, size);
        Gui.setFont(this.minLabel, 1, size);
        this.disableButton.setSize("Motor Enabled", "Motor Disabled", 1, size);
        this.motorAnimation.setSize(small);
        this.infoButton.setSize(small);
    }

    private void setEnableButtonTextAndPanelBackground() {
        if (this.motor.isEnabled()) {
            this.disableButton.setText("Motor Enabled");
            this.setBackground(Color.WHITE);
            this.sliderPanel.setBackground(Color.WHITE);
            this.motorAnimation.setBackground(Color.WHITE);
        } else {
            this.disableButton.setText("Motor Disabled");
            this.setBackground(this.grey);
            this.sliderPanel.setBackground(this.grey);
            this.motorAnimation.setBackground(this.grey);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.disableButton) {
            if (this.motor.isEnabled()) {
                this.motor.disable();
                this.board.setHardwareSetting("motor", "D");
            } else {
                this.motor.enable();
                this.board.setHardwareSetting("motor", "E");
            }
            this.setEnableButtonTextAndPanelBackground();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (event.getSource() == this.slider) {
            this.motor.setCurrent(12 - this.slider.getValue());
        }
    }
}

