/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

final class CustomButtonDialog {
    CustomButtonDialog() {
    }

    private void selectInvalidCommand(JTextArea jTextArea, String string) {
        int n = jTextArea.getText().indexOf(string);
        jTextArea.select(n, n + string.length());
        jTextArea.requestFocusInWindow();
    }

    private boolean isValid(JTextArea jTextArea, JDialog jDialog) {
        String[] stringArray = jTextArea.getText().trim().split(" +");
        if (stringArray.length == 1 && stringArray[0].isEmpty()) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Command command;
            try {
                command = Command.valueOf(stringArray[i]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(jDialog, "Invalid command " + stringArray[i].substring(0, Math.min(stringArray[i].length(), 100)), "Calcoo Command Validation", 0);
                this.selectInvalidCommand(jTextArea, stringArray[i]);
                return false;
            }
            if (!Command.invalidForCustomCommandSequence.contains((Object)command)) continue;
            JOptionPane.showMessageDialog(jDialog, "Command " + stringArray[i] + " is not valid for the custom button sequence", "Calcoo Command Validation", 0);
            this.selectInvalidCommand(jTextArea, stringArray[i]);
            return false;
        }
        return true;
    }

    private void tidyUp(JTextArea jTextArea) {
        jTextArea.setText(jTextArea.getText().trim().replaceAll(" +", " "));
    }

    void run(final StringBuilder stringBuilder, JFrame jFrame) {
        JComponent jComponent;
        Object object2;
        JComponent jComponent2;
        final JDialog jDialog = new JDialog(jFrame, "Custom Button Command", true);
        jDialog.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("<html>Input the custom command to invoke by the <b>\u25c7</b> button.<br>It should be composed of the commands listed below the input field, separated by spaces.</html>");
        jPanel.add(jLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.fill = 1;
        jDialog.add((Component)jPanel, gridBagConstraints);
        final JTextArea jTextArea = new JTextArea(stringBuilder.toString(), 5, 20);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jTextArea.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.fill = 1;
        jDialog.add((Component)jScrollPane, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>(Arrays.asList(new ArrayList<ArrayList>(Arrays.asList(new ArrayList<String>(Arrays.asList("LOG10", "TENTOX", "LN", "ETOX", "POW")), new ArrayList<String>(Arrays.asList("SQRT", "SQR", "INVX", "PI", "FACT")), new ArrayList<String>(Arrays.asList("SIN", "ASIN", "SINH", "ASINH")), new ArrayList<String>(Arrays.asList("COS", "ACOS", "COSH", "ACOSH")), new ArrayList<String>(Arrays.asList("TAN", "ATAN", "TANH", "ATANH")))), new ArrayList<ArrayList>(Arrays.asList(new ArrayList<String>(Arrays.asList("DIGIT_7", "DIGIT_8", "DIGIT_9")), new ArrayList<String>(Arrays.asList("DIGIT_4", "DIGIT_5", "DIGIT_6")), new ArrayList<String>(Arrays.asList("DIGIT_1", "DIGIT_2", "DIGIT_3")), new ArrayList<String>(Arrays.asList("DIGIT_0", "DOT", "MANTISSA_SIGN")), new ArrayList<String>(Arrays.asList("SIGN", "EXP", "EXP_SIGN")))), new ArrayList<ArrayList>(Arrays.asList(new ArrayList<String>(Arrays.asList("ADD", "SUB", "MUL", "DIV", "CLEAR_ALL")), new ArrayList<String>(Arrays.asList("EXCH_XY", "LEFT_PAREN", "RIGHT_PAREN", "EQ")), new ArrayList<String>(Arrays.asList("STACK_DOWN", "STACK_UP", "ENTER", "CLEAR_X")), new ArrayList<String>(Arrays.asList("MEM_TO_X", "MEM_PLUS", "X_TO_MEM")), new ArrayList<String>(Arrays.asList("X_TO_MEM", "MEM0", "MEM1"))))));
        for (int i = 0; i < arrayList.size(); ++i) {
            int n = 0;
            while (n < arrayList.get(i).size()) {
                jComponent2 = new JPanel();
                for (Object object2 : (ArrayList)arrayList.get(i).get(n)) {
                    jComponent = new JLabel((String)object2);
                    jComponent.addMouseListener(new MouseProcessor((JLabel)jComponent, jTextArea));
                    jComponent2.add(jComponent);
                }
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = i;
                gridBagConstraints.gridy = n++;
                gridBagConstraints.fill = 1;
                jPanel2.add((Component)jComponent2, gridBagConstraints);
            }
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.fill = 1;
        jDialog.add((Component)jPanel2, gridBagConstraints);
        JButton jButton = new JButton("Save");
        abstract class ButtonListener
        implements ActionListener {
            ButtonListener() {
            }
        }
        jButton.addActionListener(new ButtonListener(){
            {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CustomButtonDialog.this.isValid(jTextArea, jDialog)) {
                    CustomButtonDialog.this.tidyUp(jTextArea);
                    stringBuilder.setLength(0);
                    stringBuilder.append(jTextArea.getText());
                    jDialog.dispose();
                }
            }
        });
        JPanel jPanel3 = new JPanel();
        jComponent2 = new JButton("Validate");
        ((AbstractButton)jComponent2).addActionListener(new ButtonListener(){
            {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CustomButtonDialog.this.isValid(jTextArea, jDialog)) {
                    JOptionPane.showMessageDialog(jDialog, "Validation passed", "Calcoo Command Validation", 1);
                }
            }
        });
        JButton jButton2 = new JButton("Tidy Up");
        jButton2.addActionListener(new ButtonListener(){
            {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomButtonDialog.this.tidyUp(jTextArea);
            }
        });
        object2 = new JButton("Cancel");
        ((AbstractButton)object2).addActionListener(new ButtonListener(){
            {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jPanel3.setLayout(new GridLayout(1, 3));
        jPanel3.add(jButton);
        jPanel3.add(jComponent2);
        jPanel3.add(jButton2);
        jPanel3.add((Component)object2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.fill = 1;
        jDialog.add((Component)jPanel3, gridBagConstraints);
        jComponent = jDialog.getRootPane();
        InputMap inputMap = jComponent.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "OK");
        jComponent.getActionMap().put("OK", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                stringBuilder.setLength(0);
                stringBuilder.append(jTextArea.getText());
                jDialog.dispose();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "Cancel");
        jComponent.getActionMap().put("Cancel", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jDialog.setLocationRelativeTo(jFrame);
        jDialog.pack();
        jButton.requestFocusInWindow();
        jDialog.setResizable(false);
        jDialog.setVisible(true);
    }

    private class MouseProcessor
    implements MouseListener {
        private final JLabel label;
        private final JTextArea textArea;

        public MouseProcessor(JLabel jLabel, JTextArea jTextArea) {
            this.label = jLabel;
            this.textArea = jTextArea;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.label.setCursor(new Cursor(12));
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.label.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.textArea.insert(this.label.getText() + " ", this.textArea.getCaretPosition());
        }
    }
}

